/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;

public class DisplayModifierRecipe
implements IDisplayModifierRecipe {
    @Nullable
    private final ResourceLocation recipeId;
    private final List<List<ItemStack>> inputs;
    private final List<ItemStack> toolWithoutModifier;
    private final List<ItemStack> toolWithModifier;
    private final ModifierEntry displayResult;
    private final IntRange level;
    @Nullable
    private final SlotType.SlotCount slots;
    private final List<SlotType.SlotCount> resultSlots;
    private final boolean incremental;

    @Deprecated(forRemoval=true)
    public DisplayModifierRecipe(@Nullable ResourceLocation id, List<SizedIngredient> inputs, List<ItemStack> toolWithoutModifier, List<ItemStack> toolWithModifier, ModifierEntry displayResult, IntRange level, @Nullable SlotType.SlotCount slots, List<SlotType.SlotCount> resultSlots) {
        this(id, DisplayModifierRecipe.resolve(inputs), toolWithoutModifier, toolWithModifier, displayResult, level, slots, resultSlots, false);
    }

    @Deprecated(forRemoval=true)
    public DisplayModifierRecipe(List<SizedIngredient> inputs, List<ItemStack> toolWithoutModifier, List<ItemStack> toolWithModifier, ModifierEntry displayResult, IntRange level, @Nullable SlotType.SlotCount slots, List<SlotType.SlotCount> resultSlots) {
        this(null, inputs, toolWithoutModifier, toolWithModifier, displayResult, level, slots, resultSlots);
    }

    @Deprecated(forRemoval=true)
    public DisplayModifierRecipe(List<SizedIngredient> inputs, List<ItemStack> toolWithoutModifier, List<ItemStack> toolWithModifier, ModifierEntry displayResult, IntRange level, @Nullable SlotType.SlotCount slots) {
        this(inputs, toolWithoutModifier, toolWithModifier, displayResult, level, slots, List.of());
    }

    @Override
    public int getInputCount() {
        return this.inputs.size();
    }

    @Override
    public List<ItemStack> getDisplayItems(int slot) {
        if (slot >= 0 && slot < this.inputs.size()) {
            return this.inputs.get(slot);
        }
        return Collections.emptyList();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static List<List<ItemStack>> resolve(List<SizedIngredient> ingredients) {
        return ingredients.stream().map(SizedIngredient::getMatchingStacks).toList();
    }

    private DisplayModifierRecipe(@Nullable ResourceLocation recipeId, List<List<ItemStack>> inputs, List<ItemStack> toolWithoutModifier, List<ItemStack> toolWithModifier, ModifierEntry displayResult, IntRange level, @Nullable SlotType.SlotCount slots, List<SlotType.SlotCount> resultSlots, boolean incremental) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.toolWithoutModifier = toolWithoutModifier;
        this.toolWithModifier = toolWithModifier;
        this.displayResult = displayResult;
        this.level = level;
        this.slots = slots;
        this.resultSlots = resultSlots;
        this.incremental = incremental;
    }

    @Override
    @Nullable
    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    @Override
    public List<ItemStack> getToolWithoutModifier() {
        return this.toolWithoutModifier;
    }

    @Override
    public List<ItemStack> getToolWithModifier() {
        return this.toolWithModifier;
    }

    @Override
    public ModifierEntry getDisplayResult() {
        return this.displayResult;
    }

    @Override
    public IntRange getLevel() {
        return this.level;
    }

    @Override
    @Nullable
    public SlotType.SlotCount getSlots() {
        return this.slots;
    }

    @Override
    public List<SlotType.SlotCount> getResultSlots() {
        return this.resultSlots;
    }

    @Override
    public boolean isIncremental() {
        return this.incremental;
    }

    public static class Builder {
        private ModifierEntry result = ModifierEntry.EMPTY;
        @Nullable
        private ResourceLocation id = null;
        private List<List<ItemStack>> inputs = List.of();
        private List<ItemStack> toolWithoutModifier = List.of();
        private List<ItemStack> toolWithModifier = List.of();
        private IntRange level = ModifierEntry.VALID_LEVEL;
        @Nullable
        private SlotType.SlotCount slots = null;
        private List<SlotType.SlotCount> resultSlots = List.of();
        private boolean incremental = false;

        public Builder copy() {
            Builder copy = new Builder();
            copy.id = this.id;
            copy.inputs = this.inputs;
            copy.toolWithoutModifier = this.toolWithoutModifier;
            copy.toolWithModifier = this.toolWithModifier;
            copy.level = this.level;
            copy.slots = this.slots;
            copy.result = this.result;
            copy.resultSlots = this.resultSlots;
            copy.incremental = this.incremental;
            return copy;
        }

        public Builder ingredients(List<SizedIngredient> inputs) {
            return this.inputs(DisplayModifierRecipe.resolve(inputs));
        }

        public Builder incremental() {
            return this.incremental(true);
        }

        public DisplayModifierRecipe build() {
            if (this.result == ModifierEntry.EMPTY) {
                throw new IllegalStateException("Must set result");
            }
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("Must set inputs");
            }
            if (this.toolWithoutModifier.isEmpty()) {
                throw new IllegalStateException("Must set tools without modifier");
            }
            if (this.toolWithModifier.isEmpty()) {
                throw new IllegalStateException("Must set tools with modifier");
            }
            return new DisplayModifierRecipe(this.id, this.inputs, this.toolWithoutModifier, this.toolWithModifier, this.result, this.level, this.slots, this.resultSlots, this.incremental);
        }

        public Builder result(ModifierEntry result) {
            this.result = result;
            return this;
        }

        public Builder id(@Nullable ResourceLocation id) {
            this.id = id;
            return this;
        }

        public Builder inputs(List<List<ItemStack>> inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder toolWithoutModifier(List<ItemStack> toolWithoutModifier) {
            this.toolWithoutModifier = toolWithoutModifier;
            return this;
        }

        public Builder toolWithModifier(List<ItemStack> toolWithModifier) {
            this.toolWithModifier = toolWithModifier;
            return this;
        }

        public Builder level(IntRange level) {
            this.level = level;
            return this;
        }

        public Builder slots(@Nullable SlotType.SlotCount slots) {
            this.slots = slots;
            return this;
        }

        public Builder resultSlots(List<SlotType.SlotCount> resultSlots) {
            this.resultSlots = resultSlots;
            return this;
        }

        public Builder incremental(boolean incremental) {
            this.incremental = incremental;
            return this;
        }

        private Builder() {
        }
    }
}

