/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate.tool;

import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.json.predicate.modifier.SingleModifierPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public record HasModifierPredicate(IJsonPredicate<ModifierId> modifier, IntRange level, ModifierCheck check) implements ToolContextPredicate
{
    public static final RecordLoadable<HasModifierPredicate> LOADER = RecordLoadable.create((RecordField)ModifierPredicate.LOADER.requiredField("modifier", HasModifierPredicate::modifier), (RecordField)ModifierEntry.ANY_LEVEL.defaultField("level", ModifierEntry.VALID_LEVEL, HasModifierPredicate::level), (RecordField)ModifierCheck.LOADABLE.requiredField("check", HasModifierPredicate::check), HasModifierPredicate::new);

    public HasModifierPredicate(ModifierId modifier, IntRange level, ModifierCheck check) {
        this(new SingleModifierPredicate(modifier), level, check);
    }

    public boolean matches(IToolContext tool) {
        for (ModifierEntry entry : this.check.getModifiers(tool).getModifiers()) {
            if (!this.modifier.matches((Object)entry.getId())) continue;
            return this.level.test(entry.intEffectiveLevel());
        }
        return this.level.test(0);
    }

    @Override
    public IJsonPredicate<IToolContext> inverted() {
        if (this.level.max() == ModifierEntry.ANY_LEVEL.max()) {
            return new HasModifierPredicate(this.modifier, new IntRange(ModifierEntry.ANY_LEVEL.min(), this.level.min() - 1), this.check);
        }
        if (this.level.min() == ModifierEntry.ANY_LEVEL.min()) {
            return new HasModifierPredicate(this.modifier, new IntRange(this.level.max() + 1, ModifierEntry.ANY_LEVEL.max()), this.check);
        }
        return ToolContextPredicate.super.inverted();
    }

    public RecordLoadable<? extends ToolContextPredicate> getLoader() {
        return LOADER;
    }

    public static HasModifierPredicate hasUpgrade(IJsonPredicate<ModifierId> modifier, int min) {
        return new HasModifierPredicate(modifier, ModifierEntry.VALID_LEVEL.min(min), ModifierCheck.UPGRADES);
    }

    public static HasModifierPredicate hasModifier(IJsonPredicate<ModifierId> modifier, int min) {
        return new HasModifierPredicate(modifier, ModifierEntry.VALID_LEVEL.min(min), ModifierCheck.ALL);
    }

    public static HasModifierPredicate hasUpgrade(ModifierId modifier, int min) {
        return new HasModifierPredicate(modifier, ModifierEntry.ANY_LEVEL.min(min), ModifierCheck.UPGRADES);
    }

    public static HasModifierPredicate hasModifier(ModifierId modifier, int min) {
        return new HasModifierPredicate(modifier, ModifierEntry.ANY_LEVEL.min(min), ModifierCheck.ALL);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ModifierCheck {
        UPGRADES{

            @Override
            public ModifierNBT getModifiers(IToolContext tool) {
                return tool.getUpgrades();
            }
        }
        ,
        ALL{

            @Override
            public ModifierNBT getModifiers(IToolContext tool) {
                return tool.getModifiers();
            }
        };

        public static final EnumLoadable<ModifierCheck> LOADABLE;

        public abstract ModifierNBT getModifiers(IToolContext var1);

        static {
            LOADABLE = new EnumLoadable(ModifierCheck.class);
        }
    }
}

