/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.general;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.events.teleport.EnderportingTeleportEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MonsterMeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileFuseModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.PlantHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.utils.TeleportHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class EnderportingModifier
extends NoLevelsModifier
implements PlantHarvestModifierHook,
ProjectileHitModifierHook,
ProjectileLaunchModifierHook,
BlockHarvestModifierHook,
MeleeHitModifierHook,
MonsterMeleeHitModifierHook.RedirectAfter,
ProjectileFuseModifierHook {
    private static final ResourceLocation SECONDARY_ARROW = TConstruct.getResource("enderporting_secondary");

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.PLANT_HARVEST, ModifierHooks.PROJECTILE_HIT, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.BLOCK_HARVEST, ModifierHooks.MELEE_HIT, ModifierHooks.MONSTER_MELEE_HIT, ModifierHooks.PROJECTILE_FUSE);
    }

    @Override
    public int getPriority() {
        return 45;
    }

    private static boolean tryTeleport(ModifierEntry modifier, LivingEntity living, double x, double y, double z) {
        Level world = living.m_20193_();
        if (world.f_46443_) {
            return false;
        }
        float scaledWidth = living.m_20205_() * 0.8f;
        float eyeHeight = living.m_20192_();
        AABB aabb = AABB.m_165882_((Vec3)new Vec3(x, y + (double)(eyeHeight / 2.0f), z), (double)scaledWidth, (double)eyeHeight, (double)scaledWidth);
        boolean didCollide = world.m_186434_((Entity)living, aabb).iterator().hasNext();
        if (didCollide && living.m_20206_() > 1.0f) {
            aabb = aabb.m_82386_(0.0, -1.0, 0.0);
            didCollide = world.m_186434_((Entity)living, aabb).iterator().hasNext();
            y -= 1.0;
        }
        if (!didCollide) {
            return TeleportHelper.tryTeleport(new EnderportingTeleportEvent((Entity)living, x, y, z, modifier));
        }
        return false;
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity target;
        if (!context.isExtraAttack() && (target = context.getLivingTarget()) != null) {
            LivingEntity attacker = context.getAttacker();
            Vec3 oldPosition = attacker.m_20182_();
            if (EnderportingModifier.tryTeleport(modifier, attacker, target.m_20185_(), target.m_20186_(), target.m_20189_())) {
                EnderportingModifier.tryTeleport(modifier, target, oldPosition.f_82479_, oldPosition.f_82480_, oldPosition.f_82481_);
                ToolDamageUtil.damageAnimated(tool, 2, attacker, context.getSlotType(), true);
            }
        }
    }

    @Override
    public void finishHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, int harvested) {
        if (harvested > 0 && context.canHarvest()) {
            BlockPos pos = context.getPos();
            LivingEntity living = context.getLiving();
            if (EnderportingModifier.tryTeleport(modifier, living, (float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f)) {
                ToolDamageUtil.damageAnimated(tool, 2, living, EquipmentSlot.MAINHAND, true);
            }
        }
    }

    @Override
    public void afterHarvest(IToolStackView tool, ModifierEntry modifier, UseOnContext context, ServerLevel world, BlockState state, BlockPos pos) {
        Player living;
        if (context.m_8083_().equals((Object)pos) && (living = context.m_43723_()) != null && EnderportingModifier.tryTeleport(modifier, (LivingEntity)living, (float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f)) {
            ToolDamageUtil.damageAnimated(tool, 2, (LivingEntity)living, context.m_43724_(), true);
        }
    }

    private static boolean canTeleport(ModDataNBT persistentData) {
        return !persistentData.getBoolean(SECONDARY_ARROW);
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (attacker != null && attacker != target && EnderportingModifier.canTeleport(persistentData)) {
            Entity hitEntity = hit.m_82443_();
            Vec3 oldPosition = attacker.m_20182_();
            if (attacker.m_9236_() == projectile.m_9236_() && EnderportingModifier.tryTeleport(modifier, attacker, hitEntity.m_20185_(), hitEntity.m_20186_(), hitEntity.m_20189_()) && target != null && EnderportingModifier.tryTeleport(modifier, target, oldPosition.f_82479_, oldPosition.f_82480_, oldPosition.f_82481_)) {
                ModifierUtil.updateFishingRod(projectile, 10, false);
            }
        }
        return false;
    }

    @Override
    public void onProjectileHitBlock(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, BlockHitResult hit, @Nullable LivingEntity attacker) {
        if (attacker != null && EnderportingModifier.canTeleport(persistentData)) {
            BlockPos target = hit.m_82425_().m_121945_(hit.m_82434_());
            if (attacker.m_9236_() == projectile.m_9236_() && EnderportingModifier.tryTeleport(modifier, attacker, (float)target.m_123341_() + 0.5f, target.m_123342_(), (float)target.m_123343_() + 0.5f) && !projectile.m_6095_().m_204039_(TinkerTags.EntityTypes.REUSABLE_AMMO)) {
                ModifierUtil.updateFishingRod(projectile, 10, true);
                projectile.m_146870_();
            }
        }
    }

    @Override
    public void onProjectileFuseFinish(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, ItemStack ammo, Projectile projectile, @Nullable AbstractArrow arrow) {
        LivingEntity attacker;
        Entity entity;
        if (EnderportingModifier.canTeleport(persistentData) && (entity = projectile.m_19749_()) instanceof LivingEntity && (attacker = (LivingEntity)entity).m_9236_() == projectile.m_9236_()) {
            Vec3 target = projectile.m_20182_();
            if (EnderportingModifier.tryTeleport(modifier, attacker, target.f_82479_, target.f_82480_, target.f_82481_)) {
                ModifierUtil.updateFishingRod(projectile, 10, true);
            }
        }
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        if (primary) {
            if (projectile.m_6095_() != TinkerTools.fishingHook.get()) {
                ToolDamageUtil.damageAnimated(tool, 10, shooter, shooter.m_7655_(), true);
            }
        } else {
            persistentData.putBoolean(SECONDARY_ARROW, true);
        }
    }
}

