/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.Property;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.inventory.MultiModuleContainerMenu;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.MultitankFuelModule;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiFuelModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiMeltingModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiSmelteryTank;
import slimeknights.tconstruct.smeltery.client.screen.module.HeatingStructureSideInventoryScreen;
import slimeknights.tconstruct.smeltery.menu.HeatingStructureContainerMenu;

public class HeatingStructureScreen
extends MultiModuleScreen<HeatingStructureContainerMenu>
implements IScreenWithFluidTank {
    public static final ResourceLocation BACKGROUND = TConstruct.getResource("textures/gui/heating_structure.png");
    private static final ElementScreen SCALA = new ElementScreen(BACKGROUND, 176, 0, 80, 106, 256, 256);
    private static final ElementScreen MODE_AUTO = SCALA.move(176, 186, 16, 16);
    private static final ElementScreen MODE_EMPTY = MODE_AUTO.shift(16, 0);
    private static final ElementScreen MODE_FILL = MODE_EMPTY.shift(16, 0);
    private static final ElementScreen BUCKET_ICON = MODE_FILL.shift(16, 0);
    private static final ElementScreen BUTTON_HOVER = SCALA.move(176, 202, 18, 18);
    private static final Component TOOLTIP_CLICKABLE = TConstruct.makeTranslation("gui", "tank.bucket.clickable").m_130940_(ChatFormatting.GRAY);
    private static final List<Component> TOOLTIP_AUTO = HeatingStructureScreen.makeBucketTooltip("auto");
    private static final List<Component> TOOLTIP_EMPTY = HeatingStructureScreen.makeBucketTooltip("empty_item");
    private static final List<Component> TOOLTIP_FILL = HeatingStructureScreen.makeBucketTooltip("fill_item");
    private final HeatingStructureSideInventoryScreen sideInventory;
    private final HeatingStructureBlockEntity te;
    private final GuiSmelteryTank tank;
    public final GuiMeltingModule melting;
    private final GuiFuelModule fuel;

    private static List<Component> makeBucketTooltip(String name) {
        return List.of(TConstruct.makeTranslation("gui", "tank.bucket." + name + ".title"), TConstruct.makeTranslation("gui", "tank.bucket." + name + ".description").m_130940_(ChatFormatting.GRAY), TOOLTIP_CLICKABLE);
    }

    public HeatingStructureScreen(HeatingStructureContainerMenu container, Inventory playerInventory, Component title) {
        super((MultiModuleContainerMenu)container, playerInventory, title);
        this.f_97727_ = 220;
        HeatingStructureBlockEntity te = (HeatingStructureBlockEntity)container.getTile();
        if (te != null) {
            this.te = te;
            this.tank = new GuiSmelteryTank((AbstractContainerScreen<?>)this, te.getTank(), 8, 16, 106, 106, Objects.requireNonNull(BuiltInRegistries.f_257049_.m_7981_((Object)te.m_58903_())));
            int slots = te.getMeltingInventory().getSlots();
            this.sideInventory = new HeatingStructureSideInventoryScreen(this, container.getSideInventory(), playerInventory, slots, HeatingStructureContainerMenu.calcColumns(slots));
            this.addModule(this.sideInventory);
            MultitankFuelModule fuelModule = te.getFuelModule();
            this.melting = new GuiMeltingModule((AbstractContainerScreen<?>)this, te.getMeltingInventory(), 2, fuelModule::getTemperature, this.sideInventory::shouldDrawSlot, BACKGROUND);
            this.fuel = new GuiFuelModule((AbstractContainerScreen<?>)this, fuelModule, 152, 32, 16, 90, 153, 15, false, BACKGROUND);
        } else {
            this.te = null;
            this.tank = null;
            this.melting = null;
            this.fuel = null;
            this.sideInventory = null;
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.te == null || !((Boolean)this.te.m_58900_().m_61143_((Property)ControllerBlock.IN_STRUCTURE)).booleanValue() || this.te.getMeltingInventory().getSlots() != this.sideInventory.getSlotCount()) {
            this.m_7379_();
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.drawBackground(graphics, this, BACKGROUND);
        if (this.fuel != null) {
            this.fuel.draw(graphics);
        }
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.renderFluids(graphics.m_280168_());
        }
    }

    private boolean bucketButtonHovered(int mouseX, int mouseY) {
        return GuiUtil.isHovered(mouseX, mouseY, 124, 69, 18, 18);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        SCALA.draw(graphics, 8, 16, 110);
        if (((HeatingStructureContainerMenu)this.f_97732_).getBucketContainer().m_8020_(0).m_41619_()) {
            BUCKET_ICON.draw(graphics, 125, 46);
        }
        if (this.bucketButtonHovered(mouseX - this.f_97735_, mouseY - this.f_97736_)) {
            BUTTON_HOVER.draw(graphics, 124, 69);
        }
        (switch (((HeatingStructureContainerMenu)this.f_97732_).getTransferDirection()) {
            default -> MODE_AUTO;
            case IFluidContainerTransfer.TransferDirection.EMPTY_ITEM -> MODE_EMPTY;
            case IFluidContainerTransfer.TransferDirection.FILL_ITEM -> MODE_FILL;
        }).draw(graphics, 125, 70);
        if (this.tank != null) {
            this.tank.renderHighlight(graphics, mouseX, mouseY);
        }
        if (this.fuel != null) {
            this.fuel.renderHighlight(graphics, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.melting != null) {
            this.melting.drawHeatBars(graphics);
        }
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        if (this.bucketButtonHovered(mouseX - this.f_97735_, mouseY - this.f_97736_)) {
            graphics.m_280677_(this.f_96547_, switch (((HeatingStructureContainerMenu)this.f_97732_).getTransferDirection()) {
                default -> TOOLTIP_AUTO;
                case IFluidContainerTransfer.TransferDirection.EMPTY_ITEM -> TOOLTIP_EMPTY;
                case IFluidContainerTransfer.TransferDirection.FILL_ITEM -> TOOLTIP_FILL;
            }, Optional.empty(), mouseX, mouseY);
        }
        if (this.tank != null) {
            this.tank.drawTooltip(graphics, mouseX, mouseY);
        }
        if (this.fuel != null) {
            boolean hasTank = false;
            if (this.te.getStructure() != null) {
                hasTank = this.te.getStructure().hasTanks();
            }
            this.fuel.addTooltip(graphics, mouseX, mouseY, hasTank);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        assert (this.f_96541_ != null && this.f_96541_.f_91074_ != null && this.f_96541_.f_91072_ != null);
        if (!this.f_96541_.f_91074_.m_5833_()) {
            int index;
            int checkX = (int)mouseX - this.cornerX;
            int checkY = (int)mouseY - this.cornerY;
            if (button == 0 && this.bucketButtonHovered(checkX, checkY) && ((HeatingStructureContainerMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, 0)) {
                this.f_96541_.f_91072_.m_105208_(((HeatingStructureContainerMenu)this.f_97732_).f_38840_, 0);
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            if ((button == 0 || button == 1) && this.fuel != null && this.fuel.tryClick(checkX, checkY, button, 1)) {
                return true;
            }
            if (this.tank != null && (button == 0 || button == 1) && (index = button == 1 && this.tank.withinTank(checkX, checkY) ? 3 : this.tank.getFluidClicked(checkX, checkY) + 4) > 2 && ((HeatingStructureContainerMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, index)) {
                this.f_96541_.f_91072_.m_105208_(((HeatingStructureContainerMenu)this.f_97732_).f_38840_, index);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    @Nullable
    public IScreenWithFluidTank.FluidLocation getFluidUnderMouse(int mouseX, int mouseY) {
        IScreenWithFluidTank.FluidLocation ingredient;
        int checkX = mouseX - this.cornerX;
        int checkY = mouseY - this.cornerY;
        if (this.fuel != null && (ingredient = this.fuel.getFluidUnderMouse(checkX, checkY)) != null) {
            return ingredient;
        }
        if (this.tank != null) {
            return this.tank.getFluidUnderMouse(checkX, checkY);
        }
        return null;
    }
}

