/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.severing;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.tconstruct.library.recipe.modifiers.severing.AgeableSeveringRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;

public class SeveringRecipeBuilder
extends AbstractRecipeBuilder<SeveringRecipeBuilder> {
    private final EntityIngredient ingredient;
    private final ItemOutput output;
    private float baseChance = 0.05f;
    private float lootingBonus = 0.01f;
    @Nullable
    private ItemOutput childOutput = null;

    public static SeveringRecipeBuilder severing(EntityIngredient ingredient, ItemLike output) {
        return SeveringRecipeBuilder.severing(ingredient, ItemOutput.fromItem((ItemLike)output));
    }

    public SeveringRecipeBuilder rareMob() {
        this.baseChance = 0.1f;
        this.lootingBonus = 0.02f;
        return this;
    }

    public SeveringRecipeBuilder noChildOutput() {
        return this.setChildOutput(ItemOutput.EMPTY);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, BuiltInRegistries.f_257033_.m_7981_((Object)this.output.get().m_41720_()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "severing");
        if (this.childOutput != null) {
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new AgeableSeveringRecipe(id, this.ingredient, this.output, this.childOutput, this.baseChance, this.lootingBonus), AgeableSeveringRecipe.LOADER, advancementId));
        } else {
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new SeveringRecipe(id, this.ingredient, this.output, this.baseChance, this.lootingBonus), SeveringRecipe.LOADER, advancementId));
        }
    }

    public SeveringRecipeBuilder setBaseChance(float baseChance) {
        this.baseChance = baseChance;
        return this;
    }

    public SeveringRecipeBuilder setLootingBonus(float lootingBonus) {
        this.lootingBonus = lootingBonus;
        return this;
    }

    public SeveringRecipeBuilder setChildOutput(@Nullable ItemOutput childOutput) {
        this.childOutput = childOutput;
        return this;
    }

    private SeveringRecipeBuilder(EntityIngredient ingredient, ItemOutput output) {
        this.ingredient = ingredient;
        this.output = output;
    }

    public static SeveringRecipeBuilder severing(EntityIngredient ingredient, ItemOutput output) {
        return new SeveringRecipeBuilder(ingredient, output);
    }
}

