/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;

public interface IDisplayModifierRecipe
extends IModifierRecipe {
    public static final Function<Item, ItemStack> MAP_TOOL_FOR_RENDERING = IModifiableDisplay::getDisplayStack;
    public static final Function<ItemStack, ItemStack> MAP_TOOL_STACK_FOR_RENDERING = stack -> {
        ItemStack itemStack;
        Item patt3724$temp = stack.m_41720_();
        if (patt3724$temp instanceof IModifiableDisplay) {
            IModifiableDisplay display = (IModifiableDisplay)patt3724$temp;
            itemStack = display.getRenderTool();
        } else {
            itemStack = stack;
        }
        return itemStack;
    };

    @Nullable
    default public ResourceLocation getRecipeId() {
        return null;
    }

    public int getInputCount();

    public List<ItemStack> getDisplayItems(int var1);

    public List<ItemStack> getToolWithoutModifier();

    public List<ItemStack> getToolWithModifier();

    public ModifierEntry getDisplayResult();

    @Override
    default public Modifier getModifier() {
        return this.getDisplayResult().getModifier();
    }

    default public IntRange getLevel() {
        return ModifierEntry.VALID_LEVEL;
    }

    @Nullable
    default public Component getVariant() {
        return null;
    }

    @Nullable
    default public SlotType.SlotCount getSlots() {
        return null;
    }

    @Override
    @Nullable
    default public SlotType getSlotType() {
        SlotType.SlotCount count = this.getSlots();
        if (count == null) {
            return null;
        }
        return count.type();
    }

    default public boolean isIncremental() {
        return false;
    }

    default public List<SlotType.SlotCount> getResultSlots() {
        return List.of();
    }

    public static List<ModifierEntry> modifiersForResult(ModifierEntry result, @Nullable ModifierEntry self) {
        List<ModifierEntry> requirements = result.getHook(ModifierHooks.REQUIREMENTS).displayModifiers(result);
        if (self != null) {
            return Streams.concat((Stream[])new Stream[]{requirements.stream(), Stream.of(self)}).toList();
        }
        return requirements;
    }

    public static ItemStack withModifiers(ItemStack stack, List<ModifierEntry> modifiers) {
        return IDisplayModifierRecipe.withModifiers(stack, modifiers, (ModDataNBT data) -> {});
    }

    public static ItemStack withModifiers(ItemStack stack, int maxSize, List<ModifierEntry> modifiers) {
        return IDisplayModifierRecipe.withModifiers(stack, maxSize, modifiers, data -> {});
    }

    public static ItemStack withModifiers(ItemStack stack, List<ModifierEntry> modifierList, Consumer<ModDataNBT> persistentDataConsumer) {
        return IDisplayModifierRecipe.withModifiers(stack, 1, modifierList, persistentDataConsumer);
    }

    public static ItemStack withModifiers(ItemStack stack, int maxSize, List<ModifierEntry> modifierList, Consumer<ModDataNBT> persistentDataConsumer) {
        ItemStack output = stack.m_255036_(Math.min(stack.m_41741_(), maxSize));
        CompoundTag nbt = output.m_41784_();
        ModifierNBT modifiers = ModifierNBT.builder().add(modifierList).build();
        ListTag list = modifiers.serializeToNBT();
        nbt.m_128365_("tic_upgrades", (Tag)list);
        nbt.m_128365_("tic_modifiers", (Tag)list);
        CompoundTag persistentNBT = new CompoundTag();
        ModDataNBT persistentData = ModDataNBT.readFromNBT(persistentNBT);
        CompoundTag volatileNBT = new CompoundTag();
        ToolDataNBT volatileData = ToolDataNBT.readFromNBT(volatileNBT);
        persistentDataConsumer.accept(persistentData);
        ToolRebuildContext context = new ToolRebuildContext(stack.m_41720_(), ToolDefinition.EMPTY, MaterialNBT.EMPTY, modifiers, modifiers, persistentData);
        for (ModifierEntry entry : modifiers.getModifiers()) {
            entry.getHook(ModifierHooks.VOLATILE_DATA).addVolatileData(context, entry, volatileData);
        }
        nbt.m_128365_("tic_volatile_data", (Tag)volatileNBT);
        nbt.m_128365_("tic_persistent", (Tag)persistentNBT);
        return output;
    }
}

