/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.util;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;

public class LazyModifier
implements Supplier<Modifier>,
IdAwareObject {
    protected final ModifierId id;
    protected Modifier result;

    public LazyModifier(Modifier modifier) {
        this.id = modifier.getId();
        this.result = modifier;
    }

    public LazyModifier(LazyModifier modifier) {
        this.id = modifier.id;
        this.result = modifier.result;
    }

    protected Modifier getUnchecked() {
        if (this.result == null) {
            this.result = ModifierManager.getValue(this.id);
            if (this.result == ModifierManager.INSTANCE.getDefaultValue() && !ModifierManager.EMPTY.equals((Object)this.id)) {
                TConstruct.LOG.error("Attempted to fetch modifier with ID {}, but it was not registered. Returning the empty modifier and hoping things don't break.", (Object)this.id);
            }
        }
        return this.result;
    }

    public boolean isBound() {
        return ModifierManager.INSTANCE.isDynamicModifiersLoaded() && this.getUnchecked() != ModifierManager.INSTANCE.getDefaultValue();
    }

    @Override
    public Modifier get() {
        if (!ModifierManager.INSTANCE.isDynamicModifiersLoaded()) {
            throw new IllegalStateException("Attempted to fetch a modifier before modifiers are loaded");
        }
        return this.getUnchecked();
    }

    public boolean is(TagKey<Modifier> tag) {
        return ModifierManager.isInTag(this.getId(), tag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyModifier that = (LazyModifier)o;
        return Objects.equals((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "LazyModifier{" + this.id + "}";
    }

    public LazyModifier(ModifierId id) {
        this.id = id;
    }

    public ModifierId getId() {
        return this.id;
    }
}

