/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.fluid;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.AreaOfEffectHighlightModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.modules.build.StatBoostModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.particle.FluidParticleData;
import slimeknights.tconstruct.tools.modifiers.ability.fluid.UseFluidOnHitModifier;

public class SplashingModifier
extends Modifier
implements EntityInteractionModifierHook,
BlockInteractionModifierHook,
AreaOfEffectHighlightModifierHook {
    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule(ToolTankHelper.TANK_HANDLER);
        hookBuilder.addModule((HookProvider)StatBoostModule.add(ToolTankHelper.CAPACITY_STAT).eachLevel(1000.0f));
        hookBuilder.addHook(this, ModifierHooks.ENTITY_INTERACT, ModifierHooks.BLOCK_INTERACT, ModifierHooks.AOE_HIGHLIGHT);
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        return InteractionSource.formatModifierName(tool, entry.getModifier(), entry.getDisplayName());
    }

    @Override
    public boolean shouldHighlight(IToolStackView tool, ModifierEntry modifier, UseOnContext context, BlockPos offset, BlockState state) {
        FluidStack fluid = ToolTankHelper.TANK_HELPER.getFluid(tool);
        if (!fluid.isEmpty()) {
            return FluidEffectManager.INSTANCE.find(fluid.getFluid()).hasBlockEffects();
        }
        return false;
    }

    @Override
    public InteractionResult beforeEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, Entity target, InteractionHand hand, InteractionSource source) {
        FluidEffects recipe;
        FluidStack fluid;
        if (!tool.isBroken() && tool.getHook(ToolHooks.INTERACTION).canInteract(tool, modifier.getId(), source) && !(fluid = ToolTankHelper.TANK_HELPER.getFluid(tool)).isEmpty() && (recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid())).hasEntityEffects()) {
            Level world = player.m_9236_();
            player.m_36335_().m_41524_(tool.getItem(), (int)(20.0f / ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.DRAW_SPEED)));
            if (!world.f_46443_) {
                float level = modifier.getEffectiveLevel();
                int numTargets = 0;
                int consumed = recipe.applyToEntity(fluid, level, FluidEffectContext.builder(world).user(player).target(target), IFluidHandler.FluidAction.EXECUTE);
                if (consumed > 0) {
                    ++numTargets;
                    UseFluidOnHitModifier.spawnParticles(target, fluid);
                    fluid.shrink(consumed);
                }
                if (!fluid.isEmpty()) {
                    float range = 1 + tool.getVolatileData().getInt(IModifiable.EXPANDED);
                    float rangeSq = range * range;
                    for (Entity aoeTarget : world.m_45976_(Entity.class, target.m_20191_().m_82377_((double)range, 0.25, (double)range))) {
                        ArmorStand stand;
                        if (aoeTarget == player || aoeTarget == target || aoeTarget instanceof ArmorStand && (stand = (ArmorStand)aoeTarget).m_31677_() || !(target.m_20280_(aoeTarget) < (double)rangeSq) || (consumed = recipe.applyToEntity(fluid, level, FluidEffectContext.builder(world).user(player).target(aoeTarget), IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                        ++numTargets;
                        UseFluidOnHitModifier.spawnParticles(aoeTarget, fluid);
                        fluid.shrink(consumed);
                        if (!fluid.isEmpty()) continue;
                        break;
                    }
                }
                if (!player.m_7500_()) {
                    if (numTargets > 0) {
                        ToolTankHelper.TANK_HELPER.setFluid(tool, fluid);
                    }
                    ToolDamageUtil.damageAnimated(tool, Mth.m_14167_((float)((float)numTargets * level)), (LivingEntity)player, hand);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static void spawnParticles(Level level, BlockHitResult hit, FluidStack fluid) {
        if (level instanceof ServerLevel) {
            Vec3 location = hit.m_82450_();
            ((ServerLevel)level).m_8767_((ParticleOptions)new FluidParticleData((ParticleType<FluidParticleData>)((ParticleType)TinkerCommons.fluidParticle.get()), fluid), location.m_7096_(), location.m_7098_(), location.m_7094_(), 10, 0.1, 0.2, 0.1, 0.2);
        }
    }

    @Override
    public InteractionResult afterBlockUse(IToolStackView tool, ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        FluidEffects recipe;
        FluidStack fluid;
        if (!tool.isBroken() && tool.getHook(ToolHooks.INTERACTION).canInteract(tool, modifier.getId(), source) && !(fluid = ToolTankHelper.TANK_HELPER.getFluid(tool)).isEmpty() && (recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid())).hasBlockEffects()) {
            Player player = context.m_43723_();
            Level world = context.m_43725_();
            if (player != null) {
                player.m_36335_().m_41524_(tool.getItem(), (int)(20.0f / ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.DRAW_SPEED)));
            }
            if (!context.m_43725_().f_46443_) {
                float level = modifier.getEffectiveLevel();
                int numTargets = 0;
                BlockHitResult hit = context.m_43718_();
                BlockState state = world.m_8055_(hit.m_82425_());
                int consumed = recipe.applyToBlock(fluid, level, FluidEffectContext.builder(world).user(player).block(hit), IFluidHandler.FluidAction.EXECUTE);
                if (consumed > 0) {
                    ++numTargets;
                    SplashingModifier.spawnParticles(world, hit, fluid);
                    fluid.shrink(consumed);
                }
                if (!fluid.isEmpty()) {
                    for (BlockPos offset : tool.getHook(ToolHooks.AOE_ITERATOR).getBlocks(tool, context, state, AreaOfEffectIterator.AOEMatchType.TRANSFORM)) {
                        BlockHitResult offsetHit = Util.offset(hit, offset);
                        consumed = recipe.applyToBlock(fluid, level, FluidEffectContext.builder(world).user(player).block(offsetHit), IFluidHandler.FluidAction.EXECUTE);
                        if (consumed <= 0) continue;
                        ++numTargets;
                        SplashingModifier.spawnParticles(world, offsetHit, fluid);
                        fluid.shrink(consumed);
                        if (!fluid.isEmpty()) continue;
                        break;
                    }
                }
                if (player == null || !player.m_7500_()) {
                    if (numTargets > 0) {
                        ToolTankHelper.TANK_HELPER.setFluid(tool, fluid);
                    }
                    ItemStack stack = context.m_43722_();
                    if (ToolDamageUtil.damage(tool, Mth.m_14167_((float)((float)numTargets * level)), (LivingEntity)player, stack) && player != null) {
                        player.m_21166_(source.getSlot(context.m_43724_()));
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

