/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.severing;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.container.IEmptyContainer;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SeveringRecipe
implements ICustomOutputRecipe<IEmptyContainer> {
    protected static LoadableField<EntityIngredient, SeveringRecipe> ENTITY_FIELD = EntityIngredient.LOADABLE.requiredField("entity", r -> r.ingredient);
    protected static LoadableField<Float, SeveringRecipe> BASE_CHANCE_FIELD = FloatLoadable.PERCENT.defaultField("per_level_chance", (Object)Float.valueOf(0.05f), true, r -> Float.valueOf(r.baseChance));
    protected static LoadableField<Float, SeveringRecipe> LOOTING_BONUS_FIELD = FloatLoadable.PERCENT.defaultField("looting_bonus", (Object)Float.valueOf(0.01f), true, r -> Float.valueOf(r.lootingBonus));
    public static final RecordLoadable<SeveringRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), ENTITY_FIELD, (RecordField)ItemOutput.Loadable.REQUIRED_STACK.requiredField("result", r -> r.output), BASE_CHANCE_FIELD, LOOTING_BONUS_FIELD, SeveringRecipe::new);
    private final ResourceLocation id;
    protected final EntityIngredient ingredient;
    protected final ItemOutput output;
    protected final float baseChance;
    protected final float lootingBonus;

    @Deprecated(forRemoval=true)
    public SeveringRecipe(ResourceLocation id, EntityIngredient ingredient, ItemOutput output) {
        this(id, ingredient, output, 0.05f, 0.01f);
    }

    public boolean matches(EntityType<?> type) {
        return this.ingredient.test(type);
    }

    public float getChance(float level, float looting) {
        return level * (this.baseChance + this.lootingBonus * looting);
    }

    public ItemStack getOutput() {
        return this.output.get();
    }

    public ItemStack getOutput(Entity entity) {
        return this.getOutput().m_41777_();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.severingSerializer.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.SEVERING.get();
    }

    @Deprecated
    public boolean matches(IEmptyContainer inv, Level worldIn) {
        return false;
    }

    public SeveringRecipe(ResourceLocation id, EntityIngredient ingredient, ItemOutput output, float baseChance, float lootingBonus) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
        this.baseChance = baseChance;
        this.lootingBonus = lootingBonus;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public EntityIngredient getIngredient() {
        return this.ingredient;
    }
}

