/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractMultilevelModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.MultilevelIncrementalModifierRecipe;

public class MultilevelIncrementalModifierRecipeBuilder
extends AbstractMultilevelModifierRecipeBuilder<MultilevelIncrementalModifierRecipeBuilder> {
    private Ingredient input = Ingredient.f_43901_;
    private int amountPerItem;
    private int neededPerLevel;
    private ItemOutput leftover = ItemOutput.EMPTY;

    protected MultilevelIncrementalModifierRecipeBuilder(ModifierId result) {
        super(result);
    }

    public static MultilevelIncrementalModifierRecipeBuilder modifier(ModifierId result) {
        return new MultilevelIncrementalModifierRecipeBuilder(result);
    }

    public MultilevelIncrementalModifierRecipeBuilder setInput(Ingredient input, int amountPerItem, int neededPerLevel) {
        if (amountPerItem < 1) {
            throw new IllegalArgumentException("Amount per item must be at least 1");
        }
        if (neededPerLevel <= amountPerItem) {
            throw new IllegalArgumentException("Needed per level must be greater than amount per item");
        }
        this.input = input;
        this.amountPerItem = amountPerItem;
        this.neededPerLevel = neededPerLevel;
        return this;
    }

    public MultilevelIncrementalModifierRecipeBuilder setInput(ItemLike item, int amountPerItem, int neededPerLevel) {
        return this.setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), amountPerItem, neededPerLevel);
    }

    public MultilevelIncrementalModifierRecipeBuilder setInput(TagKey<Item> tag, int amountPerItem, int neededPerLevel) {
        return this.setInput(Ingredient.m_204132_(tag), amountPerItem, neededPerLevel);
    }

    public MultilevelIncrementalModifierRecipeBuilder setLeftover(ItemOutput leftover) {
        this.leftover = leftover;
        return this;
    }

    public MultilevelIncrementalModifierRecipeBuilder setLeftover(ItemStack stack) {
        return this.setLeftover(ItemOutput.fromStack((ItemStack)stack));
    }

    public MultilevelIncrementalModifierRecipeBuilder setLeftover(ItemLike item) {
        return this.setLeftover(ItemOutput.fromItem((ItemLike)item));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.input == Ingredient.f_43901_) {
            throw new IllegalStateException("Must set input");
        }
        if (this.levels.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 level");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new MultilevelIncrementalModifierRecipe(id, this.input, this.amountPerItem, this.neededPerLevel, this.tools, this.maxToolSize, this.result, this.leftover, this.allowCrystal, this.levels, this.checkTraitLevel), MultilevelIncrementalModifierRecipe.LOADER, advancementId));
    }
}

