/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.typed.TypedMapBuilder;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.utils.Util;

public class UpdateMaterialStatsPacket
implements IThreadsafePacket {
    private static final Logger log = Util.getLogger("NetworkSync");
    protected final Map<MaterialId, Collection<IMaterialStats>> materialToStats;

    public UpdateMaterialStatsPacket(FriendlyByteBuf buffer) {
        this(buffer, MaterialRegistry.getInstance().getStatTypeLoader());
    }

    public UpdateMaterialStatsPacket(FriendlyByteBuf buffer, Loadable<MaterialStatType<?>> statTypeLoader) {
        int materialCount = buffer.readInt();
        this.materialToStats = new HashMap<MaterialId, Collection<IMaterialStats>>(materialCount);
        for (int i = 0; i < materialCount; ++i) {
            MaterialId id = new MaterialId(buffer.m_130281_());
            int statCount = buffer.readInt();
            ArrayList<IMaterialStats> statList = new ArrayList<IMaterialStats>();
            for (int j = 0; j < statCount; ++j) {
                try {
                    MaterialStatType statType = (MaterialStatType)statTypeLoader.decode(buffer);
                    statList.add((IMaterialStats)statType.getLoadable().decode(buffer, TypedMapBuilder.builder().put(MaterialStatType.CONTEXT_KEY, (Object)statType).build()));
                    continue;
                }
                catch (Exception e) {
                    log.error("Could not deserialize stat. Are client and server in sync?", (Throwable)e);
                }
            }
            this.materialToStats.put(id, statList);
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.materialToStats.size());
        this.materialToStats.forEach((materialId, stats) -> {
            buffer.m_130085_((ResourceLocation)materialId);
            buffer.writeInt(stats.size());
            stats.forEach(stat -> this.encodeStat(buffer, (IMaterialStats)stat, stat.getType()));
        });
    }

    private <T extends IMaterialStats> void encodeStat(FriendlyByteBuf buffer, IMaterialStats stat, MaterialStatType<T> type) {
        MaterialStatsId.PARSER.encode(buffer, type.getId());
        type.getLoadable().encode(buffer, (Object)stat);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        MaterialRegistry.updateMaterialStatsFromServer(this);
    }

    public Map<MaterialId, Collection<IMaterialStats>> getMaterialToStats() {
        return this.materialToStats;
    }

    public UpdateMaterialStatsPacket(Map<MaterialId, Collection<IMaterialStats>> materialToStats) {
        this.materialToStats = materialToStats;
    }
}

