/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierSortingRecipe
extends AbstractWorktableRecipe {
    private static final Component TITLE = TConstruct.makeTranslation("recipe", "modifier_sorting.title");
    private static final Component DESCRIPTION = TConstruct.makeTranslation("recipe", "modifier_sorting.description");
    private static final Component DESCRIPTION_FORWARD = TConstruct.makeTranslation("recipe", "modifier_sorting.description.forward");
    private static final Component DESCRIPTION_REVERSE = TConstruct.makeTranslation("recipe", "modifier_sorting.description.reversed");
    private static final Component NOT_ENOUGH_MODIFIERS = TConstruct.makeTranslation("recipe", "modifier_sorting.not_enough_modifiers").m_130940_(ChatFormatting.RED);
    public static final RecordLoadable<ModifierSortingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)SizedIngredient.LOADABLE.list(-1).validate((list, error) -> {
        if ((error == ErrorFactory.RUNTIME || error == ErrorFactory.JSON_SYNTAX_ERROR) && list.size() > 1) {
            TConstruct.LOG.warn("Using multiple ingredients for the modifier sorting recipe is deprecated. Use just a single input.");
        }
        return list;
    }).requiredField("inputs", r -> r.inputs), ModifierSortingRecipe::new);

    public ModifierSortingRecipe(ResourceLocation id, List<SizedIngredient> inputs) {
        super(id, inputs);
    }

    @Override
    public boolean matches(ITinkerableContainer inv, Level world) {
        if (!inv.getTinkerableStack().m_204117_(TinkerTags.Items.MODIFIABLE)) {
            return false;
        }
        return ModifierRecipe.checkMatch(inv, this.inputs);
    }

    @Override
    public Component getTitle() {
        return TITLE;
    }

    @Override
    public Component getDescription(@Nullable ITinkerableContainer inv) {
        if (inv != null) {
            if (inv.getTinkerable().getUpgrades().getModifiers().size() < 2) {
                return NOT_ENOUGH_MODIFIERS;
            }
            if (inv.getInput(0).m_41619_()) {
                return DESCRIPTION_REVERSE;
            }
        }
        if (inv != null || this.inputs.size() > 1) {
            return DESCRIPTION_FORWARD;
        }
        return DESCRIPTION;
    }

    @Override
    public List<ModifierEntry> getModifierOptions(@Nullable ITinkerableContainer inv) {
        if (inv == null) {
            return ModifierRecipeLookup.getRecipeModifierList();
        }
        List<ModifierEntry> modifiers = inv.getTinkerable().getUpgrades().getModifiers();
        if (modifiers.size() < 2) {
            return List.of();
        }
        return modifiers;
    }

    @Override
    public RecipeResult<LazyToolStack> getResult(ITinkerableContainer inv, ModifierEntry modifier) {
        ToolStack tool = inv.getTinkerable();
        List<ModifierEntry> upgrades = tool.getUpgrades().getModifiers();
        int toMove = IntStream.range(0, upgrades.size()).filter(i -> ((ModifierEntry)upgrades.get(i)).matches(modifier.getId())).findFirst().orElse(-1);
        if (toMove == -1) {
            return RecipeResult.pass();
        }
        tool = tool.copy();
        ArrayList<ModifierEntry> newUpgrades = new ArrayList<ModifierEntry>(upgrades);
        int target = inv.getInput(0).m_41619_() ? (toMove == 0 ? upgrades.size() - 1 : toMove - 1) : (toMove == upgrades.size() - 1 ? 0 : toMove + 1);
        Collections.swap(newUpgrades, toMove, target);
        tool.setUpgrades(new ModifierNBT(newUpgrades));
        return LazyToolStack.successCopy(tool, inv.getTinkerableStack());
    }

    @Override
    public void updateInputs(LazyToolStack result, ITinkerableContainer.Mutable inv, ModifierEntry selected, boolean isServer) {
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierSortingSerializer.get();
    }
}

