/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.item.armor.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ChrysophiliteModifier
extends NoLevelsModifier
implements EquipmentChangeModifierHook {
    public static final TinkerDataCapability.ComputableDataKey<TotalGold> TOTAL_GOLD = TConstruct.createKey("chrysophilite", TotalGold::new);

    public ChrysophiliteModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingDropsEvent.class, ChrysophiliteModifier::onLivingDrops);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.EQUIPMENT_CHANGE);
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        if (context.getChangedSlot() == EquipmentSlot.HEAD) {
            context.getTinkerData().ifPresent(data -> {
                TotalGold gold = data.get(TOTAL_GOLD);
                if (gold == null) {
                    ((TotalGold)data.computeIfAbsent(TOTAL_GOLD)).initialize(context);
                } else {
                    gold.setGold(EquipmentSlot.HEAD, tool.getVolatileData().getBoolean(ModifiableArmorItem.PIGLIN_NEUTRAL));
                }
            });
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        IToolStackView newTool;
        if (context.getChangedSlot() == EquipmentSlot.HEAD && ((newTool = context.getReplacementTool()) == null || newTool.getModifierLevel(this) == 0)) {
            context.getTinkerData().ifPresent(data -> data.remove(TOTAL_GOLD));
        }
    }

    @Override
    public void onEquipmentChange(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context, EquipmentSlot slotType) {
        EquipmentSlot changed = context.getChangedSlot();
        if (slotType == EquipmentSlot.HEAD && changed.m_20743_() == EquipmentSlot.Type.ARMOR) {
            boolean hasGold = ChrysophiliteModifier.hasGold(context, changed);
            context.getTinkerData().ifPresent(data -> ((TotalGold)data.computeIfAbsent(TOTAL_GOLD)).setGold(changed, hasGold));
        }
    }

    public static boolean hasGold(EquipmentChangeContext context, EquipmentSlot slotType) {
        IToolStackView tool = context.getToolInSlot(slotType);
        if (tool != null) {
            return tool.getVolatileData().getBoolean(ModifiableArmorItem.PIGLIN_NEUTRAL);
        }
        LivingEntity living = context.getEntity();
        return living.m_6844_(slotType).makesPiglinsNeutral(living);
    }

    public static int getTotalGold(@Nullable Entity entity) {
        return Optional.ofNullable(entity).flatMap(e -> e.getCapability(TinkerDataCapability.CAPABILITY).resolve()).map(data -> data.get(TOTAL_GOLD)).map(TotalGold::getTotalGold).orElse(0);
    }

    private static void onLivingDrops(LivingDropsEvent event) {
        int gold;
        DamageSource source = event.getSource();
        if (source != null && (gold = ChrysophiliteModifier.getTotalGold(source.m_7639_())) > 0) {
            float extraChance = 0.04f * (float)gold;
            LivingEntity target = event.getEntity();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = target.m_6844_(slot);
                RandomSource random = target.m_217043_();
                if (stack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)stack) || !stack.makesPiglinsNeutral(target) || !(random.m_188501_() < extraChance)) continue;
                if (stack.m_41763_()) {
                    stack.m_41721_(stack.m_41776_() - random.m_188503_(1 + random.m_188503_(Math.max(stack.m_41776_() - 3, 1))));
                }
                event.getDrops().add(target.m_19983_(stack));
                target.m_8061_(slot, ItemStack.f_41583_);
            }
        }
    }

    public static class TotalGold {
        private final boolean[] hasGold = new boolean[4];
        private int totalGold = 0;

        protected boolean setGold(EquipmentSlot slotType, boolean value) {
            int index;
            if (slotType.m_20743_() == EquipmentSlot.Type.ARMOR && this.hasGold[index = slotType.m_20749_()] != value) {
                this.hasGold[index] = value;
                this.totalGold = value ? ++this.totalGold : --this.totalGold;
                return true;
            }
            return false;
        }

        public void initialize(EquipmentChangeContext context) {
            this.totalGold = 1;
            for (EquipmentSlot slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                boolean gold;
                this.hasGold[slotType.m_20749_()] = gold = ChrysophiliteModifier.hasGold(context, slotType);
                if (!gold) continue;
                ++this.totalGold;
            }
        }

        public int getTotalGold() {
            return this.totalGold;
        }
    }
}

