/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.multiblock;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.common.multiblock.IServantLogic;
import slimeknights.tconstruct.smeltery.block.component.SearedBlock;

public class MultiblockStructureData {
    public static final String TAG_EXTRA_POS = "extra";
    public static final String TAG_MIN = "min";
    public static final String TAG_MAX = "max";
    private final BlockPos minPos;
    private final BlockPos maxPos;
    protected final Set<BlockPos> extra;
    private final boolean hasCeiling;
    private final boolean hasFrame;
    private final boolean hasFloor;
    private final BlockPos minInside;
    private final BlockPos maxInside;
    private final int innerX;
    private final int innerY;
    private final int innerZ;
    private final AABB bounds;

    public MultiblockStructureData(BlockPos minPos, BlockPos maxPos, Set<BlockPos> extraPositons, boolean hasFloor, boolean hasFrame, boolean hasCeiling) {
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.extra = extraPositons;
        this.hasFloor = hasFloor;
        this.hasFrame = hasFrame;
        this.hasCeiling = hasCeiling;
        this.minInside = minPos.m_7918_(1, hasFloor ? 1 : 0, 1);
        this.maxInside = maxPos.m_7918_(-1, hasCeiling ? -1 : 0, -1);
        this.innerX = this.maxInside.m_123341_() - this.minInside.m_123341_() + 1;
        this.innerY = this.maxInside.m_123342_() - this.minInside.m_123342_() + 1;
        this.innerZ = this.maxInside.m_123343_() - this.minInside.m_123343_() + 1;
        this.bounds = new AABB(this.minInside, this.maxInside.m_7918_(1, 1, 1));
    }

    public static boolean isWithin(BlockPos pos, BlockPos min, BlockPos max) {
        return pos.m_123341_() >= min.m_123341_() && pos.m_123342_() >= min.m_123342_() && pos.m_123343_() >= min.m_123343_() && pos.m_123341_() <= max.m_123341_() && pos.m_123342_() <= max.m_123342_() && pos.m_123343_() <= max.m_123343_();
    }

    public boolean withinBounds(BlockPos pos) {
        return MultiblockStructureData.isWithin(pos, this.minPos, this.maxPos);
    }

    public boolean isInside(BlockPos pos) {
        return MultiblockStructureData.isWithin(pos, this.minInside, this.maxInside);
    }

    public boolean contains(BlockPos pos) {
        return this.withinBounds(pos) && this.containsBase(pos);
    }

    private boolean containsBase(BlockPos pos) {
        if (!this.isInside(pos)) {
            if (this.hasFrame) {
                return true;
            }
            int edges = 0;
            if (pos.m_123341_() == this.minPos.m_123341_() || pos.m_123341_() == this.maxPos.m_123341_()) {
                ++edges;
            }
            if (pos.m_123343_() == this.minPos.m_123343_() || pos.m_123343_() == this.maxPos.m_123343_()) {
                ++edges;
            }
            if (this.hasFloor && pos.m_123342_() == this.minPos.m_123342_() || this.hasCeiling && pos.m_123341_() == this.maxPos.m_123341_()) {
                ++edges;
            }
            if (edges < 2) {
                return true;
            }
        }
        return this.extra.contains(pos);
    }

    public boolean isDirectlyAbove(BlockPos pos) {
        return pos.m_123341_() >= this.minPos.m_123341_() && pos.m_123343_() >= this.minPos.m_123343_() && pos.m_123341_() <= this.maxPos.m_123341_() && pos.m_123343_() <= this.maxPos.m_123343_() && pos.m_123342_() == this.maxPos.m_123342_() + 1;
    }

    public void forEachContained(Consumer<BlockPos.MutableBlockPos> consumer) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = this.minPos.m_123341_(); x <= this.maxPos.m_123341_(); ++x) {
            for (int y = this.minPos.m_123342_(); y <= this.maxPos.m_123342_(); ++y) {
                for (int z = this.minPos.m_123343_(); z <= this.maxPos.m_123343_(); ++z) {
                    mutable.m_122178_(x, y, z);
                    if (!this.containsBase((BlockPos)mutable)) continue;
                    consumer.accept(mutable);
                }
            }
        }
    }

    private static void updateMaster(Level world, BlockPos pos, IMasterLogic master, boolean add) {
        BlockState state = world.m_8055_(pos);
        if (state.m_61138_((Property)SearedBlock.IN_STRUCTURE) && (Boolean)state.m_61143_((Property)SearedBlock.IN_STRUCTURE) != add) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)SearedBlock.IN_STRUCTURE, (Comparable)Boolean.valueOf(add)), 2);
        }
        BlockEntityHelper.get(IServantLogic.class, (BlockGetter)world, (BlockPos)pos).ifPresent(add ? te -> te.setPotentialMaster(master) : te -> te.removeMaster(master));
    }

    public <T extends MantleBlockEntity> void assignMaster(T master, @Nullable MultiblockStructureData oldStructure) {
        Predicate<BlockPos> shouldUpdate = oldStructure == null ? pos -> true : pos -> !oldStructure.contains((BlockPos)pos);
        Level world = master.m_58904_();
        assert (world != null);
        this.forEachContained(pos -> {
            if (shouldUpdate.test((BlockPos)pos) && world.m_46805_((BlockPos)pos)) {
                MultiblockStructureData.updateMaster(world, (BlockPos)pos, (IMasterLogic)master, true);
            }
        });
        if (oldStructure != null) {
            oldStructure.forEachContained(pos -> {
                if (!this.contains((BlockPos)pos) && world.m_46805_((BlockPos)pos)) {
                    MultiblockStructureData.updateMaster(world, (BlockPos)pos, (IMasterLogic)master, false);
                }
            });
        }
    }

    public <T extends MantleBlockEntity> void clearMaster(T master) {
        Level world = master.m_58904_();
        assert (world != null);
        this.forEachContained(pos -> {
            if (world.m_46805_((BlockPos)pos)) {
                MultiblockStructureData.updateMaster(world, (BlockPos)pos, (IMasterLogic)master, false);
            }
        });
    }

    public CompoundTag writeClientTag(BlockPos controllerPos) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(TAG_MIN, (Tag)NbtUtils.m_129224_((BlockPos)this.minPos.m_121996_((Vec3i)controllerPos)));
        nbt.m_128365_(TAG_MAX, (Tag)NbtUtils.m_129224_((BlockPos)this.maxPos.m_121996_((Vec3i)controllerPos)));
        return nbt;
    }

    public CompoundTag writeToTag(BlockPos controllerPos) {
        CompoundTag nbt = this.writeClientTag(controllerPos);
        if (!this.extra.isEmpty()) {
            nbt.m_128365_(TAG_EXTRA_POS, (Tag)MultiblockStructureData.writePosList(this.extra, controllerPos));
        }
        return nbt;
    }

    protected static ListTag writePosList(Collection<BlockPos> collection, BlockPos basePos) {
        ListTag list = new ListTag();
        for (BlockPos pos : collection) {
            list.add((Object)NbtUtils.m_129224_((BlockPos)pos.m_121996_((Vec3i)basePos)));
        }
        return list;
    }

    public BlockPos getMinPos() {
        return this.minPos;
    }

    public BlockPos getMaxPos() {
        return this.maxPos;
    }

    public BlockPos getMinInside() {
        return this.minInside;
    }

    public BlockPos getMaxInside() {
        return this.maxInside;
    }

    public int getInnerX() {
        return this.innerX;
    }

    public int getInnerY() {
        return this.innerY;
    }

    public int getInnerZ() {
        return this.innerZ;
    }

    public AABB getBounds() {
        return this.bounds;
    }
}

