/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.Codec;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagManager;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.GeneratePackHelper;
import slimeknights.mantle.registration.object.FlowingFluidObject;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;

public class GenerateHiddenFluidsCommand {
    private static final DynamicCommandExceptionType ERROR_WRITING_TAG = new DynamicCommandExceptionType(tag -> Component.m_237110_((String)"command.mantle.modify_tag.write_error", (Object[])new Object[]{"fluid", tag}));

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(2))).executes(GenerateHiddenFluidsCommand::run);
    }

    private static int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Path pack = GeneratePackHelper.getDatapackPath((MinecraftServer)source.m_81377_());
        GeneratePackHelper.saveMcmeta((Path)pack);
        ResourceLocation tag = TinkerTags.Fluids.HIDDEN_IN_RECIPE_VIEWERS.f_203868_();
        Path tagPath = pack.resolve(PackType.SERVER_DATA.m_10305_() + "/" + tag.m_135827_() + "/" + TagManager.m_203918_((ResourceKey)Registries.f_256808_) + "/" + tag.m_135815_() + ".json");
        ArrayList<TagEntry> add = new ArrayList<TagEntry>();
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            if (compat.isPresent()) continue;
            FluidObject<?> fluid = compat.getFluid();
            if (fluid instanceof FlowingFluidObject) {
                FlowingFluidObject flowing = (FlowingFluidObject)fluid;
                add.add(TagEntry.m_215949_((ResourceLocation)flowing.getLocalTag().f_203868_()));
                continue;
            }
            add.add(TagEntry.m_215925_((ResourceLocation)compat.getFluid().getId()));
        }
        GenerateHiddenFluidsCommand.saveTag(tagPath, tag, new TagFile(add, false, List.of()));
        source.m_288197_(() -> Component.m_237110_((String)"command.tconstruct.generate_hidden_fluids", (Object[])new Object[]{add.size(), GeneratePackHelper.getPathComponent((MutableComponent)Component.m_237113_((String)tag.toString()), (String)tagPath.toString()), GeneratePackHelper.getOutputComponent((Path)pack)}), true);
        return add.size();
    }

    private static void saveTag(Path path, ResourceLocation tag, TagFile contents) throws CommandSyntaxException {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(JsonHelper.DEFAULT_GSON.toJson(JsonHelper.serialize((Codec)TagFile.f_215958_, (Object)contents)));
            }
        }
        catch (IOException ex) {
            Mantle.logger.error("Couldn't save fluid tag {} to {}", (Object)tag, (Object)path, (Object)ex);
            throw ERROR_WRITING_TAG.create((Object)tag);
        }
    }
}

