/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.build;

import java.util.List;
import java.util.Locale;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record StatBoostModule(INumericToolStat<?> stat, StatOperation operation, LevelingValue amount, ModifierCondition<IToolContext> condition) implements ToolStatsModifierHook,
ModifierModule,
ModifierCondition.ConditionalModule<IToolContext>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.TOOL_STATS);
    public static RecordLoadable<StatBoostModule> LOADER = RecordLoadable.create((RecordField)ToolStats.NUMERIC_LOADER.requiredField("stat", StatBoostModule::stat), (RecordField)new EnumLoadable(StatOperation.class).requiredField("operation", StatBoostModule::operation), (RecordField)LevelingValue.LOADABLE.directField(StatBoostModule::amount), ModifierCondition.CONTEXT_FIELD, StatBoostModule::new);

    @Override
    public void addToolStats(IToolContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        if (this.condition.matches(context, modifier) && this.stat.supports(context.getItem())) {
            this.operation.apply(builder, this.stat, this.amount.compute(modifier.getEffectiveLevel()));
        }
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public RecordLoadable<StatBoostModule> getLoader() {
        return LOADER;
    }

    public static Builder add(INumericToolStat<?> stat) {
        return new Builder(stat, StatOperation.ADD);
    }

    public static Builder multiplyBase(INumericToolStat<?> stat) {
        return new Builder(stat, StatOperation.MULTIPLY_BASE);
    }

    public static Builder multiplyConditional(INumericToolStat<?> stat) {
        return new Builder(stat, StatOperation.MULTIPLY_CONDITIONAL);
    }

    public static Builder multiplyAll(INumericToolStat<?> stat) {
        return new Builder(stat, StatOperation.MULTIPLY_ALL);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum StatOperation {
        ADD{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value) {
                stat.add(builder, value);
            }
        }
        ,
        PERCENT{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value) {
                stat.percent(builder, value);
            }
        }
        ,
        MULTIPLY_BASE{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value) {
                stat.multiply(builder, 1.0f + value);
            }
        }
        ,
        MULTIPLY_CONDITIONAL{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value) {
                builder.multiplier(stat, 1.0f + value);
            }
        }
        ,
        MULTIPLY_ALL{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value) {
                stat.multiplyAll(builder, 1.0f + value);
            }
        };

        private final String name = this.name().toLowerCase(Locale.ROOT);

        public abstract void apply(ModifierStatsBuilder var1, INumericToolStat<?> var2, float var3);

        public String getName() {
            return this.name;
        }
    }

    public static class Builder
    extends ModuleBuilder.Context<Builder>
    implements LevelingValue.Builder<StatBoostModule> {
        private final INumericToolStat<?> stat;
        private final StatOperation operation;

        @Override
        public StatBoostModule amount(float flat, float eachLevel) {
            return new StatBoostModule(this.stat, this.operation, new LevelingValue(flat, eachLevel), this.condition);
        }

        private Builder(INumericToolStat<?> stat, StatOperation operation) {
            this.stat = stat;
            this.operation = operation;
        }
    }
}

