/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolCapabilityProvider
implements ICapabilityProvider {
    private static final List<BiFunction<ItemStack, Supplier<? extends IToolStackView>, IToolCapabilityProvider>> PROVIDER_CONSTRUCTORS = new ArrayList<BiFunction<ItemStack, Supplier<? extends IToolStackView>, IToolCapabilityProvider>>();
    private final ItemStack stack;
    private final Lazy<ToolStack> tool;
    private final List<IToolCapabilityProvider> providers;

    public ToolCapabilityProvider(ItemStack stack) {
        this.stack = stack;
        this.tool = Lazy.of(() -> ToolStack.from(stack));
        this.providers = PROVIDER_CONSTRUCTORS.stream().map(con -> (IToolCapabilityProvider)con.apply(stack, this.tool)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        ToolStack toolStack = (ToolStack)this.tool.get();
        toolStack.refreshTag(this.stack);
        for (IToolCapabilityProvider provider : this.providers) {
            provider.clearCache();
            LazyOptional<T> optional = provider.getCapability(toolStack, cap);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return LazyOptional.empty();
    }

    public static void register(BiFunction<ItemStack, Supplier<? extends IToolStackView>, IToolCapabilityProvider> constructor) {
        PROVIDER_CONSTRUCTORS.add(constructor);
    }

    @FunctionalInterface
    public static interface IToolCapabilityProvider {
        public <T> LazyOptional<T> getCapability(IToolStackView var1, Capability<T> var2);

        default public void clearCache() {
        }
    }
}

