/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.mining;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BreakSpeedContext {
    public Player player();

    public BlockState state();

    @Nullable
    public BlockPos pos();

    public Direction sideHit();

    public boolean isEffective();

    public float originalSpeed();

    public float miningSpeedMultiplier();

    @Deprecated
    @ApiStatus.Internal
    public PlayerEvent.BreakSpeed event();

    public static float getMiningModifier(LivingEntity entity) {
        MobEffectInstance miningFatigue;
        float modifier = 1.0f;
        if (MobEffectUtil.m_19584_((LivingEntity)entity)) {
            modifier *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)entity) + 1) * 0.2f;
        }
        if ((miningFatigue = entity.m_21124_(MobEffects.f_19599_)) != null) {
            switch (miningFatigue.m_19564_()) {
                case 0: {
                    modifier *= 0.3f;
                    break;
                }
                case 1: {
                    modifier *= 0.09f;
                    break;
                }
                case 2: {
                    modifier *= 0.0027f;
                    break;
                }
                default: {
                    modifier *= 8.1E-4f;
                }
            }
        }
        if (entity.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_((LivingEntity)entity)) {
            modifier /= 5.0f;
        }
        if (!entity.m_20096_()) {
            modifier /= 5.0f;
        }
        return modifier;
    }

    public static final class Direct
    implements BreakSpeedContext {
        private final Player player;
        private final BlockState state;
        @Nullable
        private final BlockPos pos;
        private final Direction sideHit;
        private final boolean isEffective;
        private final float originalSpeed;
        private final float miningSpeedMultiplier;
        private PlayerEvent.BreakSpeed event;

        @Override
        public PlayerEvent.BreakSpeed event() {
            if (this.event == null) {
                this.event = new PlayerEvent.BreakSpeed(this.player, this.state, this.originalSpeed, this.pos);
            }
            return this.event;
        }

        @Override
        public Player player() {
            return this.player;
        }

        @Override
        public BlockState state() {
            return this.state;
        }

        @Override
        @Nullable
        public BlockPos pos() {
            return this.pos;
        }

        @Override
        public Direction sideHit() {
            return this.sideHit;
        }

        @Override
        public boolean isEffective() {
            return this.isEffective;
        }

        @Override
        public float originalSpeed() {
            return this.originalSpeed;
        }

        @Override
        public float miningSpeedMultiplier() {
            return this.miningSpeedMultiplier;
        }

        public Direct(Player player, BlockState state, @Nullable BlockPos pos, Direction sideHit, boolean isEffective, float originalSpeed, float miningSpeedMultiplier) {
            this.player = player;
            this.state = state;
            this.pos = pos;
            this.sideHit = sideHit;
            this.isEffective = isEffective;
            this.originalSpeed = originalSpeed;
            this.miningSpeedMultiplier = miningSpeedMultiplier;
        }
    }

    public record Event(PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedMultiplier) implements BreakSpeedContext
    {
        @Override
        public Player player() {
            return this.event.getEntity();
        }

        @Override
        public BlockState state() {
            return this.event.getState();
        }

        @Override
        @Nullable
        public BlockPos pos() {
            return this.event.getPosition().orElse(null);
        }

        @Override
        public float originalSpeed() {
            return this.event.getOriginalSpeed();
        }
    }
}

