/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.command.HeldModifiableItemIterator;
import slimeknights.tconstruct.shared.command.TConstructCommand;
import slimeknights.tconstruct.shared.command.argument.MaterialArgument;
import slimeknights.tconstruct.shared.command.argument.MaterialStatsArgument;
import slimeknights.tconstruct.shared.command.argument.MaterialVariantArgument;

public class MaterialsCommand {
    private static final String ADD_SUCCESS = TConstruct.makeTranslationKey("command", "materials.success.set.single");
    private static final String ADD_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "materials.success.set.multiple");
    private static final Dynamic2CommandExceptionType INVALID_INDEX = new Dynamic2CommandExceptionType((index, name) -> TConstruct.makeTranslation("command", "materials.failure.invalid_index", index, name));
    private static final Dynamic2CommandExceptionType INVALID_STATS = new Dynamic2CommandExceptionType((statType, stats) -> TConstruct.makeTranslation("command", "materials.failure.invalid_stats", statType, stats));
    private static final Component NO_TRAITS = TConstruct.makeTranslation("command", "materials.failure.no_traits").m_130940_(ChatFormatting.ITALIC);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"material", (ArgumentType)MaterialVariantArgument.material()).executes(MaterialsCommand::set)))))).then(Commands.m_82127_((String)"stats").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"stat_type", (ArgumentType)MaterialStatsArgument.stats()).executes(MaterialsCommand::defaultStats)).then(Commands.m_82129_((String)"material", (ArgumentType)MaterialArgument.material()).executes(MaterialsCommand::stats))))).then(Commands.m_82127_((String)"traits").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"material", (ArgumentType)MaterialArgument.material()).executes(context -> MaterialsCommand.traits((CommandContext<CommandSourceStack>)context, null))).then(Commands.m_82129_((String)"stat_type", (ArgumentType)MaterialStatsArgument.stats()).executes(MaterialsCommand::traits))));
    }

    private static int set(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int index = IntegerArgumentType.getInteger(context, (String)"index");
        MaterialVariantId material = MaterialVariantArgument.getMaterial(context, "material");
        List<LivingEntity> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            ToolStack original = ToolStack.from(stack);
            if (index >= ToolMaterialHook.stats(original.getDefinition()).size()) {
                throw INVALID_INDEX.create((Object)index, (Object)living.m_5446_());
            }
            ToolStack tool = original.copy();
            tool.replaceMaterial(index, material);
            Component toolValidation = tool.tryValidate();
            if (toolValidation != null) {
                throw TConstructCommand.COMPONENT_ERROR.create((Object)toolValidation);
            }
            toolValidation = ModifierRemovalHook.onRemoved(original, tool);
            if (toolValidation != null) {
                throw TConstructCommand.COMPONENT_ERROR.create((Object)toolValidation);
            }
            living.m_21008_(InteractionHand.MAIN_HAND, tool.copyStack(stack));
            return true;
        });
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.m_288197_(() -> Component.m_237110_((String)ADD_SUCCESS, (Object[])new Object[]{index, MaterialTooltipCache.getDisplayName(material), ((LivingEntity)successes.get(0)).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)ADD_SUCCESS_MULTIPLE, (Object[])new Object[]{index, MaterialTooltipCache.getDisplayName(material), size}), true);
        }
        return size;
    }

    private static int defaultStats(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> {
            MaterialStatType<?> statType = MaterialStatsArgument.getStat(context, "stat_type");
            MutableComponent output = TConstruct.makeTranslation("command", "materials.success.stats.default", statType.getDefaultStats().getLocalizedName());
            for (Component component : statType.getDefaultStats().getLocalizedInfo()) {
                output.m_130946_("\n* ").m_7220_(component);
            }
            return output;
        }, true);
        return 1;
    }

    private static int stats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        MaterialId material = MaterialArgument.getMaterial(context, "material").getIdentifier();
        MaterialStatType<?> statType = MaterialStatsArgument.getStat(context, "stat_type");
        Optional stats = MaterialRegistry.getInstance().getMaterialStats(material, statType.getId());
        if (stats.isPresent()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> {
                MutableComponent output = TConstruct.makeTranslation("command", "materials.success.stats.material", ((IMaterialStats)stats.get()).getLocalizedName(), MaterialTooltipCache.getDisplayName(material));
                for (Component component : ((IMaterialStats)stats.get()).getLocalizedInfo()) {
                    output.m_130946_("\n* ").m_7220_(component);
                }
                return output;
            }, true);
            return 1;
        }
        throw INVALID_STATS.create((Object)statType.getId(), (Object)MaterialTooltipCache.getDisplayName(material));
    }

    private static int traits(CommandContext<CommandSourceStack> context) {
        return MaterialsCommand.traits(context, MaterialStatsArgument.getStat(context, "stat_type"));
    }

    private static int traits(CommandContext<CommandSourceStack> context, @Nullable MaterialStatType<?> statType) {
        MutableComponent output;
        List<ModifierEntry> traits;
        MaterialId material = MaterialArgument.getMaterial(context, "material").getIdentifier();
        if (statType == null) {
            traits = MaterialRegistry.getInstance().getDefaultTraits(material);
            output = TConstruct.makeTranslation("command", "materials.success.traits.default", MaterialTooltipCache.getDisplayName(material));
        } else {
            traits = MaterialRegistry.getInstance().getTraits(material, statType.getId());
            output = TConstruct.makeTranslation("command", "materials.success.traits.stat", statType.getDefaultStats().getLocalizedName(), MaterialTooltipCache.getDisplayName(material));
        }
        if (traits.isEmpty()) {
            output.m_130946_("\n* ").m_7220_(NO_TRAITS);
        } else {
            for (ModifierEntry trait : traits) {
                output.m_130946_("\n* ").m_7220_(trait.getDisplayName()).m_7220_((Component)Component.m_237113_((String)(" (" + trait.getId() + ")")).m_130940_(ChatFormatting.GRAY));
            }
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> output, true);
        return traits.size();
    }
}

