/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class PotionModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        Material smallTexture = (Material)smallGetter.apply("");
        Material largeTexture = (Material)largeGetter.apply("");
        if (smallTexture != null || largeTexture != null) {
            return new PotionModifierModel(smallTexture, largeTexture);
        }
        return null;
    };
    @Nullable
    private final Material small;
    @Nullable
    private final Material large;

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        ModifierId modifier = entry.getId();
        return new CacheKey(modifier, tool.getPersistentData().getString(modifier));
    }

    @Override
    public void addQuads(IToolStackView tool, ModifierEntry modifier, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, Consumer<Collection<BakedQuad>> quadConsumer, @Nullable ItemLayerPixels pixels) {
        Material texture;
        Material material = texture = isLarge ? this.large : this.small;
        if (texture != null) {
            Potion potion;
            ResourceLocation id;
            ModifierId key = modifier.getId();
            ModDataNBT toolData = tool.getPersistentData();
            if (toolData.contains(key, 8) && (id = ResourceLocation.m_135820_((String)toolData.getString(key))) != null && (potion = (Potion)BuiltInRegistries.f_256980_.m_7745_(id)) != Potions.f_43598_) {
                quadConsumer.accept(MantleItemLayerModel.getQuadsForSprite((int)(0xFF000000 | PotionUtils.m_43559_((Potion)potion)), (int)-1, (TextureAtlasSprite)spriteGetter.apply(texture), (Transformation)transforms, (int)0, (ItemLayerPixels)pixels));
            }
        }
    }

    public PotionModifierModel(@Nullable Material small, @Nullable Material large) {
        this.small = small;
        this.large = large;
    }

    private record CacheKey(ModifierId modifier, String potion) {
    }
}

