/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.ranged;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.utils.Schedule;

public interface ScheduledProjectileTaskModifierHook {
    public void scheduleProjectileTask(IToolStackView var1, ModifierEntry var2, ItemStack var3, Projectile var4, @Nullable AbstractArrow var5, ModDataNBT var6, Schedule.Scheduler var7);

    public void onScheduledProjectileTask(IToolStackView var1, ModifierEntry var2, ItemStack var3, Projectile var4, @Nullable AbstractArrow var5, ModDataNBT var6, int var7);

    public static Schedule createSchedule(IToolStackView tool, ItemStack ammo, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData) {
        List<ModifierEntry> modifiers = tool.getModifiers().getModifiers();
        Schedule.ScheduleBuilder builder = new Schedule.ScheduleBuilder();
        int size = modifiers.size();
        Schedule.ListScheduler scheduler = builder.list(size);
        for (int i = 0; i < size; ++i) {
            ModifierEntry entry = modifiers.get(i);
            scheduler.setIndex(i);
            entry.getHook(ModifierHooks.SCHEDULE_PROJECTILE_TASK).scheduleProjectileTask(tool, entry, ammo, projectile, arrow, persistentData, scheduler);
        }
        return builder.build();
    }

    public static void checkSchedule(IToolStackView tool, ItemStack ammo, Projectile projectile, @Nullable AbstractArrow arrow, Schedule schedule) {
        int task;
        while ((task = schedule.check(projectile.f_19797_)) >= 0) {
            ModDataNBT persistentData = PersistentDataCapability.getOrWarn((Entity)projectile);
            List<ModifierEntry> modifiers = tool.getModifiers().getModifiers();
            int size = modifiers.size();
            int index = Schedule.index(task, size);
            if (index >= size) continue;
            ModifierEntry entry = modifiers.get(index);
            entry.getHook(ModifierHooks.SCHEDULE_PROJECTILE_TASK).onScheduledProjectileTask(tool, entry, ammo, projectile, arrow, persistentData, Schedule.local(task, size));
        }
    }

    public record ScheduleMerger(List<ScheduledProjectileTaskModifierHook> modules) implements ScheduledProjectileTaskModifierHook
    {
        public ScheduleMerger(Collection<ScheduledProjectileTaskModifierHook> modules) {
            this(List.copyOf(modules));
        }

        @Override
        public void scheduleProjectileTask(IToolStackView tool, ModifierEntry modifier, ItemStack ammo, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, Schedule.Scheduler scheduler) {
            int size = this.modules.size();
            Schedule.ListScheduler listScheduler = scheduler.list(this.modules.size());
            for (int i = 0; i < size; ++i) {
                listScheduler.setIndex(i);
                this.modules.get(i).scheduleProjectileTask(tool, modifier, ammo, projectile, arrow, persistentData, listScheduler);
            }
        }

        @Override
        public void onScheduledProjectileTask(IToolStackView tool, ModifierEntry modifier, ItemStack ammo, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, int task) {
            int size = this.modules.size();
            int index = Schedule.index(task, size);
            if (index < size) {
                this.modules.get(index).onScheduledProjectileTask(tool, modifier, ammo, projectile, arrow, persistentData, Schedule.local(task, size));
            }
        }
    }
}

