/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.widget;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import org.apache.commons.compress.utils.Lists;
import slimeknights.mantle.client.screen.MultiModuleScreen;

public class SideButtonsWidget<T extends Button>
implements Renderable,
GuiEventListener {
    private static final int SPACING = 4;
    protected final MultiModuleScreen<?> parent;
    private final int leftPos;
    private final int topPos;
    private final int imageWidth;
    private final int imageHeight;
    private final int columns;
    protected final List<T> buttons = Lists.newArrayList();
    private Button clickedButton;

    public SideButtonsWidget(MultiModuleScreen<?> parent, int leftPos, int topPos, int columns, int rows, int buttonWidth, int buttonHeight) {
        this.parent = parent;
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.columns = columns;
        this.imageWidth = SideButtonsWidget.size(columns, buttonWidth);
        this.imageHeight = SideButtonsWidget.size(rows, buttonHeight);
    }

    public int guiRight() {
        return this.leftPos + this.imageWidth;
    }

    public int guiBottom() {
        return this.topPos + this.imageHeight;
    }

    public Rect2i getArea() {
        return new Rect2i(this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
    }

    public void setButtonPositions() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = (Button)this.buttons.get(i);
            int x = i % this.columns * (button.m_5711_() + 4);
            int y = i / this.columns * (button.m_93694_() + 4);
            button.m_252865_(this.leftPos + x);
            button.m_253211_(this.topPos + y);
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return (double)this.leftPos <= mouseX && mouseX < (double)this.guiRight() && (double)this.topPos <= mouseY && mouseY < (double)this.guiBottom();
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (Button button : this.buttons) {
                if (!button.m_6375_(mouseX, mouseY, mouseButton)) continue;
                this.clickedButton = button;
                return true;
            }
        }
        return false;
    }

    public boolean handleMouseReleased(double mouseX, double mouseY, int state) {
        if (this.clickedButton != null) {
            this.clickedButton.m_6348_(mouseX, mouseY, state);
            this.clickedButton = null;
            return true;
        }
        return false;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (Button button : this.buttons) {
            button.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public static int rowsForCount(int columns, int count) {
        return (count - 1) / columns + 1;
    }

    public static int size(int buttonCount, int buttonSize) {
        return buttonSize * buttonCount + 4 * (buttonCount - 1);
    }

    public void m_93692_(boolean pFocused) {
    }

    public boolean m_93696_() {
        return false;
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }
}

