/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.material;

import java.util.List;
import javax.annotation.Nullable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolTraitHook;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.helper.ModifierBuilder;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;

public final class MaterialTraitsModule
implements ToolTraitHook,
ToolModule {
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.TOOL_TRAITS);
    private static final MaterialStatsId MISSING = new MaterialStatsId("tconstruct", "missingno");
    public static final RecordLoadable<MaterialTraitsModule> LOADER = RecordLoadable.create((RecordField)MaterialStatsId.PARSER.nullableField("stat_type", m -> m.statType), (RecordField)IntLoadable.FROM_ZERO.requiredField("material_index", m -> m.materialIndex), MaterialTraitsModule::new);
    @Nullable
    private MaterialStatsId statType;
    private final int materialIndex;

    public MaterialTraitsModule(int materialIndex) {
        this(null, materialIndex);
    }

    public RecordLoadable<MaterialTraitsModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private MaterialStatsId getStatType(ToolDefinition definition) {
        if (this.statType == null) {
            List<MaterialStatsId> statTypes = ToolMaterialHook.stats(definition);
            if (this.materialIndex < statTypes.size()) {
                this.statType = statTypes.get(this.materialIndex);
            } else {
                TConstruct.LOG.error("Invalid material index {} for {} traits module, total materials {}", (Object)this.materialIndex, (Object)definition.getId(), (Object)statTypes.size());
                this.statType = MISSING;
            }
        }
        return this.statType;
    }

    @Override
    public void addTraits(ToolDefinition definition, MaterialNBT materials, ModifierBuilder builder) {
        MaterialStatsId statsId;
        MaterialVariant material = materials.get(this.materialIndex);
        if (!material.isUnknown() && !MISSING.equals((Object)(statsId = this.getStatType(definition)))) {
            builder.add(MaterialRegistry.getInstance().getTraits(material.getId(), this.getStatType(definition)));
        }
    }

    public MaterialTraitsModule(@Nullable MaterialStatsId statType, int materialIndex) {
        this.statType = statType;
        this.materialIndex = materialIndex;
    }
}

