/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.display;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.display.ToolNameHook;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.utils.Util;

public interface MaterialToolName
extends ToolNameHook {
    public static final Component MATERIAL_SEPARATOR = TConstruct.makeTranslation("item", "tool.material_separator");

    public boolean shouldDisplayMaterial(int var1, MaterialStatsId var2, MaterialVariantId var3);

    @Override
    default public Component getDisplayName(ToolDefinition definition, ItemStack stack, @Nullable IToolStackView tool) {
        MutableComponent itemName = Component.m_237115_((String)stack.m_41720_().m_5524_());
        List<MaterialStatsId> components = ToolMaterialHook.stats(definition);
        if (components.isEmpty()) {
            return itemName;
        }
        MaterialNBT materials = ToolNameHook.getTool(stack, tool).getMaterials();
        if (materials.isEmpty()) {
            return itemName;
        }
        int size = Math.min(components.size(), materials.size());
        LinkedHashSet<MaterialVariantId> displayMaterials = new LinkedHashSet<MaterialVariantId>(size);
        for (int i = 0; i < size; ++i) {
            MaterialVariantId material = materials.get(i).getVariant();
            if (IMaterial.UNKNOWN_ID.equals(material) || !this.shouldDisplayMaterial(i, components.get(i), material)) continue;
            displayMaterials.add(material);
        }
        if (displayMaterials.isEmpty()) {
            return itemName;
        }
        if (displayMaterials.size() == 1) {
            return MaterialToolName.nameForMaterial((MaterialVariantId)displayMaterials.iterator().next(), (Component)itemName);
        }
        LinkedHashSet<Component> names = new LinkedHashSet<Component>(displayMaterials.size());
        for (MaterialVariantId id : displayMaterials) {
            names.add(MaterialTooltipCache.getDisplayName(id));
        }
        MutableComponent builder = Component.m_237113_((String)"");
        Iterator iter = names.iterator();
        builder.m_7220_((Component)iter.next());
        while (iter.hasNext()) {
            builder.m_7220_(MATERIAL_SEPARATOR).m_7220_((Component)iter.next());
        }
        return Component.m_237110_((String)TooltipUtil.KEY_FORMAT, (Object[])new Object[]{builder, itemName});
    }

    public static Component nameForMaterial(MaterialVariantId material, Component itemName) {
        String format = MaterialTooltipCache.getKey(material) + ".format";
        if (Util.canTranslate(format)) {
            return Component.m_237110_((String)format, (Object[])new Object[]{itemName});
        }
        return Component.m_237110_((String)TooltipUtil.KEY_FORMAT, (Object[])new Object[]{MaterialTooltipCache.getDisplayName(material), itemName});
    }
}

