/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.interaction;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolAction;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.mining.RemoveBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.modules.behavior.ShowOffhandModule;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.module.aoe.CircleAOEIterator;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class FirestarterModifier
extends NoLevelsModifier
implements EntityInteractionModifierHook,
BlockInteractionModifierHook,
ToolActionModifierHook,
RemoveBlockModifierHook {
    private static final ToolAction LIGHT_FIRE = ToolAction.get((String)"light_fire");
    private static final ToolAction LIGHT_CAMPFIRE = ToolAction.get((String)"light_campfire");
    private final int priority;

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule(ShowOffhandModule.DISALLOW_BROKEN);
        hookBuilder.addHook(this, ModifierHooks.ENTITY_INTERACT, ModifierHooks.BLOCK_INTERACT, ModifierHooks.TOOL_ACTION, ModifierHooks.REMOVE_BLOCK);
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        return InteractionSource.formatModifierName(tool, this, super.getDisplayName(tool, entry, access));
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, ModifierEntry modifier, ToolAction toolAction) {
        return toolAction == LIGHT_CAMPFIRE || toolAction == LIGHT_FIRE;
    }

    @Override
    public InteractionResult afterEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, LivingEntity target, InteractionHand hand, InteractionSource source) {
        if (tool.getHook(ToolHooks.INTERACTION).canInteract(tool, modifier.getId(), source) && target instanceof Creeper) {
            Creeper creeper = (Creeper)target;
            Level level = player.m_9236_();
            level.m_6263_(player, creeper.m_20185_(), creeper.m_20186_(), creeper.m_20189_(), SoundEvents.f_11942_, creeper.m_5720_(), 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            if (!level.f_46443_) {
                creeper.m_32312_();
                ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)player, source.getSlot(hand));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static boolean ignite(IToolStackView tool, Level world, BlockPos pos, BlockState state, Direction sideHit, Direction horizontalFacing, @Nullable Player player) {
        if (CampfireBlock.m_51321_((BlockState)state) || CandleBlock.m_152845_((BlockState)state) || CandleCakeBlock.m_152910_((BlockState)state)) {
            world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
            world.m_142346_((Entity)player, GameEvent.f_157797_, pos);
            return true;
        }
        Block block = state.m_60734_();
        if (block instanceof TntBlock) {
            TntBlock tnt = (TntBlock)block;
            tnt.onCaughtFire(state, world, pos, sideHit, (LivingEntity)player);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            return true;
        }
        BlockPos offset = pos.m_121945_(sideHit);
        if (BaseFireBlock.m_49255_((Level)world, (BlockPos)offset, (Direction)horizontalFacing)) {
            world.m_5594_(player, offset, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            world.m_7731_(offset, BaseFireBlock.m_49245_((BlockGetter)world, (BlockPos)offset), 11);
            return true;
        }
        return false;
    }

    @Override
    public InteractionResult beforeBlockUse(IToolStackView tool, ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        if (tool.isBroken() || !tool.getHook(ToolHooks.INTERACTION).canInteract(tool, modifier.getId(), source)) {
            return InteractionResult.PASS;
        }
        if (context.m_43725_().m_8055_(context.m_8083_()).m_204336_(BlockTags.f_144268_)) {
            return this.afterBlockUse(tool, modifier, context, source);
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult afterBlockUse(IToolStackView tool, ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        if (tool.isBroken() || !tool.getHook(ToolHooks.INTERACTION).canInteract(tool, modifier.getId(), source)) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        UseOnContext targetContext = context;
        BlockPos pos = context.m_8083_();
        Direction sideHit = context.m_43719_();
        BlockState state = world.m_8055_(pos);
        boolean targetingFire = false;
        if (state.m_204336_(BlockTags.f_13076_)) {
            pos = pos.m_121945_(sideHit.m_122424_());
            targetContext = Util.offset(context, pos);
            targetingFire = true;
        }
        int range = tool.getModifierLevel(TinkerModifiers.fireprimer.getId()) + tool.getModifierLevel(TinkerModifiers.expanded.getId());
        Iterable<Object> targets = Collections.emptyList();
        if (range > 0) {
            targets = CircleAOEIterator.calculate(tool, targetContext, 1 + range, true, AreaOfEffectIterator.AOEMatchType.TRANSFORM);
        }
        Direction horizontalFacing = context.m_8125_();
        boolean didIgnite = false;
        ItemStack stack = context.m_43722_();
        EquipmentSlot slotType = source.getSlot(context.m_43724_());
        if (!targetingFire && (didIgnite = FirestarterModifier.ignite(tool, world, pos, state, sideHit, horizontalFacing, player)) && ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack)) {
            if (player != null) {
                player.m_21166_(slotType);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        for (BlockPos blockPos : targets) {
            if (!FirestarterModifier.ignite(tool, world, blockPos, world.m_8055_(blockPos), sideHit, horizontalFacing, player)) continue;
            didIgnite = true;
            if (!ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack)) continue;
            if (player == null) break;
            player.m_21166_(slotType);
            break;
        }
        return didIgnite || targetingFire ? InteractionResult.m_19078_((boolean)world.f_46443_) : InteractionResult.PASS;
    }

    @Override
    @Nullable
    public Boolean removeBlock(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        if (context.getState().m_60713_(Blocks.f_50083_) && tool.getHook(ToolHooks.INTERACTION).canInteract(tool, this.getId(), InteractionSource.LEFT_CLICK)) {
            return false;
        }
        return null;
    }

    public FirestarterModifier(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

