/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.material;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialDataProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.json.MaterialTraitsJson;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.traits.MaterialTraitsManager;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;

public abstract class AbstractMaterialTraitDataProvider
extends GenericDataProvider {
    private final Map<MaterialId, MaterialTraitsBuilder> allMaterialTraits = new HashMap<MaterialId, MaterialTraitsBuilder>();
    private final AbstractMaterialDataProvider materials;

    public AbstractMaterialTraitDataProvider(PackOutput packOutput, AbstractMaterialDataProvider materials) {
        super(packOutput, PackOutput.Target.DATA_PACK, "tinkering/materials/traits", MaterialTraitsManager.GSON);
        this.materials = materials;
    }

    protected abstract void addMaterialTraits();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addMaterialTraits();
        Set<MaterialId> materialsGenerated = this.materials.getAllMaterials();
        for (MaterialId material : materialsGenerated) {
            if (this.allMaterialTraits.containsKey(material)) continue;
            throw new IllegalStateException(String.format("Missing material traits for '%s'", material));
        }
        return AbstractMaterialTraitDataProvider.allOf(this.allMaterialTraits.entrySet().stream().map(entry -> this.saveJson(cache, (ResourceLocation)entry.getKey(), ((MaterialTraitsBuilder)entry.getValue()).build())));
    }

    protected MaterialTraitsBuilder material(MaterialId location) {
        return this.allMaterialTraits.computeIfAbsent(location, id -> new MaterialTraitsBuilder());
    }

    protected void noTraits(MaterialId location) {
        this.material(location);
    }

    protected void addDefaultTraits(MaterialId location, ModifierEntry ... traits) {
        this.material(location).addDefaultTraits(traits);
    }

    protected void addDefaultTraits(MaterialId location, ModifierId ... traits) {
        this.material(location).addDefaultTraits(traits);
    }

    protected void addDefaultTraits(MaterialId location, LazyModifier ... traits) {
        this.material(location).addDefaultTraits(traits);
    }

    protected void addTraits(MaterialId location, MaterialStatsId statsId, ModifierEntry ... traits) {
        this.material(location).addTraits(statsId, traits);
    }

    protected void addTraits(MaterialId location, MaterialStatsId statsId, ModifierId ... traits) {
        this.material(location).addTraits(statsId, traits);
    }

    protected void addTraits(MaterialId location, MaterialStatsId statsId, LazyModifier ... traits) {
        this.material(location).addTraits(statsId, traits);
    }

    @CanIgnoreReturnValue
    public static class MaterialTraitsBuilder {
        private final List<ModifierEntry> defaultTraits = new ArrayList<ModifierEntry>();
        private final Map<ResourceLocation, List<ModifierEntry>> perStats = new HashMap<ResourceLocation, List<ModifierEntry>>();

        private static void addAll(List<ModifierEntry> list, LazyModifier[] traits) {
            for (LazyModifier trait : traits) {
                list.add(new ModifierEntry(trait, 1));
            }
        }

        private static void addAll(List<ModifierEntry> list, ModifierId[] traits) {
            for (ModifierId trait : traits) {
                list.add(new ModifierEntry(trait, 1));
            }
        }

        public MaterialTraitsBuilder addDefaultTraits(ModifierEntry ... traits) {
            Collections.addAll(this.defaultTraits, traits);
            return this;
        }

        public MaterialTraitsBuilder addDefaultTraits(LazyModifier ... traits) {
            MaterialTraitsBuilder.addAll(this.defaultTraits, traits);
            return this;
        }

        public MaterialTraitsBuilder addDefaultTraits(ModifierId ... traits) {
            MaterialTraitsBuilder.addAll(this.defaultTraits, traits);
            return this;
        }

        private List<ModifierEntry> getList(MaterialStatsId statsId, int size) {
            return this.perStats.computeIfAbsent(statsId, k -> new ArrayList(size));
        }

        public MaterialTraitsBuilder addTraits(MaterialStatsId statsId, ModifierEntry ... traits) {
            Collections.addAll(this.getList(statsId, traits.length), traits);
            return this;
        }

        public MaterialTraitsBuilder addTraits(MaterialStatsId statsId, LazyModifier ... traits) {
            MaterialTraitsBuilder.addAll(this.getList(statsId, traits.length), traits);
            return this;
        }

        public MaterialTraitsBuilder addTraits(MaterialStatsId statsId, ModifierId ... traits) {
            MaterialTraitsBuilder.addAll(this.getList(statsId, traits.length), traits);
            return this;
        }

        @CheckReturnValue
        private MaterialTraitsJson build() {
            return new MaterialTraitsJson(this.defaultTraits.isEmpty() ? null : this.defaultTraits, this.perStats.isEmpty() ? null : this.perStats);
        }
    }
}

