/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.sling;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.UseAnim;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.interaction.UsingToolModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableLauncherItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.shared.TinkerAttributes;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.ability.interaction.BlockingModifier;

public abstract class SlingModifier
extends NoLevelsModifier
implements GeneralInteractionModifierHook,
UsingToolModifierHook {
    @Override
    protected void registerHooks(ModuleHookMap.Builder builder) {
        builder.addHook(this, ModifierHooks.GENERAL_INTERACT, ModifierHooks.TOOL_USING);
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (!tool.isBroken() && source == InteractionSource.RIGHT_CLICK) {
            GeneralInteractionModifierHook.startUsingWithDrawtime(tool, modifier.getId(), (LivingEntity)player, hand, 1.5f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 72000;
    }

    @Override
    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return BlockingModifier.blockWhileCharging(tool, UseAnim.BOW);
    }

    protected float getCharge(IToolStackView tool, ModifierEntry entry, int timeLeft) {
        int chargeTime = this.getUseDuration(tool, entry) - timeLeft;
        if (chargeTime < 0) {
            return 0.0f;
        }
        return GeneralInteractionModifierHook.getToolCharge(tool, chargeTime);
    }

    protected float getPower(IToolStackView tool, LivingEntity living) {
        return ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.PROJECTILE_DAMAGE) / 2.0f * ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.VELOCITY);
    }

    @Deprecated(forRemoval=true)
    protected float getForce(IToolStackView tool, ModifierEntry entry, LivingEntity living, int timeLeft, boolean applyKnockback) {
        float charge = this.getCharge(tool, entry, timeLeft);
        float knockback = 0.0f;
        if (applyKnockback) {
            knockback = (float)tool.getModifierLevel(TinkerModifiers.knockback.getId()) / 2.0f;
        }
        float force = charge * (ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.PROJECTILE_DAMAGE) + knockback) / 2.0f * ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.VELOCITY);
        if (applyKnockback) {
            force = (float)((double)force / Math.pow(2.0, tool.getModifierLevel(TinkerModifiers.padded.getId())));
        }
        return force;
    }

    public static float scaleKnockback(LivingEntity target, float knockback) {
        if (((Boolean)Config.COMMON.syncKnockbackResistance.get()).booleanValue()) {
            return (float)((double)knockback * target.m_21133_((Attribute)TinkerAttributes.KNOCKBACK_MULTIPLIER.get()) * (1.0 - target.m_21133_(Attributes.f_22278_)));
        }
        return knockback;
    }

    public static boolean isActive(IToolStackView tool, ModifierEntry modifier, ModifierEntry activeModifier) {
        return modifier == activeModifier || activeModifier.getLevel() == 0 && !tool.getPersistentData().contains(ModifiableLauncherItem.KEY_DRAWBACK_AMMO);
    }
}

