/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import slimeknights.tconstruct.smeltery.client.util.TintedVertexBuilder;

public class CastingItemRenderTypeBuffer
implements MultiBufferSource {
    private static final Set<String> MAKE_TRANSPARENT = ImmutableSet.of((Object)"entity_solid", (Object)"entity_cutout", (Object)"entity_cutout_no_cull", (Object)"entity_translucent", (Object)"entity_no_outline");
    private final MultiBufferSource inner;
    private final int alpha;
    private final int red;
    private final int green;
    private final int blue;

    public CastingItemRenderTypeBuffer(MultiBufferSource inner, int alpha, int temperature) {
        this.inner = inner;
        this.alpha = Mth.m_14045_((int)alpha, (int)0, (int)255);
        temperature = Mth.m_14045_((int)temperature, (int)0, (int)255);
        this.red = 255 - temperature * 79 / 255;
        this.green = 255 - temperature * 159 / 255;
        this.blue = 255 - temperature * 223 / 255;
    }

    public VertexConsumer m_6299_(RenderType type) {
        if (this.alpha < 255 && MAKE_TRANSPARENT.contains(type.f_110133_) && type instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType composite = (RenderType.CompositeRenderType)type;
            RenderStateShard.EmptyTextureStateShard emptyTextureStateShard = composite.f_110511_.f_110576_;
            if (emptyTextureStateShard instanceof RenderStateShard.TextureStateShard) {
                RenderStateShard.TextureStateShard textureState = (RenderStateShard.TextureStateShard)emptyTextureStateShard;
                ResourceLocation texture = textureState.f_110328_.orElse(InventoryMenu.f_39692_);
                type = RenderType.m_110470_((ResourceLocation)texture);
            }
        }
        return new TintedVertexBuilder(this.inner.m_6299_(type), this.red, this.green, this.blue, this.alpha);
    }
}

