/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.transfer;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.menu.TinkerStationContainerMenu;

@ApiStatus.Internal
public class TinkerStationTransferInfo<T>
implements IRecipeTransferInfo<TinkerStationContainerMenu, T>,
IRecipeTransferHandler<TinkerStationContainerMenu, T> {
    private final RecipeType<T> recipeType;
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IRecipeTransferHandler<TinkerStationContainerMenu, T> handler;

    public TinkerStationTransferInfo(RecipeType<T> recipeType, IRecipeTransferHandlerHelper handlerHelper) {
        this.recipeType = recipeType;
        this.handlerHelper = handlerHelper;
        this.handler = handlerHelper.createUnregisteredRecipeTransferHandler((IRecipeTransferInfo)this);
    }

    public Class<TinkerStationContainerMenu> getContainerClass() {
        return TinkerStationContainerMenu.class;
    }

    public Optional<MenuType<TinkerStationContainerMenu>> getMenuType() {
        return Optional.of((MenuType)TinkerTables.tinkerStationContainer.get());
    }

    public boolean canHandle(TinkerStationContainerMenu container, T recipe) {
        return true;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(TinkerStationContainerMenu container, T recipe, IRecipeSlotsView recipeSlotsView, Player player, boolean maxTransfer, boolean doTransfer) {
        int size;
        if (!this.handlerHelper.recipeTransferHasServerSupport()) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.no.server"));
        }
        List slotViews = recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT);
        if (!TinkerStationTransferInfo.validateRecipeFits(slotViews, size = container.getInputSlots().size())) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)Component.m_237115_((String)"jei.tconstruct.tinker_station.too_large"));
        }
        IRecipeSlotsView filteredSlotView = recipeSlotsView;
        if (slotViews.size() > size) {
            filteredSlotView = this.handlerHelper.createRecipeSlotsView(slotViews.subList(0, size));
        }
        return this.handler.transferRecipe((AbstractContainerMenu)container, recipe, filteredSlotView, player, maxTransfer, doTransfer);
    }

    public List<Slot> getRecipeSlots(TinkerStationContainerMenu container, T recipe) {
        return container.getInputSlots();
    }

    public List<Slot> getInventorySlots(TinkerStationContainerMenu container, T recipe) {
        int start;
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = start = container.getInputSlots().size() + 3 + ArmorItem.Type.values().length; i < start + 36; ++i) {
            Slot slot = container.m_38853_(i);
            slots.add(slot);
        }
        return slots;
    }

    private static boolean validateRecipeFits(List<IRecipeSlotView> slotViews, int size) {
        int bound = slotViews.size();
        for (int i = size; i < bound; ++i) {
            IRecipeSlotView slotView = slotViews.get(i);
            if (slotView.isEmpty() || !slotView.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK).isPresent()) continue;
            return false;
        }
        return true;
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }
}

