/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.behavior.AttributeModule;
import slimeknights.tconstruct.library.modifiers.modules.behavior.AttributeUniqueField;
import slimeknights.tconstruct.library.modifiers.modules.technical.MaxArmorLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.MaxArmorStatModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record MaxArmorAttributeModule(String unique, Attribute attribute, AttributeModifier.Operation operation, LevelingValue amount, UUID uuid, TinkerDataCapability.ComputableDataKey<ModifierMaxLevel> maxLevel, boolean allowBroken, @Nullable TagKey<Item> heldTag, AttributeModule.TooltipStyle tooltipStyle, ModifierCondition<IToolStackView> condition) implements EquipmentChangeModifierHook,
ModifierModule,
MaxArmorLevelModule,
TooltipModifierHook
{
    public static final RecordLoadable<MaxArmorAttributeModule> LOADER = RecordLoadable.create(new AttributeUniqueField<MaxArmorAttributeModule>(MaxArmorAttributeModule::unique), (RecordField)Loadables.ATTRIBUTE.requiredField("attribute", MaxArmorAttributeModule::attribute), (RecordField)TinkerLoadables.OPERATION.requiredField("operation", MaxArmorAttributeModule::operation), (RecordField)LevelingValue.LOADABLE.directField(MaxArmorAttributeModule::amount), (RecordField)BooleanLoadable.INSTANCE.defaultField("allow_broken", Boolean.valueOf(false), MaxArmorAttributeModule::allowBroken), (RecordField)Loadables.ITEM_TAG.nullableField("held_tag", MaxArmorAttributeModule::heldTag), (RecordField)AttributeModule.TooltipStyle.LOADABLE.defaultField("tooltip_style", (Object)AttributeModule.TooltipStyle.ATTRIBUTE, MaxArmorAttributeModule::tooltipStyle), ModifierCondition.TOOL_FIELD, MaxArmorAttributeModule::new);

    private MaxArmorAttributeModule(String unique, Attribute attribute, AttributeModifier.Operation operation, LevelingValue amount, boolean allowBroken, @Nullable TagKey<Item> heldTag, AttributeModule.TooltipStyle tooltipStyle, ModifierCondition<IToolStackView> condition) {
        this(unique, attribute, operation, amount, UUID.nameUUIDFromBytes(unique.getBytes()), MaxArmorLevelModule.createKey(BuiltInRegistries.f_256951_.m_7981_((Object)attribute)), allowBroken, heldTag, tooltipStyle, condition);
    }

    public RecordLoadable<MaxArmorAttributeModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return this.tooltipStyle == AttributeModule.TooltipStyle.NONE ? NO_TOOLTIP_HOOKS : TOOLTIP_HOOKS;
    }

    @Override
    public void updateValue(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context, TinkerDataCapability.Holder data, float newLevel, float oldLevel) {
        AttributeInstance instance = context.getEntity().m_21051_(this.attribute);
        if (instance != null) {
            instance.m_22120_(this.uuid);
            float attributeValue = this.amount.computeForLevel(newLevel);
            if (attributeValue != 0.0f) {
                instance.m_22118_(new AttributeModifier(this.uuid, this.unique, (double)attributeValue, this.operation));
            }
        }
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float value;
        if (MaxArmorLevelModule.shouldAddTooltip(this, tool, modifier, player) && (value = this.amount.computeForLevel(modifier.getEffectiveLevel())) != 0.0f) {
            AttributeModule.addTooltip(modifier.getModifier(), this.attribute, this.operation, this.tooltipStyle, value, this.uuid, player, tooltip);
        }
    }

    public static Builder builder(Attribute attribute, AttributeModifier.Operation operation) {
        return new Builder(attribute, operation);
    }

    public static Builder builder(Supplier<Attribute> attribute, AttributeModifier.Operation operation) {
        return new Builder(attribute.get(), operation);
    }

    public static class Builder
    extends ModuleBuilder.Stack<MaxArmorStatModule.Builder>
    implements LevelingValue.Builder<MaxArmorAttributeModule> {
        private final Attribute attribute;
        private final AttributeModifier.Operation operation;
        protected String unique = "";
        private boolean allowBroken = false;
        @Nullable
        private TagKey<Item> heldTag;
        private AttributeModule.TooltipStyle tooltipStyle = AttributeModule.TooltipStyle.ATTRIBUTE;

        public Builder allowBroken() {
            this.allowBroken = true;
            return this;
        }

        public Builder uniqueFrom(ResourceLocation id) {
            return this.unique(id.m_135827_() + ".modifier." + id.m_135815_());
        }

        @Override
        public MaxArmorAttributeModule amount(float flat, float eachLevel) {
            return new MaxArmorAttributeModule(this.unique, this.attribute, this.operation, new LevelingValue(flat, eachLevel), this.allowBroken, this.heldTag, this.tooltipStyle, this.condition);
        }

        public Builder unique(String unique) {
            this.unique = unique;
            return this;
        }

        public Builder allowBroken(boolean allowBroken) {
            this.allowBroken = allowBroken;
            return this;
        }

        public Builder heldTag(@Nullable TagKey<Item> heldTag) {
            this.heldTag = heldTag;
            return this;
        }

        public Builder tooltipStyle(AttributeModule.TooltipStyle tooltipStyle) {
            this.tooltipStyle = tooltipStyle;
            return this;
        }

        private Builder(Attribute attribute, AttributeModifier.Operation operation) {
            this.attribute = attribute;
            this.operation = operation;
        }
    }
}

