/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.predicate.material.MaterialPredicate;
import slimeknights.tconstruct.library.json.predicate.material.MaterialPredicateField;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.ingredient.NestedIngredient;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeCache;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialIngredient
extends NestedIngredient {
    private final IJsonPredicate<MaterialVariantId> material;
    @Nullable
    private ItemStack[] materialStacks;

    protected MaterialIngredient(Ingredient nested, IJsonPredicate<MaterialVariantId> material) {
        super(nested);
        this.material = material;
    }

    @Deprecated(forRemoval=true)
    protected MaterialIngredient(Ingredient nested, MaterialVariantId material, @Nullable TagKey<IMaterial> tag) {
        this(nested, MaterialIngredient.makePredicate(material, tag));
    }

    private static IJsonPredicate<MaterialVariantId> makePredicate(MaterialVariantId material, @Nullable TagKey<IMaterial> tag) {
        IJsonPredicate<MaterialVariantId> predicate;
        Object object = predicate = material.equals(IMaterial.UNKNOWN.getIdentifier()) ? MaterialPredicate.ANY : MaterialPredicate.variant(material);
        if (tag != null) {
            IJsonPredicate<MaterialVariantId> tagPredicate = MaterialPredicate.tag(tag);
            predicate = predicate == MaterialPredicate.ANY ? tagPredicate : MaterialPredicate.and(predicate, tagPredicate);
        }
        return predicate;
    }

    public static MaterialIngredient of(Ingredient ingredient, IJsonPredicate<MaterialVariantId> material) {
        return new MaterialIngredient(ingredient, material);
    }

    public static MaterialIngredient of(ItemLike item, IJsonPredicate<MaterialVariantId> material) {
        return MaterialIngredient.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), material);
    }

    public static MaterialIngredient of(Ingredient ingredient) {
        return new MaterialIngredient(ingredient, MaterialPredicate.ANY);
    }

    public static MaterialIngredient of(Ingredient ingredient, MaterialVariantId material) {
        return MaterialIngredient.of(ingredient, (IJsonPredicate<MaterialVariantId>)MaterialPredicate.variant(material));
    }

    public static MaterialIngredient of(Ingredient ingredient, TagKey<IMaterial> tag) {
        return MaterialIngredient.of(ingredient, MaterialPredicate.tag(tag));
    }

    public static MaterialIngredient of(ItemLike item, MaterialVariantId material) {
        return MaterialIngredient.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), material);
    }

    public static MaterialIngredient of(ItemLike item, TagKey<IMaterial> tag) {
        return MaterialIngredient.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), tag);
    }

    public static MaterialIngredient of(ItemLike item) {
        return MaterialIngredient.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public static MaterialIngredient of(TagKey<Item> tag, MaterialVariantId material) {
        return MaterialIngredient.of(Ingredient.m_204132_(tag), material);
    }

    public static MaterialIngredient of(TagKey<Item> tag) {
        return MaterialIngredient.of(Ingredient.m_204132_(tag));
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_() || !super.test(stack)) {
            return false;
        }
        if (this.material != MaterialPredicate.ANY) {
            return this.material.matches((Object)IMaterialItem.getMaterialFromStack(stack));
        }
        return true;
    }

    @Override
    public ItemStack[] m_43908_() {
        if (this.materialStacks == null) {
            if (!MaterialRegistry.isFullyLoaded()) {
                return this.nested.m_43908_();
            }
            Stream<Object> items = Arrays.stream(this.nested.m_43908_());
            items = items.flatMap(stack -> MaterialRecipeCache.getAllVariants().stream().filter(arg_0 -> this.material.matches(arg_0)).map(mat -> IMaterialItem.withMaterial(stack, mat)).filter(ItemStack::m_41782_));
            this.materialStacks = (ItemStack[])items.distinct().toArray(ItemStack[]::new);
        }
        return this.materialStacks;
    }

    public JsonElement m_43942_() {
        JsonObject result;
        JsonElement parent = this.nested.m_43942_();
        if (this.nested.isVanilla() && parent.isJsonObject()) {
            result = parent.getAsJsonObject();
        } else {
            result = new JsonObject();
            result.add("match", parent);
        }
        result.addProperty("type", Serializer.ID.toString());
        Serializer.MATERIAL_FIELD.serialize((Object)this, result);
        return result;
    }

    @Override
    protected void invalidate() {
        super.invalidate();
        this.materialStacks = null;
    }

    @Override
    public boolean isSimple() {
        return this.material == MaterialPredicate.ANY;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static enum Serializer implements IIngredientSerializer<MaterialIngredient>
    {
        INSTANCE;

        public static final ResourceLocation ID;
        private static final LoadableField<IJsonPredicate<MaterialVariantId>, MaterialIngredient> MATERIAL_FIELD;

        public MaterialIngredient parse(JsonObject json) {
            Ingredient ingredient = json.has("match") ? CraftingHelper.getIngredient((JsonElement)json.get("match"), (boolean)false) : VanillaIngredientSerializer.INSTANCE.parse(json);
            IJsonPredicate<MaterialVariantId> material = (IJsonPredicate<MaterialVariantId>)MATERIAL_FIELD.get(json);
            if (json.has("tag")) {
                TConstruct.LOG.warn("Using deprecated tag field on material ingredient");
                IJsonPredicate<MaterialVariantId> tagPredicate = MaterialPredicate.tag((TagKey<IMaterial>)((TagKey)TinkerLoadables.MATERIAL_TAGS.getIfPresent(json, "tag")));
                material = material == MaterialPredicate.ANY ? tagPredicate : MaterialPredicate.and(material, tagPredicate);
            }
            return new MaterialIngredient(ingredient, material);
        }

        public MaterialIngredient parse(FriendlyByteBuf buffer) {
            return new MaterialIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), (IJsonPredicate<MaterialVariantId>)((IJsonPredicate)MATERIAL_FIELD.decode(buffer)));
        }

        public void write(FriendlyByteBuf buffer, MaterialIngredient ingredient) {
            ingredient.nested.m_43923_(buffer);
            MATERIAL_FIELD.encode(buffer, (Object)ingredient);
        }

        static {
            ID = TConstruct.getResource("material");
            MATERIAL_FIELD = new MaterialPredicateField<MaterialIngredient>("material", i -> i.material);
        }
    }
}

