/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.block.GaugeBlock;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.fluids.item.EmptyPotionTransfer;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.casting.CastDuplicationRecipe;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.PotionCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.RetexturedCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.TipClearingCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.TippingCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.container.ContainerFillingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.PartSwapCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.ToolCastingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.melting.DamageableMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.OreMeltingRecipe;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.PartCastItem;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.ClearGlassPaneBlock;
import slimeknights.tconstruct.shared.block.PlaceBlockDispenserBehavior;
import slimeknights.tconstruct.shared.block.SoulGlassPaneBlock;
import slimeknights.tconstruct.smeltery.block.CastingBasinBlock;
import slimeknights.tconstruct.smeltery.block.CastingTableBlock;
import slimeknights.tconstruct.smeltery.block.CastingTankBlock;
import slimeknights.tconstruct.smeltery.block.ChannelBlock;
import slimeknights.tconstruct.smeltery.block.FaucetBlock;
import slimeknights.tconstruct.smeltery.block.FluidCannonBlock;
import slimeknights.tconstruct.smeltery.block.ProxyTankBlock;
import slimeknights.tconstruct.smeltery.block.RenderingGaugeBlock;
import slimeknights.tconstruct.smeltery.block.SearedLanternBlock;
import slimeknights.tconstruct.smeltery.block.component.RetexturedOrientableSmelteryBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedDrainBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedDuctBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedGlassBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedLadderBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedPillarBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedSoulGlassBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedTintedGlassBlock;
import slimeknights.tconstruct.smeltery.block.controller.AlloyerBlock;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.FoundryControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.HeaterBlock;
import slimeknights.tconstruct.smeltery.block.controller.MelterBlock;
import slimeknights.tconstruct.smeltery.block.controller.SmelteryControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.CastingBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.CastingTankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.ChannelBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.FaucetBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.FluidCannonBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.GaugeBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.HeaterBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.LanternBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.ProxyTankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.DrainBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.DuctBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.SmelteryComponentBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.SmelteryInputOutputBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.controller.AlloyerBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.controller.FoundryBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.controller.MelterBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.controller.SmelteryBlockEntity;
import slimeknights.tconstruct.smeltery.data.FluidContainerTransferProvider;
import slimeknights.tconstruct.smeltery.data.SmelteryRecipeProvider;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;
import slimeknights.tconstruct.smeltery.item.DummyMaterialItem;
import slimeknights.tconstruct.smeltery.item.TankItem;
import slimeknights.tconstruct.smeltery.menu.AlloyerContainerMenu;
import slimeknights.tconstruct.smeltery.menu.HeatingStructureContainerMenu;
import slimeknights.tconstruct.smeltery.menu.MelterContainerMenu;
import slimeknights.tconstruct.smeltery.menu.SingleItemContainerMenu;
import slimeknights.tconstruct.tools.TinkerToolParts;

public final class TinkerSmeltery
extends TinkerModule {
    private static final BlockBehaviour.StatePredicate NEVER = Blocks::m_50805_;
    public static final RegistryObject<CreativeModeTab> tabSmeltery = CREATIVE_TABS.register("smeltery", () -> CreativeModeTab.builder().m_257941_((Component)TConstruct.makeTranslation("itemGroup", "smeltery")).m_257737_(() -> new ItemStack(smelteryController)).m_257501_(TinkerSmeltery::addTabItems).withTabsBefore(new ResourceLocation[]{TinkerToolParts.tabToolParts.getId()}).m_257652_());
    public static final ItemObject<Block> grout = BLOCKS.register("grout", TinkerSmeltery.builder(MapColor.f_283779_, SoundType.f_56746_).m_280658_(NoteBlockInstrument.SNARE).m_60978_(3.0f).m_60911_(0.8f), TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<Block> netherGrout = BLOCKS.register("nether_grout", TinkerSmeltery.builder(MapColor.f_283748_, SoundType.f_56717_).m_280658_(NoteBlockInstrument.SNARE).m_60978_(3.0f).m_60911_(0.8f), TOOLTIP_BLOCK_ITEM);
    public static final BuildingBlockObject searedStone;
    public static final BuildingBlockObject searedPaver;
    public static final WallBuildingBlockObject searedCobble;
    public static final WallBuildingBlockObject searedBricks;
    public static final ItemObject<Block> searedCrackedBricks;
    public static final ItemObject<Block> searedFancyBricks;
    public static final ItemObject<Block> searedTriangleBricks;
    public static final ItemObject<Block> searedLamp;
    public static final ItemObject<Block> scorchedStone;
    public static final ItemObject<Block> polishedScorchedStone;
    public static final ItemObject<Block> chiseledScorchedBricks;
    public static final FenceBuildingBlockObject scorchedBricks;
    public static final BuildingBlockObject scorchedRoad;
    public static final ItemObject<Block> scorchedLamp;
    public static final ItemObject<SearedGlassBlock> searedGlass;
    public static final ItemObject<SearedGlassBlock> scorchedGlass;
    public static final ItemObject<ClearGlassPaneBlock> searedGlassPane;
    public static final ItemObject<ClearGlassPaneBlock> scorchedGlassPane;
    public static final ItemObject<SearedTintedGlassBlock> searedTintedGlass;
    public static final ItemObject<SearedTintedGlassBlock> scorchedTintedGlass;
    public static final ItemObject<SearedSoulGlassBlock> searedSoulGlass;
    public static final ItemObject<SearedSoulGlassBlock> scorchedSoulGlass;
    public static final ItemObject<SoulGlassPaneBlock> searedSoulGlassPane;
    public static final ItemObject<SoulGlassPaneBlock> scorchedSoulGlassPane;
    public static final ItemObject<Block> searedDrain;
    public static final ItemObject<Block> searedDuct;
    public static final ItemObject<Block> searedChute;
    public static final ItemObject<Block> scorchedDrain;
    public static final ItemObject<Block> scorchedDuct;
    public static final ItemObject<Block> scorchedChute;
    public static final ItemObject<SearedLadderBlock> searedLadder;
    public static final ItemObject<SearedLadderBlock> scorchedLadder;
    public static final ItemObject<FaucetBlock> searedFaucet;
    public static final ItemObject<FaucetBlock> scorchedFaucet;
    public static final ItemObject<ChannelBlock> searedChannel;
    public static final ItemObject<ChannelBlock> scorchedChannel;
    public static final ItemObject<CastingBasinBlock> searedBasin;
    public static final ItemObject<CastingBasinBlock> scorchedBasin;
    public static final ItemObject<CastingTableBlock> searedTable;
    public static final ItemObject<CastingTableBlock> scorchedTable;
    public static final ItemObject<ProxyTankBlock> scorchedProxyTank;
    public static final EnumObject<SearedTankBlock.TankType, SearedTankBlock> searedTank;
    public static final EnumObject<SearedTankBlock.TankType, SearedTankBlock> scorchedTank;
    public static final ItemObject<CastingTankBlock> searedCastingTank;
    public static final ItemObject<FluidCannonBlock> searedFluidCannon;
    public static final ItemObject<FluidCannonBlock> scorchedFluidCannon;
    public static final ItemObject<SearedLanternBlock> searedLantern;
    public static final ItemObject<SearedLanternBlock> scorchedLantern;
    public static final ItemObject<GaugeBlock> copperGauge;
    public static final ItemObject<GaugeBlock> obsidianGauge;
    public static final ItemObject<SmelteryControllerBlock> smelteryController;
    public static final ItemObject<FoundryControllerBlock> foundryController;
    public static final ItemObject<MelterBlock> searedMelter;
    public static final ItemObject<HeaterBlock> searedHeater;
    public static final ItemObject<AlloyerBlock> scorchedAlloyer;
    public static final RegistryObject<BlockEntityType<SmelteryComponentBlockEntity>> smelteryComponent;
    public static final RegistryObject<BlockEntityType<SmelteryInputOutputBlockEntity.SmelteryFluidIO>> drain;
    public static final RegistryObject<BlockEntityType<SmelteryInputOutputBlockEntity.ChuteBlockEntity>> chute;
    public static final RegistryObject<BlockEntityType<DuctBlockEntity>> duct;
    public static final RegistryObject<BlockEntityType<TankBlockEntity>> tank;
    public static final RegistryObject<BlockEntityType<FluidCannonBlockEntity>> fluidCannon;
    public static final RegistryObject<BlockEntityType<LanternBlockEntity>> lantern;
    public static final RegistryObject<BlockEntityType<MelterBlockEntity>> melter;
    public static final RegistryObject<BlockEntityType<SmelteryBlockEntity>> smeltery;
    public static final RegistryObject<BlockEntityType<FoundryBlockEntity>> foundry;
    public static final RegistryObject<BlockEntityType<HeaterBlockEntity>> heater;
    public static final RegistryObject<BlockEntityType<AlloyerBlockEntity>> alloyer;
    public static final RegistryObject<BlockEntityType<FaucetBlockEntity>> faucet;
    public static final RegistryObject<BlockEntityType<ChannelBlockEntity>> channel;
    public static final RegistryObject<BlockEntityType<GaugeBlockEntity>> gauge;
    public static final RegistryObject<BlockEntityType<CastingBlockEntity>> basin;
    public static final RegistryObject<BlockEntityType<CastingBlockEntity>> table;
    public static final RegistryObject<BlockEntityType<ProxyTankBlockEntity>> proxyTank;
    public static final RegistryObject<BlockEntityType<CastingTankBlockEntity>> castingTank;
    public static final ItemObject<Item> searedBrick;
    public static final ItemObject<Item> scorchedBrick;
    public static final ItemObject<Item> copperCan;
    public static final ItemObject<Item> blankSandCast;
    public static final ItemObject<Item> blankRedSandCast;
    public static final CastItemObject ingotCast;
    public static final CastItemObject nuggetCast;
    public static final CastItemObject gemCast;
    public static final CastItemObject rodCast;
    public static final CastItemObject repairKitCast;
    public static final CastItemObject plateCast;
    public static final CastItemObject gearCast;
    public static final CastItemObject coinCast;
    public static final CastItemObject wireCast;
    public static final CastItemObject pickHeadCast;
    public static final CastItemObject smallAxeHeadCast;
    public static final CastItemObject smallBladeCast;
    public static final CastItemObject adzeHeadCast;
    public static final CastItemObject hammerHeadCast;
    public static final CastItemObject broadBladeCast;
    public static final CastItemObject broadAxeHeadCast;
    public static final CastItemObject largePlateCast;
    public static final CastItemObject toolBindingCast;
    public static final CastItemObject toughBindingCast;
    public static final CastItemObject toolHandleCast;
    public static final CastItemObject toughHandleCast;
    public static final CastItemObject bowLimbCast;
    public static final CastItemObject bowGripCast;
    public static final ItemObject<Item> arrowCast;
    public static final CastItemObject helmetPlatingCast;
    public static final CastItemObject chestplatePlatingCast;
    public static final CastItemObject leggingsPlatingCast;
    public static final CastItemObject bootsPlatingCast;
    public static final CastItemObject mailleCast;
    public static final EnumObject<ArmorItem.Type, DummyMaterialItem> dummyPlating;
    public static final RegistryObject<TypeAwareRecipeSerializer<ItemCastingRecipe>> basinRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<ItemCastingRecipe>> tableRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<ContainerFillingRecipe>> basinFillingRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<ContainerFillingRecipe>> tableFillingRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<CastDuplicationRecipe>> basinDuplicationRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<CastDuplicationRecipe>> tableDuplicationRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<PotionCastingRecipe>> basinPotionRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<PotionCastingRecipe>> tablePotionRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<TippingCastingRecipe>> basinTippingRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<TippingCastingRecipe>> tableTippingRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<TipClearingCastingRecipe>> basinTipClearingRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<TipClearingCastingRecipe>> tableTipClearingRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<RetexturedCastingRecipe>> retexturedBasinRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<RetexturedCastingRecipe>> retexturedTableRecipeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<MaterialCastingRecipe>> basinMaterialSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<MaterialCastingRecipe>> tableMaterialSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<CompositeCastingRecipe>> basinCompositeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<CompositeCastingRecipe>> tableCompositeSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<ToolCastingRecipe>> basinToolSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<ToolCastingRecipe>> tableToolSerializer;
    public static final RegistryObject<RecipeSerializer<MaterialFluidRecipe>> materialFluidRecipe;
    public static final RegistryObject<TypeAwareRecipeSerializer<PartSwapCastingRecipe>> basinPartSwappingSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<PartSwapCastingRecipe>> tablePartSwappingSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<MoldingRecipe>> moldingBasinSerializer;
    public static final RegistryObject<TypeAwareRecipeSerializer<MoldingRecipe>> moldingTableSerializer;
    public static final RegistryObject<RecipeSerializer<MeltingRecipe>> meltingSerializer;
    public static final RegistryObject<RecipeSerializer<OreMeltingRecipe>> oreMeltingSerializer;
    public static final RegistryObject<RecipeSerializer<DamageableMeltingRecipe>> damagableMeltingSerializer;
    public static final RegistryObject<RecipeSerializer<MaterialMeltingRecipe>> materialMeltingSerializer;
    public static final RegistryObject<RecipeSerializer<MeltingFuel>> fuelSerializer;
    public static final RegistryObject<RecipeSerializer<EntityMeltingRecipe>> entityMeltingSerializer;
    public static final RegistryObject<RecipeSerializer<AlloyRecipe>> alloyingSerializer;
    public static final RegistryObject<MenuType<MelterContainerMenu>> melterContainer;
    public static final RegistryObject<MenuType<HeatingStructureContainerMenu>> smelteryContainer;
    public static final RegistryObject<MenuType<SingleItemContainerMenu>> singleItemContainer;
    public static final RegistryObject<MenuType<AlloyerContainerMenu>> alloyerContainer;

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Consumer<Block> dispenserBehavior = block -> DispenserBlock.m_52672_((ItemLike)block.m_5456_(), (DispenseItemBehavior)PlaceBlockDispenserBehavior.INSTANCE);
            searedTank.forEach(dispenserBehavior);
            scorchedTank.forEach(dispenserBehavior);
        });
    }

    @SubscribeEvent
    void registerSerializers(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.f_256764_) {
            FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(EmptyPotionTransfer.ID, EmptyPotionTransfer.DESERIALIZER);
        }
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        boolean server = event.includeServer();
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(server, (DataProvider)new SmelteryRecipeProvider(packOutput));
        generator.addProvider(server, (DataProvider)new FluidContainerTransferProvider(packOutput));
    }

    private static void addTabItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        output.m_246326_(grout);
        output.m_246326_(searedBrick);
        output.m_246326_(netherGrout);
        output.m_246326_(scorchedBrick);
        output.m_246326_(copperCan);
        output.m_246326_(searedMelter);
        output.m_246326_(searedHeater);
        output.m_246326_(scorchedAlloyer);
        output.m_246326_(smelteryController);
        output.m_246326_(foundryController);
        output.m_246326_(searedDrain);
        output.m_246326_(searedDuct);
        output.m_246326_(searedChute);
        output.m_246326_(scorchedDrain);
        output.m_246326_(scorchedDuct);
        output.m_246326_(scorchedChute);
        output.m_246326_(copperGauge);
        output.m_246326_(obsidianGauge);
        TinkerSmeltery.accept(output, searedTank);
        output.m_246342_(TankItem.fillTank(searedTank, SearedTankBlock.TankType.FUEL_TANK, (Fluid)Fluids.f_76195_));
        output.m_246342_(TankItem.fillTank(searedTank, SearedTankBlock.TankType.FUEL_TANK, TinkerFluids.blazingBlood.get()));
        output.m_246326_(searedLantern);
        TinkerSmeltery.accept(output, scorchedTank);
        output.m_246342_(TankItem.fillTank(scorchedTank, SearedTankBlock.TankType.FUEL_TANK, (Fluid)Fluids.f_76195_));
        output.m_246342_(TankItem.fillTank(scorchedTank, SearedTankBlock.TankType.FUEL_TANK, TinkerFluids.blazingBlood.get()));
        output.m_246326_(scorchedLantern);
        output.m_246326_(searedFaucet);
        output.m_246326_(scorchedFaucet);
        output.m_246326_(searedChannel);
        output.m_246326_(scorchedChannel);
        output.m_246326_(searedTable);
        output.m_246326_(scorchedTable);
        output.m_245282_(TinkerCommons.goldBars, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
        output.m_246326_(searedBasin);
        output.m_246326_(scorchedBasin);
        output.m_245282_(TinkerCommons.goldPlatform, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
        output.m_246326_(searedCastingTank);
        output.m_246326_(scorchedProxyTank);
        output.m_246326_(searedFluidCannon);
        output.m_246326_(scorchedFluidCannon);
        TinkerSmeltery.accept(output, (BuildingBlockObject)searedBricks);
        TinkerSmeltery.accept(output, searedStone);
        output.m_246326_(searedCrackedBricks);
        output.m_246326_(searedFancyBricks);
        output.m_246326_(searedTriangleBricks);
        TinkerSmeltery.accept(output, (BuildingBlockObject)searedCobble);
        TinkerSmeltery.accept(output, searedPaver);
        output.m_246326_(searedLamp);
        output.m_246326_(searedLadder);
        output.m_246326_(searedGlass);
        output.m_246326_(searedTintedGlass);
        output.m_246326_(searedSoulGlass);
        output.m_246326_(searedGlassPane);
        output.m_246326_(searedSoulGlassPane);
        TinkerSmeltery.accept(output, (BuildingBlockObject)scorchedBricks);
        output.m_246326_(chiseledScorchedBricks);
        output.m_246326_(scorchedStone);
        output.m_246326_(polishedScorchedStone);
        TinkerSmeltery.accept(output, scorchedRoad);
        output.m_246326_(scorchedLamp);
        output.m_246326_(scorchedLadder);
        output.m_246326_(scorchedGlass);
        output.m_246326_(scorchedTintedGlass);
        output.m_246326_(scorchedSoulGlass);
        output.m_246326_(scorchedGlassPane);
        output.m_246326_(scorchedSoulGlassPane);
        TinkerSmeltery.addCasts(output, ItemObject::get);
        output.m_246326_(blankSandCast);
        TinkerSmeltery.addCasts(output, CastItemObject::getSand);
        output.m_246326_(blankRedSandCast);
        TinkerSmeltery.addCasts(output, CastItemObject::getRedSand);
        Predicate<ItemStack> variant = stack -> {
            output.m_246342_(stack);
            return false;
        };
        RetexturedHelper.addTagVariants(variant, smelteryController, TinkerTags.Items.SEARED_BLOCKS);
        RetexturedHelper.addTagVariants(variant, searedDrain, TinkerTags.Items.SEARED_BLOCKS);
        RetexturedHelper.addTagVariants(variant, searedDuct, TinkerTags.Items.SEARED_BLOCKS);
        RetexturedHelper.addTagVariants(variant, searedChute, TinkerTags.Items.SEARED_BLOCKS);
        RetexturedHelper.addTagVariants(variant, foundryController, TinkerTags.Items.SCORCHED_BLOCKS);
        RetexturedHelper.addTagVariants(variant, scorchedDrain, TinkerTags.Items.SCORCHED_BLOCKS);
        RetexturedHelper.addTagVariants(variant, scorchedDuct, TinkerTags.Items.SCORCHED_BLOCKS);
        RetexturedHelper.addTagVariants(variant, scorchedChute, TinkerTags.Items.SCORCHED_BLOCKS);
    }

    private static void addCasts(CreativeModeTab.Output output, Function<CastItemObject, ItemLike> getter) {
        TinkerSmeltery.accept(output, getter, ingotCast);
        TinkerSmeltery.accept(output, getter, nuggetCast);
        TinkerSmeltery.accept(output, getter, gemCast);
        TinkerSmeltery.accept(output, getter, rodCast);
        TinkerSmeltery.accept(output, getter, repairKitCast);
        TinkerSmeltery.acceptIfTag(output, getter, plateCast);
        TinkerSmeltery.acceptIfTag(output, getter, gearCast);
        TinkerSmeltery.acceptIfTag(output, getter, coinCast);
        TinkerSmeltery.acceptIfTag(output, getter, wireCast);
        TinkerSmeltery.accept(output, getter, pickHeadCast);
        TinkerSmeltery.accept(output, getter, smallAxeHeadCast);
        TinkerSmeltery.accept(output, getter, smallBladeCast);
        TinkerSmeltery.accept(output, getter, adzeHeadCast);
        TinkerSmeltery.accept(output, getter, hammerHeadCast);
        TinkerSmeltery.accept(output, getter, broadAxeHeadCast);
        TinkerSmeltery.accept(output, getter, broadBladeCast);
        TinkerSmeltery.accept(output, getter, largePlateCast);
        TinkerSmeltery.accept(output, getter, toolHandleCast);
        TinkerSmeltery.accept(output, getter, toolBindingCast);
        TinkerSmeltery.accept(output, getter, toughHandleCast);
        TinkerSmeltery.accept(output, getter, toughBindingCast);
        TinkerSmeltery.accept(output, getter, bowLimbCast);
        TinkerSmeltery.accept(output, getter, bowGripCast);
        output.m_246326_(arrowCast);
        TinkerSmeltery.accept(output, getter, helmetPlatingCast);
        TinkerSmeltery.accept(output, getter, chestplatePlatingCast);
        TinkerSmeltery.accept(output, getter, leggingsPlatingCast);
        TinkerSmeltery.accept(output, getter, bootsPlatingCast);
        TinkerSmeltery.accept(output, getter, mailleCast);
    }

    private static void accept(CreativeModeTab.Output output, Function<CastItemObject, ItemLike> getter, CastItemObject cast) {
        output.m_246326_(getter.apply(cast));
    }

    private static void acceptIfTag(CreativeModeTab.Output output, Function<CastItemObject, ItemLike> getter, CastItemObject cast) {
        TinkerSmeltery.acceptIfTag(output, getter.apply(cast), (TagKey<Item>)ItemTags.create((ResourceLocation)Mantle.commonResource((String)(cast.getName().m_135815_() + "s"))));
    }

    private static BlockBehaviour.Properties structureProps(MapColor color, SoundType sound) {
        return TinkerSmeltery.builder(color, sound).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60922_(SearedBlock.VALID_SPAWN);
    }

    private static BlockBehaviour.Properties structureNonSolid(MapColor color, SoundType sound) {
        return TinkerSmeltery.structureProps(color, sound).m_60922_(Blocks::m_50778_).m_60924_(NEVER).m_60960_(NEVER).m_60971_(NEVER).m_60955_();
    }

    private static BlockBehaviour.Properties searedSolidProps(int factor) {
        return TinkerSmeltery.structureProps(MapColor.f_283818_, SoundType.f_56743_).m_60913_(3.0f * (float)factor, 9.0f * (float)factor);
    }

    private static BlockBehaviour.Properties searedNonSolidProps(SoundType sound) {
        return TinkerSmeltery.structureNonSolid(MapColor.f_283818_, sound).m_60913_(3.0f, 9.0f);
    }

    private static BlockBehaviour.Properties scorchedSolidProps(int factor) {
        return TinkerSmeltery.structureProps(MapColor.f_283774_, SoundType.f_56718_).m_60913_(2.5f * (float)factor, 8.0f * (float)factor);
    }

    private static BlockBehaviour.Properties scorchedNonSolidProps(SoundType sound) {
        return TinkerSmeltery.structureNonSolid(MapColor.f_283774_, sound).m_60913_(2.5f, 8.0f);
    }

    private static /* synthetic */ AlloyerBlock lambda$static$62(Supplier scorched) {
        return new AlloyerBlock(((BlockBehaviour.Properties)scorched.get()).m_60955_());
    }

    private static /* synthetic */ HeaterBlock lambda$static$61(Supplier seared) {
        return new HeaterBlock((BlockBehaviour.Properties)seared.get());
    }

    private static /* synthetic */ MelterBlock lambda$static$60(Supplier seared) {
        return new MelterBlock(((BlockBehaviour.Properties)seared.get()).m_60955_());
    }

    private static /* synthetic */ FoundryControllerBlock lambda$static$59(Supplier scorched) {
        return new FoundryControllerBlock((BlockBehaviour.Properties)scorched.get());
    }

    private static /* synthetic */ SmelteryControllerBlock lambda$static$58(Supplier seared) {
        return new SmelteryControllerBlock((BlockBehaviour.Properties)seared.get());
    }

    private static /* synthetic */ FluidCannonBlock lambda$static$46(BlockBehaviour.Properties scorched) {
        return new FluidCannonBlock(scorched, 2000, 2.0f, 1.5f, 7.0f);
    }

    private static /* synthetic */ SearedTankBlock lambda$static$44(BlockBehaviour.Properties scorched, SearedTankBlock.TankType type) {
        return new SearedTankBlock(scorched, type.getCapacity(), PushReaction.DESTROY);
    }

    private static /* synthetic */ FluidCannonBlock lambda$static$42(BlockBehaviour.Properties seared) {
        return new FluidCannonBlock(seared, 2000, 1.0f, 1.1f, 6.0f);
    }

    private static /* synthetic */ CastingTankBlock lambda$static$40(BlockBehaviour.Properties seared) {
        return new CastingTankBlock(seared);
    }

    private static /* synthetic */ SearedTankBlock lambda$static$38(BlockBehaviour.Properties seared, SearedTankBlock.TankType type) {
        return new SearedTankBlock(seared, type.getCapacity(), PushReaction.DESTROY);
    }

    private static /* synthetic */ ProxyTankBlock lambda$static$37(BlockBehaviour.Properties scorched) {
        return new ProxyTankBlock(scorched);
    }

    private static /* synthetic */ CastingTableBlock lambda$static$36(BlockBehaviour.Properties scorched) {
        return new CastingTableBlock(scorched, true);
    }

    private static /* synthetic */ CastingBasinBlock lambda$static$35(BlockBehaviour.Properties scorched) {
        return new CastingBasinBlock(scorched, true);
    }

    private static /* synthetic */ ChannelBlock lambda$static$34(BlockBehaviour.Properties scorched) {
        return new ChannelBlock(scorched);
    }

    private static /* synthetic */ FaucetBlock lambda$static$33(BlockBehaviour.Properties scorched) {
        return new FaucetBlock(scorched);
    }

    private static /* synthetic */ SearedLadderBlock lambda$static$32(BlockBehaviour.Properties scorched) {
        return new SearedLadderBlock(scorched);
    }

    private static /* synthetic */ CastingTableBlock lambda$static$31(BlockBehaviour.Properties seared) {
        return new CastingTableBlock(seared, false);
    }

    private static /* synthetic */ CastingBasinBlock lambda$static$30(BlockBehaviour.Properties seared) {
        return new CastingBasinBlock(seared, false);
    }

    private static /* synthetic */ ChannelBlock lambda$static$29(BlockBehaviour.Properties seared) {
        return new ChannelBlock(seared);
    }

    private static /* synthetic */ FaucetBlock lambda$static$28(BlockBehaviour.Properties seared) {
        return new FaucetBlock(seared);
    }

    private static /* synthetic */ SearedLadderBlock lambda$static$27(BlockBehaviour.Properties seared) {
        return new SearedLadderBlock(seared);
    }

    private static /* synthetic */ Block lambda$static$26(BlockBehaviour.Properties scorched) {
        return new RetexturedOrientableSmelteryBlock(scorched, (BlockEntityType.BlockEntitySupplier<? extends SmelteryComponentBlockEntity>)((BlockEntityType.BlockEntitySupplier)SmelteryInputOutputBlockEntity.ChuteBlockEntity::new));
    }

    private static /* synthetic */ Block lambda$static$25(BlockBehaviour.Properties scorched) {
        return new SearedDuctBlock(scorched);
    }

    private static /* synthetic */ Block lambda$static$24(BlockBehaviour.Properties scorched) {
        return new SearedDrainBlock(scorched);
    }

    private static /* synthetic */ Block lambda$static$23(BlockBehaviour.Properties seared) {
        return new RetexturedOrientableSmelteryBlock(seared, (BlockEntityType.BlockEntitySupplier<? extends SmelteryComponentBlockEntity>)((BlockEntityType.BlockEntitySupplier)SmelteryInputOutputBlockEntity.ChuteBlockEntity::new));
    }

    private static /* synthetic */ Block lambda$static$22(BlockBehaviour.Properties seared) {
        return new SearedDuctBlock(seared);
    }

    private static /* synthetic */ Block lambda$static$21(BlockBehaviour.Properties seared) {
        return new SearedDrainBlock(seared);
    }

    private static /* synthetic */ SoulGlassPaneBlock lambda$static$20(BlockBehaviour.Properties scorched) {
        return new SoulGlassPaneBlock(scorched);
    }

    private static /* synthetic */ SearedSoulGlassBlock lambda$static$19(BlockBehaviour.Properties scorched) {
        return new SearedSoulGlassBlock(scorched);
    }

    private static /* synthetic */ SoulGlassPaneBlock lambda$static$17(BlockBehaviour.Properties seared) {
        return new SoulGlassPaneBlock(seared);
    }

    private static /* synthetic */ SearedSoulGlassBlock lambda$static$16(BlockBehaviour.Properties seared) {
        return new SearedSoulGlassBlock(seared);
    }

    private static /* synthetic */ ClearGlassPaneBlock lambda$static$14(BlockBehaviour.Properties scorched) {
        return new ClearGlassPaneBlock(scorched);
    }

    private static /* synthetic */ SearedTintedGlassBlock lambda$static$13(BlockBehaviour.Properties scorched) {
        return new SearedTintedGlassBlock(scorched);
    }

    private static /* synthetic */ SearedGlassBlock lambda$static$12(BlockBehaviour.Properties scorched) {
        return new SearedGlassBlock(scorched);
    }

    private static /* synthetic */ SearedTintedGlassBlock lambda$static$11(BlockBehaviour.Properties seared) {
        return new SearedTintedGlassBlock(seared);
    }

    private static /* synthetic */ ClearGlassPaneBlock lambda$static$10(BlockBehaviour.Properties seared) {
        return new ClearGlassPaneBlock(seared);
    }

    private static /* synthetic */ SearedGlassBlock lambda$static$9(BlockBehaviour.Properties seared) {
        return new SearedGlassBlock(seared);
    }

    static {
        BlockBehaviour.Properties properties = TinkerSmeltery.searedSolidProps(1);
        Supplier<SearedBlock> searedBlock = () -> new SearedBlock(properties, false);
        searedStone = BLOCKS.registerBuilding("seared_stone", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedCobble = BLOCKS.registerWallBuilding("seared_cobble", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedPaver = BLOCKS.registerBuilding("seared_paver", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedBricks = BLOCKS.registerWallBuilding("seared_bricks", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedCrackedBricks = BLOCKS.register("seared_cracked_bricks", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedFancyBricks = BLOCKS.register("seared_fancy_bricks", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedTriangleBricks = BLOCKS.register("seared_triangle_bricks", searedBlock, TOOLTIP_BLOCK_ITEM);
        searedLamp = BLOCKS.register("seared_lamp", () -> new SearedBlock(TinkerSmeltery.searedSolidProps(1).m_60953_(state -> 15), false), TOOLTIP_BLOCK_ITEM);
        properties = TinkerSmeltery.scorchedSolidProps(1);
        Supplier<SearedPillarBlock> pillar = () -> new SearedPillarBlock(properties, false);
        scorchedStone = BLOCKS.register("scorched_stone", pillar, TOOLTIP_BLOCK_ITEM);
        polishedScorchedStone = BLOCKS.register("polished_scorched_stone", pillar, TOOLTIP_BLOCK_ITEM);
        Supplier<SearedBlock> block = () -> new SearedBlock(properties, false);
        scorchedBricks = BLOCKS.registerFenceBuilding("scorched_bricks", block, TOOLTIP_BLOCK_ITEM);
        scorchedRoad = BLOCKS.registerBuilding("scorched_road", block, TOOLTIP_BLOCK_ITEM);
        chiseledScorchedBricks = BLOCKS.register("chiseled_scorched_bricks", block, TOOLTIP_BLOCK_ITEM);
        scorchedLamp = BLOCKS.register("scorched_lamp", () -> new SearedBlock(TinkerSmeltery.scorchedSolidProps(1).m_60953_(state -> 15), false), TOOLTIP_BLOCK_ITEM);
        Object seared = TinkerSmeltery.searedNonSolidProps(SoundType.f_56744_);
        searedGlass = BLOCKS.register("seared_glass", () -> TinkerSmeltery.lambda$static$9((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        searedGlassPane = BLOCKS.register("seared_glass_pane", () -> TinkerSmeltery.lambda$static$10((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        searedTintedGlass = BLOCKS.register("seared_tinted_glass", () -> TinkerSmeltery.lambda$static$11((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        Object scorched = TinkerSmeltery.scorchedNonSolidProps(SoundType.f_56744_);
        scorchedGlass = BLOCKS.register("scorched_glass", () -> TinkerSmeltery.lambda$static$12((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        scorchedTintedGlass = BLOCKS.register("scorched_tinted_glass", () -> TinkerSmeltery.lambda$static$13((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        scorchedGlassPane = BLOCKS.register("scorched_glass_pane", () -> TinkerSmeltery.lambda$static$14((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        seared = TinkerSmeltery.searedNonSolidProps(SoundType.f_56744_).m_60910_().m_60956_(0.1f).m_60971_((state, getter, pos) -> true);
        searedSoulGlass = BLOCKS.register("seared_soul_glass", () -> TinkerSmeltery.lambda$static$16((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        searedSoulGlassPane = BLOCKS.register("seared_soul_glass_pane", () -> TinkerSmeltery.lambda$static$17((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        scorched = TinkerSmeltery.scorchedNonSolidProps(SoundType.f_56744_).m_60910_().m_60956_(0.1f).m_60971_((state, getter, pos) -> true);
        scorchedSoulGlass = BLOCKS.register("scorched_soul_glass", () -> TinkerSmeltery.lambda$static$19((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        scorchedSoulGlassPane = BLOCKS.register("scorched_soul_glass_pane", () -> TinkerSmeltery.lambda$static$20((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        seared = TinkerSmeltery.searedSolidProps(2);
        searedDrain = BLOCKS.register("seared_drain", () -> TinkerSmeltery.lambda$static$21((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        searedDuct = BLOCKS.register("seared_duct", () -> TinkerSmeltery.lambda$static$22((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        searedChute = BLOCKS.register("seared_chute", () -> TinkerSmeltery.lambda$static$23((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        scorched = TinkerSmeltery.scorchedSolidProps(3);
        scorchedDrain = BLOCKS.register("scorched_drain", () -> TinkerSmeltery.lambda$static$24((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        scorchedDuct = BLOCKS.register("scorched_duct", () -> TinkerSmeltery.lambda$static$25((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        scorchedChute = BLOCKS.register("scorched_chute", () -> TinkerSmeltery.lambda$static$26((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        seared = TinkerSmeltery.searedNonSolidProps(SoundType.f_56743_);
        searedLadder = BLOCKS.register("seared_ladder", () -> TinkerSmeltery.lambda$static$27((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        searedFaucet = BLOCKS.register("seared_faucet", () -> TinkerSmeltery.lambda$static$28((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        searedChannel = BLOCKS.register("seared_channel", () -> TinkerSmeltery.lambda$static$29((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        searedBasin = BLOCKS.register("seared_basin", () -> TinkerSmeltery.lambda$static$30((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        searedTable = BLOCKS.register("seared_table", () -> TinkerSmeltery.lambda$static$31((BlockBehaviour.Properties)seared), TOOLTIP_BLOCK_ITEM);
        scorched = TinkerSmeltery.scorchedNonSolidProps(SoundType.f_56718_);
        scorchedLadder = BLOCKS.register("scorched_ladder", () -> TinkerSmeltery.lambda$static$32((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        scorchedFaucet = BLOCKS.register("scorched_faucet", () -> TinkerSmeltery.lambda$static$33((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        scorchedChannel = BLOCKS.register("scorched_channel", () -> TinkerSmeltery.lambda$static$34((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        scorchedBasin = BLOCKS.register("scorched_basin", () -> TinkerSmeltery.lambda$static$35((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        scorchedTable = BLOCKS.register("scorched_table", () -> TinkerSmeltery.lambda$static$36((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        scorchedProxyTank = BLOCKS.register("scorched_proxy_tank", () -> TinkerSmeltery.lambda$static$37((BlockBehaviour.Properties)scorched), TOOLTIP_BLOCK_ITEM);
        seared = TinkerSmeltery.searedNonSolidProps(SoundType.f_56743_).m_60953_(SearedTankBlock.LIGHT_GETTER);
        searedTank = BLOCKS.registerEnum("seared", SearedTankBlock.TankType.values(), arg_0 -> TinkerSmeltery.lambda$static$38((BlockBehaviour.Properties)seared, arg_0), b -> new TankItem((Block)b, ITEM_PROPS, true));
        searedCastingTank = BLOCKS.register("seared_casting_tank", () -> TinkerSmeltery.lambda$static$40((BlockBehaviour.Properties)seared), b -> new TankItem((Block)b, ITEM_PROPS, true));
        searedFluidCannon = BLOCKS.register("seared_fluid_cannon", () -> TinkerSmeltery.lambda$static$42((BlockBehaviour.Properties)seared), b -> new TankItem((Block)b, ITEM_PROPS, true));
        scorched = TinkerSmeltery.scorchedNonSolidProps(SoundType.f_56718_).m_60953_(SearedTankBlock.LIGHT_GETTER);
        scorchedTank = BLOCKS.registerEnum("scorched", SearedTankBlock.TankType.values(), arg_0 -> TinkerSmeltery.lambda$static$44((BlockBehaviour.Properties)scorched, arg_0), b -> new TankItem((Block)b, ITEM_PROPS, true));
        scorchedFluidCannon = BLOCKS.register("scorched_fluid_cannon", () -> TinkerSmeltery.lambda$static$46((BlockBehaviour.Properties)scorched), b -> new TankItem((Block)b, ITEM_PROPS, true));
        searedLantern = BLOCKS.register("seared_lantern", () -> new SearedLanternBlock(TinkerSmeltery.searedNonSolidProps(SoundType.f_56762_).m_60953_(SearedTankBlock.LIGHT_GETTER), 50), b -> new TankItem((Block)b, ITEM_PROPS, false));
        scorchedLantern = BLOCKS.register("scorched_lantern", () -> new SearedLanternBlock(TinkerSmeltery.scorchedNonSolidProps(SoundType.f_56762_).m_60953_(SearedTankBlock.LIGHT_GETTER), 50), b -> new TankItem((Block)b, ITEM_PROPS, false));
        BlockBehaviour.Properties gaugeProperties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_278166_(PushReaction.DESTROY).m_60910_().m_60978_(0.5f).m_60955_().m_60999_();
        copperGauge = BLOCKS.register("copper_gauge", () -> new GaugeBlock(gaugeProperties), TOOLTIP_BLOCK_ITEM);
        obsidianGauge = BLOCKS.register("obsidian_gauge", () -> new RenderingGaugeBlock(gaugeProperties), TOOLTIP_BLOCK_ITEM);
        seared = () -> TinkerSmeltery.builder(MapColor.f_283818_, SoundType.f_56743_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(8.0f, 28.0f).m_60953_(s -> (Boolean)s.m_61143_((Property)ControllerBlock.ACTIVE) != false ? 13 : 0);
        scorched = () -> TinkerSmeltery.builder(MapColor.f_283774_, SoundType.f_56718_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(9.0f, 35.0f).m_60953_(s -> (Boolean)s.m_61143_((Property)ControllerBlock.ACTIVE) != false ? 13 : 0);
        smelteryController = BLOCKS.register("smeltery_controller", () -> TinkerSmeltery.lambda$static$58((Supplier)seared), TOOLTIP_BLOCK_ITEM);
        foundryController = BLOCKS.register("foundry_controller", () -> TinkerSmeltery.lambda$static$59((Supplier)scorched), TOOLTIP_BLOCK_ITEM);
        searedMelter = BLOCKS.register("seared_melter", () -> TinkerSmeltery.lambda$static$60((Supplier)seared), TOOLTIP_BLOCK_ITEM);
        searedHeater = BLOCKS.register("seared_heater", () -> TinkerSmeltery.lambda$static$61((Supplier)seared), TOOLTIP_BLOCK_ITEM);
        scorchedAlloyer = BLOCKS.register("scorched_alloyer", () -> TinkerSmeltery.lambda$static$62((Supplier)scorched), TOOLTIP_BLOCK_ITEM);
        smelteryComponent = BLOCK_ENTITIES.register("smeltery_component", SmelteryComponentBlockEntity::new, set -> {
            set.addAll((Iterable)searedStone.values());
            set.addAll((Iterable)searedCobble.values());
            set.addAll((Iterable)searedBricks.values());
            set.addAll((Iterable)searedPaver.values());
            set.add((Object[])new Block[]{(Block)searedCrackedBricks.get(), (Block)searedFancyBricks.get(), (Block)searedTriangleBricks.get(), (Block)searedLadder.get(), (Block)searedLamp.get(), (Block)searedGlass.get(), (Block)searedSoulGlass.get(), (Block)searedTintedGlass.get()});
            set.add((Object[])new Block[]{(Block)scorchedStone.get(), (Block)polishedScorchedStone.get(), (Block)chiseledScorchedBricks.get(), (Block)scorchedLadder.get(), (Block)scorchedLamp.get(), (Block)scorchedGlass.get(), (Block)scorchedSoulGlass.get(), (Block)scorchedTintedGlass.get()});
            set.addAll((Iterable)scorchedBricks.values());
            set.addAll((Iterable)scorchedRoad.values());
        });
        drain = BLOCK_ENTITIES.register("drain", DrainBlockEntity::new, set -> set.add((Object[])new Block[]{(Block)searedDrain.get(), (Block)scorchedDrain.get()}));
        chute = BLOCK_ENTITIES.register("chute", SmelteryInputOutputBlockEntity.ChuteBlockEntity::new, set -> set.add((Object[])new Block[]{(Block)searedChute.get(), (Block)scorchedChute.get()}));
        duct = BLOCK_ENTITIES.register("duct", DuctBlockEntity::new, set -> set.add((Object[])new Block[]{(Block)searedDuct.get(), (Block)scorchedDuct.get()}));
        tank = BLOCK_ENTITIES.register("tank", TankBlockEntity::new, set -> {
            set.addAll((Iterable)searedTank.values());
            set.addAll((Iterable)scorchedTank.values());
        });
        fluidCannon = BLOCK_ENTITIES.register("fluid_cannon", FluidCannonBlockEntity::new, set -> set.add((Object[])new Block[]{(Block)searedFluidCannon.get(), (Block)scorchedFluidCannon.get()}));
        lantern = BLOCK_ENTITIES.register("lantern", LanternBlockEntity::new, set -> set.add((Object[])new Block[]{(Block)searedLantern.get(), (Block)scorchedLantern.get()}));
        melter = BLOCK_ENTITIES.register("melter", MelterBlockEntity::new, searedMelter);
        smeltery = BLOCK_ENTITIES.register("smeltery", SmelteryBlockEntity::new, smelteryController);
        foundry = BLOCK_ENTITIES.register("foundry", FoundryBlockEntity::new, foundryController);
        heater = BLOCK_ENTITIES.register("heater", HeaterBlockEntity::new, searedHeater);
        alloyer = BLOCK_ENTITIES.register("alloyer", AlloyerBlockEntity::new, scorchedAlloyer);
        faucet = BLOCK_ENTITIES.register("faucet", FaucetBlockEntity::new, set -> set.add((Object[])new Block[]{(Block)searedFaucet.get(), (Block)scorchedFaucet.get()}));
        channel = BLOCK_ENTITIES.register("channel", ChannelBlockEntity::new, set -> set.add((Object[])new Block[]{(Block)searedChannel.get(), (Block)scorchedChannel.get()}));
        gauge = BLOCK_ENTITIES.register("gauge", GaugeBlockEntity::new, obsidianGauge);
        basin = BLOCK_ENTITIES.register("basin", CastingBlockEntity.Basin::new, set -> set.add((Object[])new Block[]{(Block)searedBasin.get(), (Block)scorchedBasin.get()}));
        table = BLOCK_ENTITIES.register("table", CastingBlockEntity.Table::new, set -> set.add((Object[])new Block[]{(Block)searedTable.get(), (Block)scorchedTable.get()}));
        proxyTank = BLOCK_ENTITIES.register("proxy_tank", ProxyTankBlockEntity::new, scorchedProxyTank);
        castingTank = BLOCK_ENTITIES.register("casting_tank", CastingTankBlockEntity::new, set -> set.add((Object)((Block)searedCastingTank.get())));
        searedBrick = ITEMS.register("seared_brick", ITEM_PROPS);
        scorchedBrick = ITEMS.register("scorched_brick", ITEM_PROPS);
        copperCan = ITEMS.register("copper_can", () -> new CopperCanItem(new Item.Properties().m_41487_(16)));
        blankSandCast = ITEMS.register("blank_sand_cast", ITEM_PROPS);
        blankRedSandCast = ITEMS.register("blank_red_sand_cast", ITEM_PROPS);
        ingotCast = ITEMS.registerCast("ingot", ITEM_PROPS);
        nuggetCast = ITEMS.registerCast("nugget", ITEM_PROPS);
        gemCast = ITEMS.registerCast("gem", ITEM_PROPS);
        rodCast = ITEMS.registerCast("rod", ITEM_PROPS);
        repairKitCast = ITEMS.registerCast(TinkerToolParts.repairKit, ITEM_PROPS);
        plateCast = ITEMS.registerCast("plate", ITEM_PROPS);
        gearCast = ITEMS.registerCast("gear", ITEM_PROPS);
        coinCast = ITEMS.registerCast("coin", ITEM_PROPS);
        wireCast = ITEMS.registerCast("wire", ITEM_PROPS);
        pickHeadCast = ITEMS.registerCast(TinkerToolParts.pickHead, ITEM_PROPS);
        smallAxeHeadCast = ITEMS.registerCast(TinkerToolParts.smallAxeHead, ITEM_PROPS);
        smallBladeCast = ITEMS.registerCast(TinkerToolParts.smallBlade, ITEM_PROPS);
        adzeHeadCast = ITEMS.registerCast(TinkerToolParts.adzeHead, ITEM_PROPS);
        hammerHeadCast = ITEMS.registerCast(TinkerToolParts.hammerHead, ITEM_PROPS);
        broadBladeCast = ITEMS.registerCast(TinkerToolParts.broadBlade, ITEM_PROPS);
        broadAxeHeadCast = ITEMS.registerCast(TinkerToolParts.broadAxeHead, ITEM_PROPS);
        largePlateCast = ITEMS.registerCast(TinkerToolParts.largePlate, ITEM_PROPS);
        toolBindingCast = ITEMS.registerCast(TinkerToolParts.toolBinding, ITEM_PROPS);
        toughBindingCast = ITEMS.registerCast(TinkerToolParts.toughBinding, ITEM_PROPS);
        toolHandleCast = ITEMS.registerCast(TinkerToolParts.toolHandle, ITEM_PROPS);
        toughHandleCast = ITEMS.registerCast(TinkerToolParts.toughHandle, ITEM_PROPS);
        bowLimbCast = ITEMS.registerCast(TinkerToolParts.bowLimb, ITEM_PROPS);
        bowGripCast = ITEMS.registerCast(TinkerToolParts.bowGrip, ITEM_PROPS);
        arrowCast = ITEMS.register("arrow_cast", TOOLTIP_ITEM);
        helmetPlatingCast = ITEMS.registerCast("helmet_plating", () -> new PartCastItem(ITEM_PROPS, () -> (IMaterialItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.HELMET)));
        chestplatePlatingCast = ITEMS.registerCast("chestplate_plating", () -> new PartCastItem(ITEM_PROPS, () -> (IMaterialItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.CHESTPLATE)));
        leggingsPlatingCast = ITEMS.registerCast("leggings_plating", () -> new PartCastItem(ITEM_PROPS, () -> (IMaterialItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.LEGGINGS)));
        bootsPlatingCast = ITEMS.registerCast("boots_plating", () -> new PartCastItem(ITEM_PROPS, () -> (IMaterialItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.BOOTS)));
        mailleCast = ITEMS.registerCast(TinkerToolParts.maille, ITEM_PROPS);
        dummyPlating = ITEMS.registerEnum((Enum[])ArmorItem.Type.values(), "plating_dummy", type -> new DummyMaterialItem(ITEM_PROPS));
        basinRecipeSerializer = RECIPE_SERIALIZERS.register("casting_basin", () -> LoadableRecipeSerializer.of(ItemCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_BASIN));
        tableRecipeSerializer = RECIPE_SERIALIZERS.register("casting_table", () -> LoadableRecipeSerializer.of(ItemCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_TABLE));
        basinFillingRecipeSerializer = RECIPE_SERIALIZERS.register("basin_filling", () -> LoadableRecipeSerializer.of(ContainerFillingRecipe.LOADER, TinkerRecipeTypes.CASTING_BASIN));
        tableFillingRecipeSerializer = RECIPE_SERIALIZERS.register("table_filling", () -> LoadableRecipeSerializer.of(ContainerFillingRecipe.LOADER, TinkerRecipeTypes.CASTING_TABLE));
        basinDuplicationRecipeSerializer = RECIPE_SERIALIZERS.register("basin_duplication", () -> LoadableRecipeSerializer.of(CastDuplicationRecipe.LOADER, TinkerRecipeTypes.CASTING_BASIN));
        tableDuplicationRecipeSerializer = RECIPE_SERIALIZERS.register("table_duplication", () -> LoadableRecipeSerializer.of(CastDuplicationRecipe.LOADER, TinkerRecipeTypes.CASTING_TABLE));
        basinPotionRecipeSerializer = RECIPE_SERIALIZERS.register("casting_basin_potion", () -> LoadableRecipeSerializer.of(PotionCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_BASIN));
        tablePotionRecipeSerializer = RECIPE_SERIALIZERS.register("casting_table_potion", () -> LoadableRecipeSerializer.of(PotionCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_TABLE));
        basinTippingRecipeSerializer = RECIPE_SERIALIZERS.register("casting_basin_tipping", () -> LoadableRecipeSerializer.of(TippingCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_BASIN));
        tableTippingRecipeSerializer = RECIPE_SERIALIZERS.register("casting_table_tipping", () -> LoadableRecipeSerializer.of(TippingCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_TABLE));
        basinTipClearingRecipeSerializer = RECIPE_SERIALIZERS.register("casting_basin_tipped_clearing", () -> LoadableRecipeSerializer.of(TipClearingCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_BASIN));
        tableTipClearingRecipeSerializer = RECIPE_SERIALIZERS.register("casting_table_tipped_clearing", () -> LoadableRecipeSerializer.of(TipClearingCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_TABLE));
        retexturedBasinRecipeSerializer = RECIPE_SERIALIZERS.register("retextured_casting_basin", () -> LoadableRecipeSerializer.of(RetexturedCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_BASIN));
        retexturedTableRecipeSerializer = RECIPE_SERIALIZERS.register("retextured_casting_table", () -> LoadableRecipeSerializer.of(RetexturedCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_TABLE));
        basinMaterialSerializer = RECIPE_SERIALIZERS.register("basin_casting_material", () -> LoadableRecipeSerializer.of(MaterialCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_BASIN));
        tableMaterialSerializer = RECIPE_SERIALIZERS.register("table_casting_material", () -> LoadableRecipeSerializer.of(MaterialCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_TABLE));
        basinCompositeSerializer = RECIPE_SERIALIZERS.register("basin_casting_composite", () -> LoadableRecipeSerializer.of(CompositeCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_BASIN));
        tableCompositeSerializer = RECIPE_SERIALIZERS.register("table_casting_composite", () -> LoadableRecipeSerializer.of(CompositeCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_TABLE));
        basinToolSerializer = RECIPE_SERIALIZERS.register("basin_tool_casting", () -> LoadableRecipeSerializer.of(ToolCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_BASIN));
        tableToolSerializer = RECIPE_SERIALIZERS.register("table_tool_casting", () -> LoadableRecipeSerializer.of(ToolCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_TABLE));
        materialFluidRecipe = RECIPE_SERIALIZERS.register("material_fluid", () -> LoadableRecipeSerializer.of(MaterialFluidRecipe.LOADER));
        basinPartSwappingSerializer = RECIPE_SERIALIZERS.register("basin_casting_part_swapping", () -> LoadableRecipeSerializer.of(PartSwapCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_BASIN));
        tablePartSwappingSerializer = RECIPE_SERIALIZERS.register("table_casting_part_swapping", () -> LoadableRecipeSerializer.of(PartSwapCastingRecipe.LOADER, TinkerRecipeTypes.CASTING_TABLE));
        moldingBasinSerializer = RECIPE_SERIALIZERS.register("molding_basin", () -> LoadableRecipeSerializer.of(MoldingRecipe.LOADER, TinkerRecipeTypes.MOLDING_BASIN));
        moldingTableSerializer = RECIPE_SERIALIZERS.register("molding_table", () -> LoadableRecipeSerializer.of(MoldingRecipe.LOADER, TinkerRecipeTypes.MOLDING_TABLE));
        meltingSerializer = RECIPE_SERIALIZERS.register("melting", () -> LoadableRecipeSerializer.of(MeltingRecipe.LOADER));
        oreMeltingSerializer = RECIPE_SERIALIZERS.register("ore_melting", () -> LoadableRecipeSerializer.of(OreMeltingRecipe.LOADER));
        damagableMeltingSerializer = RECIPE_SERIALIZERS.register("damagable_melting", () -> LoadableRecipeSerializer.of(DamageableMeltingRecipe.LOADER));
        materialMeltingSerializer = RECIPE_SERIALIZERS.register("material_melting", () -> LoadableRecipeSerializer.of(MaterialMeltingRecipe.LOADER));
        fuelSerializer = RECIPE_SERIALIZERS.register("melting_fuel", () -> LoadableRecipeSerializer.of(MeltingFuel.LOADER));
        entityMeltingSerializer = RECIPE_SERIALIZERS.register("entity_melting", () -> LoadableRecipeSerializer.of(EntityMeltingRecipe.LOADER));
        alloyingSerializer = RECIPE_SERIALIZERS.register("alloy", () -> LoadableRecipeSerializer.of(AlloyRecipe.LOADER));
        melterContainer = MENUS.register("melter", MelterContainerMenu::new);
        smelteryContainer = MENUS.register("smeltery", HeatingStructureContainerMenu::new);
        singleItemContainer = MENUS.register("single_item", SingleItemContainerMenu::new);
        alloyerContainer = MENUS.register("alloyer", AlloyerContainerMenu::new);
    }
}

