/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.stats;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.listener.MergingJsonDataLoader;
import slimeknights.mantle.data.registry.IdAwareComponentRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.typed.TypedMapBuilder;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.json.MaterialStatJson;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.stats.UpdateMaterialStatsPacket;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialStatsManager
extends MergingJsonDataLoader<Map<ResourceLocation, JsonObject>> {
    private static final Logger log = LogManager.getLogger(MaterialStatsManager.class);
    public static final String FOLDER = "tinkering/materials/stats";
    private final Runnable onLoaded;
    private final IdAwareComponentRegistry<MaterialStatType<?>> statTypes = new IdAwareComponentRegistry("Unknown Material Stat Type");
    private Map<MaterialId, Map<MaterialStatsId, IMaterialStats>> materialToStatsPerType = Collections.emptyMap();

    public MaterialStatsManager(Runnable onLoaded) {
        super(JsonHelper.DEFAULT_GSON, FOLDER, id -> new HashMap());
        this.onLoaded = onLoaded;
    }

    public <T extends IMaterialStats> void registerStatType(MaterialStatType<T> type) {
        this.statTypes.register(type);
    }

    public Collection<ResourceLocation> getAllStatTypeIds() {
        return this.statTypes.getKeys();
    }

    @Nullable
    public <T extends IMaterialStats> MaterialStatType<T> getStatType(MaterialStatsId id) {
        return (MaterialStatType)this.statTypes.getValue((ResourceLocation)id);
    }

    public <T extends IMaterialStats> Optional<T> getStats(MaterialId materialId, MaterialStatsId statId) {
        Map materialStats = this.materialToStatsPerType.getOrDefault(materialId, Map.of());
        IMaterialStats stats = (IMaterialStats)materialStats.get((Object)statId);
        return Optional.ofNullable(stats);
    }

    public Collection<IMaterialStats> getAllStats(MaterialId materialId) {
        return this.materialToStatsPerType.getOrDefault(materialId, Map.of()).values();
    }

    public void updateMaterialStatsFromServer(Map<MaterialId, Collection<IMaterialStats>> materialStats) {
        this.materialToStatsPerType = materialStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Collection)entry.getValue()).stream().collect(Collectors.toMap(IMaterialStats::getIdentifier, Function.identity()))));
        this.onLoaded.run();
    }

    protected void parse(Map<ResourceLocation, JsonObject> builder, ResourceLocation id, JsonElement element) throws JsonSyntaxException {
        MaterialStatJson json = (MaterialStatJson)JsonHelper.DEFAULT_GSON.fromJson(element, MaterialStatJson.class);
        for (Map.Entry<ResourceLocation, JsonElement> entry : json.getStats().entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement valueElement = entry.getValue();
            if (valueElement.isJsonNull()) {
                builder.remove(key);
                continue;
            }
            JsonObject value = GsonHelper.m_13918_((JsonElement)valueElement, (String)key.toString());
            JsonObject existing = builder.get(key);
            if (existing != null) {
                for (Map.Entry jsonEntry : value.entrySet()) {
                    existing.add((String)jsonEntry.getKey(), (JsonElement)jsonEntry.getValue());
                }
                continue;
            }
            builder.put(key, value);
        }
    }

    protected void finishLoad(Map<ResourceLocation, Map<ResourceLocation, JsonObject>> map, ResourceManager manager) {
        this.materialToStatsPerType = map.entrySet().stream().collect(Collectors.toMap(entry -> new MaterialId((ResourceLocation)entry.getKey()), entry -> this.deserializeMaterialStatsFromContent((Map)entry.getValue())));
        log.debug("Loaded stats for materials:{}", (Object)Util.toIndentedStringList(this.materialToStatsPerType.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> String.format("%s - [%s]", entry.getKey(), ((Map)entry.getValue()).keySet().stream().sorted().map(Object::toString).collect(Collectors.joining(", ")))).collect(Collectors.toList())));
        this.onLoaded.run();
    }

    public void m_6213_(ResourceManager manager) {
        long time = System.nanoTime();
        super.m_6213_(manager);
        log.info("{} stats loaded for {} materials in {} ms", (Object)this.materialToStatsPerType.values().stream().mapToInt(Map::size).sum(), (Object)this.materialToStatsPerType.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    public UpdateMaterialStatsPacket getUpdatePacket() {
        Map<MaterialId, Collection<IMaterialStats>> networkPayload = this.materialToStatsPerType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).values()));
        return new UpdateMaterialStatsPacket(networkPayload);
    }

    private Map<MaterialStatsId, IMaterialStats> deserializeMaterialStatsFromContent(Map<ResourceLocation, JsonObject> contentsMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonObject> entry : contentsMap.entrySet()) {
            MaterialStatsId statType = new MaterialStatsId(entry.getKey());
            MaterialStatType type = this.getStatType(statType);
            if (type == null) {
                log.error("The material stat of type '" + statType + "' has not been registered");
                continue;
            }
            builder.put((Object)statType, (Object)((IMaterialStats)type.getLoadable().deserialize(entry.getValue(), TypedMapBuilder.builder().put(MaterialStatType.CONTEXT_KEY, type).build())));
        }
        return builder.build();
    }

    public IdAwareComponentRegistry<MaterialStatType<?>> getStatTypes() {
        return this.statTypes;
    }
}

