/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.tconstruct.library.json.field.MergingField;
import slimeknights.tconstruct.library.json.field.MergingListField;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class DamageableMeltingRecipe
extends MeltingRecipe {
    public static final RecordLoadable<DamageableMeltingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)INPUT, (RecordField)OUTPUT, (RecordField)TEMPERATURE, (RecordField)TIME, (RecordField)BYPRODUCTS, new MergingField(IntLoadable.FROM_ONE.defaultField("unit_size", (Object)1, r -> r.unitSize), "result", MergingField.MissingMode.IGNORE), new MergingListField(IntLoadable.FROM_ONE.defaultField("unit_size", (Object)1, Function.identity()), "byproducts", r -> r.byproductSizes), DamageableMeltingRecipe::new);
    private final int unitSize;
    private final List<Integer> byproductSizes;

    public DamageableMeltingRecipe(ResourceLocation id, String group, Ingredient input, FluidOutput output, int temperature, int time, List<FluidOutput> byproducts, int unitSize, List<Integer> byproductSizes) {
        super(id, group, input, output, temperature, time, byproducts);
        this.unitSize = unitSize;
        this.byproductSizes = byproductSizes;
    }

    private static FluidStack scaleOutput(FluidStack fluid, int damage, int maxDamage, int unitSize) {
        int remainder;
        int amount = fluid.getAmount() * (maxDamage - damage) / maxDamage;
        if (amount <= unitSize) {
            amount = Math.max(unitSize, 1);
        } else if (unitSize > 1 && (remainder = amount % unitSize) > 0) {
            amount -= remainder;
        }
        return new FluidStack(fluid, amount);
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        FluidStack output = this.getOutput();
        ItemStack input = inv.getStack();
        int maxDamage = input.m_41776_();
        if (maxDamage <= 0) {
            return output.copy();
        }
        return DamageableMeltingRecipe.scaleOutput(output, input.m_41773_(), maxDamage, this.unitSize);
    }

    @Override
    public void handleByproducts(IMeltingContainer inv, IFluidHandler handler) {
        ItemStack input = inv.getStack();
        int maxDamage = input.m_41776_();
        if (maxDamage <= 0) {
            super.handleByproducts(inv, handler);
        } else {
            int itemDamage = input.m_41773_();
            for (int i = 0; i < this.byproducts.size(); ++i) {
                FluidOutput fluidStack = (FluidOutput)this.byproducts.get(i);
                handler.fill(DamageableMeltingRecipe.scaleOutput(fluidStack.get(), itemDamage, maxDamage, i < this.byproductSizes.size() ? this.byproductSizes.get(i) : this.unitSize), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.damagableMeltingSerializer.get();
    }
}

