/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public class BlockSideHitListener {
    private static final Map<UUID, Direction> HIT_FACE = new HashMap<UUID, Direction>();
    private static final Object2IntMap<UUID> LAST_XP = new Object2IntOpenHashMap();
    private static Direction clientSideHit = Direction.UP;
    private static boolean init = false;

    public static void init() {
        if (init) {
            return;
        }
        init = true;
        MinecraftForge.EVENT_BUS.addListener(BlockSideHitListener::onLeftClickBlock);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, BlockSideHitListener::breakBlock);
        MinecraftForge.EVENT_BUS.addListener(BlockSideHitListener::onLeaveServer);
    }

    private static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.START) {
            Player player = event.getEntity();
            if (player.m_9236_().m_5776_()) {
                clientSideHit = event.getFace();
            } else {
                HIT_FACE.put(player.m_20148_(), event.getFace());
            }
        }
    }

    private static void breakBlock(BlockEvent.BreakEvent event) {
        LAST_XP.put((Object)event.getPlayer().m_20148_(), event.getExpToDrop());
    }

    private static void onLeaveServer(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID uuid = event.getEntity().m_20148_();
        HIT_FACE.remove(uuid);
        LAST_XP.remove((Object)uuid);
    }

    public static Direction getSideHit(Player player) {
        if (player.m_9236_().m_5776_()) {
            return clientSideHit;
        }
        return HIT_FACE.getOrDefault(player.m_20148_(), Direction.UP);
    }

    public static int getLastXP(Player player) {
        return LAST_XP.getOrDefault((Object)player.m_20148_(), 0);
    }

    public static Direction getClientSideHit() {
        return clientSideHit;
    }
}

