/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.modules.capacity.OverslimeModule;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class OverslimeCraftingTableRecipe
extends CustomRecipe {
    public static final RecordLoadable<OverslimeCraftingTableRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.defaultField("tools", (Object)Ingredient.m_204132_(TinkerTags.Items.DURABILITY), r -> r.tools), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("ingredient", r -> r.ingredient), (RecordField)IntLoadable.FROM_ONE.requiredField("restore_amount", r -> r.restoreAmount), OverslimeCraftingTableRecipe::new);
    private final Ingredient tools;
    private final Ingredient ingredient;
    private final int restoreAmount;

    public OverslimeCraftingTableRecipe(ResourceLocation id, Ingredient tools, Ingredient ingredient, int restoreAmount) {
        super(id, CraftingBookCategory.EQUIPMENT);
        this.tools = tools;
        this.ingredient = ingredient;
        this.restoreAmount = restoreAmount;
    }

    @Nullable
    public static ToolFound findTool(CraftingContainer inv, Predicate<ItemStack> tools, Ingredient ingredient) {
        ItemStack foundTool = null;
        int itemsFound = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (tools.test(stack)) {
                if (foundTool != null) {
                    return null;
                }
                foundTool = stack;
                continue;
            }
            if (ingredient.test(stack)) {
                ++itemsFound;
                continue;
            }
            return null;
        }
        if (itemsFound == 0 || foundTool == null) {
            return null;
        }
        return new ToolFound(foundTool, itemsFound);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        ToolFound match = OverslimeCraftingTableRecipe.findTool(inv, (Predicate<ItemStack>)this.tools, this.ingredient);
        if (match == null) {
            return false;
        }
        ToolStack tool = ToolStack.from(match.tool);
        return tool.getModifierLevel(TinkerModifiers.overslime.getId()) > 0 || OverslimeModule.INSTANCE.getAmount(tool) < OverslimeModule.getCapacity(tool);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ToolFound match = OverslimeCraftingTableRecipe.findTool(inv, (Predicate<ItemStack>)this.tools, this.ingredient);
        if (match == null) {
            TConstruct.LOG.error("Overslime crafting table recipe {} failed to find tool after matching", (Object)this.m_6423_());
            return ItemStack.f_41583_;
        }
        ToolStack tool = ToolStack.copyFrom(match.tool);
        OverslimeModule.INSTANCE.addAmount(tool, match.itemsFound * this.restoreAmount);
        return tool.copyStack(match.tool);
    }

    public static NonNullList<ItemStack> getRemainingItems(CraftingContainer inv, Ingredient ingredient, int repairNeeded, int repairPerItem) {
        NonNullList list = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (ingredient.test(stack)) {
                if (repairNeeded <= 0) {
                    list.set(i, (Object)stack.m_255036_(1));
                    continue;
                }
                repairNeeded -= repairPerItem;
            }
            if (!stack.hasCraftingRemainingItem()) continue;
            list.set(i, (Object)stack.getCraftingRemainingItem());
        }
        return list;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        ToolFound inputs = OverslimeCraftingTableRecipe.findTool(inv, (Predicate<ItemStack>)this.tools, this.ingredient);
        int repairNeeded = 0;
        int repairPerItem = this.restoreAmount;
        if (inputs != null) {
            ToolStack tool = ToolStack.from(inputs.tool);
            repairNeeded = OverslimeModule.getCapacity(tool) - OverslimeModule.INSTANCE.getAmount(tool);
            repairPerItem *= OverslimeModule.getOverworkedBonus(tool);
        }
        return OverslimeCraftingTableRecipe.getRemainingItems(inv, this.ingredient, repairNeeded, repairPerItem);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.craftingOverslimeSerializer.get();
    }

    public record ToolFound(ItemStack tool, int itemsFound) {
    }
}

