/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.display;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public interface DurabilityDisplayModifierHook {
    @Nullable
    public Boolean showDurabilityBar(IToolStackView var1, ModifierEntry var2);

    public int getDurabilityWidth(IToolStackView var1, ModifierEntry var2);

    public int getDurabilityRGB(IToolStackView var1, ModifierEntry var2);

    public static boolean showDurabilityBar(ItemStack stack) {
        if (!stack.m_41720_().m_41465_() || !stack.m_204117_(TinkerTags.Items.DURABILITY)) {
            return false;
        }
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            Boolean show = entry.getHook(ModifierHooks.DURABILITY_DISPLAY).showDurabilityBar(tool, entry);
            if (show == null) continue;
            return show;
        }
        return tool.getItem().m_41465_() && tool.getDamage() > 0;
    }

    public static int getWidthFor(int amount, int max) {
        if (amount <= 0) {
            return 0;
        }
        if (amount >= max) {
            return 13;
        }
        return 1 + 13 * (amount - 1) / max;
    }

    public static int getDurabilityWidth(ItemStack stack) {
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return 0;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            int width = entry.getHook(ModifierHooks.DURABILITY_DISPLAY).getDurabilityWidth(tool, entry);
            if (width <= 0) continue;
            return width;
        }
        int max = tool.getStats().getInt(ToolStats.DURABILITY);
        return DurabilityDisplayModifierHook.getWidthFor(max - tool.getDamage(), max);
    }

    public static int getDurabilityRGB(ItemStack stack) {
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return 0;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            int rgb = entry.getHook(ModifierHooks.DURABILITY_DISPLAY).getDurabilityRGB(tool, entry);
            if (rgb == -1) continue;
            return rgb;
        }
        float max = tool.getStats().getInt(ToolStats.DURABILITY);
        return Mth.m_14169_((float)Math.max(0.0f, (max - (float)tool.getDamage()) / max / 3.0f), (float)1.0f, (float)1.0f);
    }

    public record FirstMerger(Collection<DurabilityDisplayModifierHook> modules) implements DurabilityDisplayModifierHook
    {
        @Override
        @Nullable
        public Boolean showDurabilityBar(IToolStackView tool, ModifierEntry modifier) {
            for (DurabilityDisplayModifierHook module : this.modules) {
                Boolean result = module.showDurabilityBar(tool, modifier);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public int getDurabilityWidth(IToolStackView tool, ModifierEntry modifier) {
            for (DurabilityDisplayModifierHook module : this.modules) {
                int damage = module.getDurabilityWidth(tool, modifier);
                if (damage <= 0) continue;
                return damage;
            }
            return -1;
        }

        @Override
        public int getDurabilityRGB(IToolStackView tool, ModifierEntry modifier) {
            for (DurabilityDisplayModifierHook module : this.modules) {
                int color = module.getDurabilityRGB(tool, modifier);
                if (color == -1) continue;
                return color;
            }
            return -1;
        }
    }
}

