/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.general;

import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.util.Lazy;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.modules.armor.CounterModule;

public class TastyModifier
extends Modifier
implements GeneralInteractionModifierHook,
OnAttackedModifierHook,
ProcessLootModifierHook {
    private static final Lazy<ItemStack> BACON_STACK = Lazy.of(() -> new ItemStack(TinkerCommons.bacon));

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, ModifierHooks.GENERAL_INTERACT, ModifierHooks.ON_ATTACKED, ModifierHooks.PROCESS_LOOT);
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (source == InteractionSource.RIGHT_CLICK && !tool.isBroken() && player.m_36391_(false)) {
            GeneralInteractionModifierHook.startUsing(tool, modifier.getId(), (LivingEntity)player, hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private void eat(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
        Player player;
        int level = modifier.intEffectiveLevel();
        if (level > 0 && entity instanceof Player && (player = (Player)entity).m_36391_(false)) {
            Level world = entity.m_9236_();
            player.m_36324_().m_38707_(level, 0.4f);
            ModifierUtil.foodConsumer.onConsume(player, (ItemStack)BACON_STACK.get(), level, 0.6f);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.4f);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12321_, SoundSource.NEUTRAL, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
            if (ToolDamageUtil.directDamage(tool, 15 * level, (LivingEntity)player, player.m_21211_())) {
                player.m_21190_(player.m_7655_());
            }
        }
    }

    @Override
    public void onFinishUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
        if (!tool.isBroken()) {
            this.eat(tool, modifier, entity);
        }
    }

    @Override
    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return UseAnim.EAT;
    }

    @Override
    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 16;
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        if (tool.hasTag(TinkerTags.Items.ARMOR)) {
            float level = CounterModule.getLevel(tool, modifier, slotType, context.getEntity());
            if (RANDOM.nextFloat() < level * 0.15f) {
                this.eat(tool, modifier, context.getEntity());
            }
        }
    }

    @Override
    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        if (!context.m_78936_(LootContextParams.f_81457_)) {
            return;
        }
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (entity != null && entity.m_6095_().m_204039_(TinkerTags.EntityTypes.BACON_PRODUCER)) {
            int looting = context.getLootingModifier();
            if (RANDOM.nextInt(48 / modifier.intEffectiveLevel()) <= looting) {
                generatedLoot.add(new ItemStack(TinkerCommons.bacon));
            }
        }
    }
}

