/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.Input;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.listener.ISafeManagerReloadListener;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.ClientEventBase;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.client.armor.AbstractArmorModel;
import slimeknights.tconstruct.library.client.armor.ArmorModelManager;
import slimeknights.tconstruct.library.client.armor.texture.TrimArmorTextureSupplier;
import slimeknights.tconstruct.library.client.book.content.AbstractMaterialContent;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.client.model.DynamicTextureLoader;
import slimeknights.tconstruct.library.client.model.TinkerItemProperties;
import slimeknights.tconstruct.library.client.model.tools.MaterialBlockModel;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.model.tools.ToolModel;
import slimeknights.tconstruct.library.client.modifiers.DyedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.FluidModifierModel;
import slimeknights.tconstruct.library.client.modifiers.MaterialModifierModel;
import slimeknights.tconstruct.library.client.modifiers.ModifierModelManager;
import slimeknights.tconstruct.library.client.modifiers.NormalModifierModel;
import slimeknights.tconstruct.library.client.modifiers.PotionModifierModel;
import slimeknights.tconstruct.library.client.modifiers.TankModifierModel;
import slimeknights.tconstruct.library.client.modifiers.TrimModifierModel;
import slimeknights.tconstruct.library.client.particle.AttackParticle;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorStatModule;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.HarvestTiers;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.TinkerAttributes;
import slimeknights.tconstruct.shared.TinkerEffects;
import slimeknights.tconstruct.shared.effect.AntigravityEffect;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.client.CrystalshotRenderer;
import slimeknights.tconstruct.tools.client.FluidEffectProjectileRenderer;
import slimeknights.tconstruct.tools.client.OverslimeModifierModel;
import slimeknights.tconstruct.tools.client.SlimeskullArmorModel;
import slimeknights.tconstruct.tools.client.ToolContainerScreen;
import slimeknights.tconstruct.tools.client.material.CombatFishingHookRenderer;
import slimeknights.tconstruct.tools.client.material.ThrownShurikenRenderer;
import slimeknights.tconstruct.tools.client.material.ThrownToolRenderer;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;
import slimeknights.tconstruct.tools.logic.DoubleJumpHandler;
import slimeknights.tconstruct.tools.logic.InteractionHandler;
import slimeknights.tconstruct.tools.modules.ranged.ammo.SmashingModule;
import slimeknights.tconstruct.tools.network.TinkerControlPacket;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ToolClientEvents
extends ClientEventBase {
    private static final KeyMapping HELMET_INTERACT = new KeyMapping(TConstruct.makeTranslationKey("key", "helmet_interact"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.m_84851_((String)"key.keyboard.z"), "key.categories.tconstruct");
    private static final KeyMapping LEGGINGS_INTERACT = new KeyMapping(TConstruct.makeTranslationKey("key", "leggings_interact"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.m_84851_((String)"key.keyboard.i"), "key.categories.tconstruct");
    private static final ISafeManagerReloadListener MODIFIER_RELOAD_LISTENER = manager -> ModifierManager.INSTANCE.getAllValues().forEach(modifier -> modifier.clearCache(PackType.CLIENT_RESOURCES));
    private static boolean wasJumping = false;
    private static boolean wasHelmetInteracting = false;
    private static boolean wasLeggingsInteracting = false;

    @SubscribeEvent
    static void addResourceListener(RegisterClientReloadListenersEvent manager) {
        ModifierModelManager.init(manager);
        MaterialTooltipCache.init(manager);
        DynamicTextureLoader.init(manager);
        manager.registerReloadListener((PreparableReloadListener)MODIFIER_RELOAD_LISTENER);
        manager.registerReloadListener((PreparableReloadListener)SlimeskullArmorModel.RELOAD_LISTENER);
        manager.registerReloadListener((PreparableReloadListener)HarvestTiers.RELOAD_LISTENER);
        ArmorModelManager.init(manager);
        manager.registerReloadListener((PreparableReloadListener)TrimArmorTextureSupplier.CACHE_INVALIDATOR);
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("material", MaterialModel.LOADER);
        event.register("tool", ToolModel.LOADER);
        event.register("material_block", MaterialBlockModel.LOADER);
    }

    @SubscribeEvent
    static void registerModifierModels(ModifierModelManager.ModifierModelRegistrationEvent event) {
        event.registerModel(TConstruct.getResource("normal"), NormalModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("overslime"), OverslimeModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("fluid"), FluidModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("tank"), TankModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("material"), MaterialModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("dyed"), DyedModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("trim"), TrimModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("potion"), PotionModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("smashing_fluid"), new FluidModifierModel.Unbaked(SmashingModule.TANK_HELPER));
    }

    @SubscribeEvent
    static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)TinkerTools.indestructibleItem.get(), ItemEntityRenderer::new);
        event.registerEntityRenderer((EntityType)TinkerTools.crystalshotEntity.get(), CrystalshotRenderer::new);
        event.registerEntityRenderer((EntityType)TinkerTools.fishingHook.get(), CombatFishingHookRenderer::new);
        event.registerEntityRenderer((EntityType)TinkerTools.materialArrow.get(), ThrownToolRenderer::new);
        event.registerEntityRenderer((EntityType)TinkerTools.thrownShuriken.get(), ThrownShurikenRenderer::new);
        event.registerEntityRenderer((EntityType)TinkerTools.thrownTool.get(), ThrownToolRenderer::new);
        event.registerEntityRenderer((EntityType)TinkerModifiers.fluidSpitEntity.get(), FluidEffectProjectileRenderer::new);
    }

    @SubscribeEvent
    static void registerKeyBinding(RegisterKeyMappingsEvent event) {
        event.register(HELMET_INTERACT);
        event.register(LEGGINGS_INTERACT);
    }

    @SubscribeEvent
    static void clientSetupEvent(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(ToolClientEvents::handleKeyBindings);
        MinecraftForge.EVENT_BUS.addListener(ToolClientEvents::handleInput);
        AbstractArmorModel.init();
        event.enqueueWork(() -> {
            AbstractMaterialContent.registerFallbackPart(TinkerToolParts.fakeIngot);
            AbstractMaterialContent.registerFallbackPart(TinkerToolParts.fakeStorageBlockItem);
            MenuScreens.m_96206_((MenuType)((MenuType)TinkerTools.toolContainer.get()), ToolContainerScreen::new);
            TinkerItemProperties.registerToolProperties(TinkerTools.pickaxe);
            TinkerItemProperties.registerToolProperties(TinkerTools.sledgeHammer);
            TinkerItemProperties.registerToolProperties(TinkerTools.veinHammer);
            TinkerItemProperties.registerToolProperties(TinkerTools.mattock);
            TinkerItemProperties.registerToolProperties(TinkerTools.pickadze);
            TinkerItemProperties.registerToolProperties(TinkerTools.excavator);
            TinkerItemProperties.registerToolProperties(TinkerTools.handAxe);
            TinkerItemProperties.registerToolProperties(TinkerTools.broadAxe);
            TinkerItemProperties.registerToolProperties(TinkerTools.kama);
            TinkerItemProperties.registerToolProperties(TinkerTools.scythe);
            TinkerItemProperties.registerToolProperties(TinkerTools.dagger);
            TinkerItemProperties.registerToolProperties(TinkerTools.sword);
            TinkerItemProperties.registerToolProperties(TinkerTools.cleaver);
            TinkerItemProperties.registerCrossbowProperties(TinkerTools.crossbow);
            TinkerItemProperties.registerToolProperties(TinkerTools.longbow);
            TinkerItemProperties.registerToolProperties(TinkerTools.fishingRod);
            TinkerItemProperties.registerToolProperties(TinkerTools.javelin);
            TinkerItemProperties.registerToolProperties(TinkerTools.flintAndBrick);
            TinkerItemProperties.registerToolProperties(TinkerTools.skyStaff);
            TinkerItemProperties.registerToolProperties(TinkerTools.earthStaff);
            TinkerItemProperties.registerToolProperties(TinkerTools.ichorStaff);
            TinkerItemProperties.registerToolProperties(TinkerTools.enderStaff);
            TinkerItemProperties.registerToolProperties(TinkerTools.meltingPan);
            TinkerItemProperties.registerCrossbowProperties(TinkerTools.warPick);
            TinkerItemProperties.registerToolProperties(TinkerTools.battlesign);
            TinkerItemProperties.registerToolProperties(TinkerTools.swasher);
            if (ModList.get().isLoaded("twilightforest")) {
                TinkerItemProperties.registerToolProperties(TinkerTools.minotaurAxe);
            }
            TinkerItemProperties.registerToolProperties(TinkerTools.travelersShield);
            TinkerItemProperties.registerToolProperties(TinkerTools.plateShield);
            Consumer<Item> brokenConsumer = TinkerItemProperties::registerBrokenProperty;
            TinkerTools.travelersGear.forEach(brokenConsumer);
            TinkerTools.plateArmor.forEach(brokenConsumer);
            TinkerTools.slimesuit.forEach(brokenConsumer);
        });
    }

    @SubscribeEvent
    static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        ParticleEngine.SpriteParticleRegistration factory = AttackParticle.Factory::new;
        event.registerSpriteSet((ParticleType)TinkerTools.hammerAttackParticle.get(), factory);
        event.registerSpriteSet((ParticleType)TinkerTools.axeAttackParticle.get(), factory);
        event.registerSpriteSet((ParticleType)TinkerTools.bonkAttackParticle.get(), factory);
    }

    @SubscribeEvent
    static void itemColors(RegisterColorHandlersEvent.Item event) {
        ItemColors colors = event.getItemColors();
        ToolModel.registerItemColors(colors, TinkerTools.pickaxe);
        ToolModel.registerItemColors(colors, TinkerTools.sledgeHammer);
        ToolModel.registerItemColors(colors, TinkerTools.veinHammer);
        ToolModel.registerItemColors(colors, TinkerTools.mattock);
        ToolModel.registerItemColors(colors, TinkerTools.pickadze);
        ToolModel.registerItemColors(colors, TinkerTools.excavator);
        ToolModel.registerItemColors(colors, TinkerTools.handAxe);
        ToolModel.registerItemColors(colors, TinkerTools.broadAxe);
        ToolModel.registerItemColors(colors, TinkerTools.kama);
        ToolModel.registerItemColors(colors, TinkerTools.scythe);
        ToolModel.registerItemColors(colors, TinkerTools.dagger);
        ToolModel.registerItemColors(colors, TinkerTools.sword);
        ToolModel.registerItemColors(colors, TinkerTools.cleaver);
        ToolModel.registerItemColors(colors, TinkerTools.crossbow);
        ToolModel.registerItemColors(colors, TinkerTools.longbow);
        ToolModel.registerItemColors(colors, TinkerTools.fishingRod);
        ToolModel.registerItemColors(colors, TinkerTools.javelin);
        ToolModel.registerItemColors(colors, TinkerTools.arrow);
        ToolModel.registerItemColors(colors, TinkerTools.shuriken);
        ToolModel.registerItemColors(colors, TinkerTools.throwingAxe);
        ToolModel.registerItemColors(colors, TinkerTools.meltingPan);
        ToolModel.registerItemColors(colors, TinkerTools.warPick);
        ToolModel.registerItemColors(colors, TinkerTools.battlesign);
        ToolModel.registerItemColors(colors, TinkerTools.swasher);
        if (ModList.get().isLoaded("twilightforest")) {
            ToolModel.registerItemColors(colors, TinkerTools.minotaurAxe);
        }
        ToolModel.registerItemColors(colors, TinkerTools.travelersShield);
        ToolModel.registerItemColors(colors, TinkerTools.plateShield);
        Consumer<Item> brokenConsumer = item -> event.register(ToolModel.COLOR_HANDLER, new ItemLike[]{item});
        TinkerTools.travelersGear.forEach(brokenConsumer);
        TinkerTools.plateArmor.forEach(brokenConsumer);
        TinkerTools.slimesuit.forEach(brokenConsumer);
        event.register((stack, index) -> {
            ModifierId modifier = ModifierCrystalItem.getModifier(stack);
            if (modifier != null) {
                return ResourceColorManager.getColor((String)Util.makeTranslationKey("modifier", modifier));
            }
            return -1;
        }, new ItemLike[]{TinkerModifiers.modifierCrystal});
    }

    private static void handleKeyBindings(TickEvent.PlayerTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && minecraft.f_91074_ == event.player && event.phase == TickEvent.Phase.START && event.side == LogicalSide.CLIENT && !minecraft.f_91074_.m_5833_()) {
            TooltipKey key;
            TooltipKey key2;
            boolean isJumping = minecraft.f_91066_.f_92089_.m_90857_();
            if (!wasJumping && isJumping) {
                if (((AntigravityEffect)((Object)TinkerEffects.antigravity.get())).antigravityJump(event.player)) {
                    TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.ANTIGRAVITY_JUMP);
                } else if (DoubleJumpHandler.extraJump(event.player)) {
                    TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.DOUBLE_JUMP);
                }
            }
            wasJumping = isJumping;
            boolean isHelmetInteracting = HELMET_INTERACT.m_90857_();
            if (!wasHelmetInteracting && isHelmetInteracting && InteractionHandler.startArmorInteract(event.player, EquipmentSlot.HEAD, key2 = SafeClientAccess.getTooltipKey())) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.getStartHelmetInteract(key2));
            }
            if (wasHelmetInteracting && !isHelmetInteracting && InteractionHandler.stopArmorInteract(event.player, EquipmentSlot.HEAD)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.STOP_HELMET_INTERACT);
            }
            boolean isLeggingsInteract = LEGGINGS_INTERACT.m_90857_();
            if (!wasLeggingsInteracting && isLeggingsInteract && InteractionHandler.startArmorInteract(event.player, EquipmentSlot.LEGS, key = SafeClientAccess.getTooltipKey())) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.getStartLeggingsInteract(key));
            }
            if (wasLeggingsInteracting && !isLeggingsInteract && InteractionHandler.stopArmorInteract(event.player, EquipmentSlot.LEGS)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.STOP_LEGGINGS_INTERACT);
            }
            wasHelmetInteracting = isHelmetInteracting;
            wasLeggingsInteracting = isLeggingsInteract;
        }
    }

    private static void handleInput(MovementInputUpdateEvent event) {
        Player player = event.getEntity();
        if (player.m_6117_() && !player.m_20159_()) {
            ItemStack using = player.m_21211_();
            double speed = player.m_21133_((Attribute)TinkerAttributes.USE_ITEM_SPEED.get());
            if (using.m_204117_(TinkerTags.Items.HELD)) {
                ToolStack tool = ToolStack.from(using);
                speed += (double)(tool.getStats().get(ToolStats.USE_ITEM_SPEED).floatValue() - ToolStats.USE_ITEM_SPEED.getDefaultValue().floatValue());
            }
            speed = Mth.m_14008_((double)(speed + (double)ArmorStatModule.getStat((Entity)player, TinkerDataKeys.USE_ITEM_SPEED)), (double)0.0, (double)1.0);
            Input input = event.getInput();
            input.f_108566_ *= (float)(speed * 5.0);
            input.f_108567_ *= (float)(speed * 5.0);
        }
    }
}

