/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.build;

import com.google.common.collect.ImmutableList;
import java.util.List;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolTraitHook;
import slimeknights.tconstruct.library.tools.helper.ModifierBuilder;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;

public record ToolTraitsModule(List<ModifierEntry> traits) implements ToolTraitHook,
ToolModule
{
    public static final RecordLoadable<ToolTraitsModule> LOADER = RecordLoadable.create((RecordField)ModifierEntry.OPTIONAL_LOADABLE.list(1).requiredField("traits", ToolTraitsModule::traits), ToolTraitsModule::new);
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.TOOL_TRAITS);

    public static Builder builder() {
        return new Builder();
    }

    public RecordLoadable<ToolTraitsModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void addTraits(ToolDefinition definition, MaterialNBT materials, ModifierBuilder builder) {
        builder.add(this.traits);
    }

    public static class Builder {
        private final ImmutableList.Builder<ModifierEntry> traits = ImmutableList.builder();

        private Builder() {
        }

        public Builder trait(ModifierId modifier, int level) {
            this.traits.add((Object)new ModifierEntry(modifier, level));
            return this;
        }

        public Builder trait(LazyModifier modifier, int level) {
            return this.trait(modifier.getId(), level);
        }

        public Builder trait(ModifierId modifier) {
            return this.trait(modifier, 1);
        }

        public Builder trait(LazyModifier modifier) {
            return this.trait(modifier, 1);
        }

        public Builder copy() {
            Builder copy = new Builder();
            copy.traits.addAll((Iterable)this.traits.build());
            return copy;
        }

        public ToolTraitsModule build() {
            ImmutableList traits = this.traits.build();
            if (traits.isEmpty()) {
                throw new IllegalStateException("Must have at least 1 trait");
            }
            return new ToolTraitsModule((List<ModifierEntry>)traits);
        }
    }
}

