/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.ingredient;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.item.IModifiable;

public class ToolHookIngredient
extends AbstractIngredient {
    private final TagKey<Item> tag;
    private final ModuleHook<?> hook;

    protected ToolHookIngredient(TagKey<Item> tag, ModuleHook<?> hook) {
        super(Stream.of(new ToolHookValue(tag, hook)));
        this.tag = tag;
        this.hook = hook;
    }

    public static ToolHookIngredient of(TagKey<Item> tag, ModuleHook<?> hook) {
        return new ToolHookIngredient(tag, hook);
    }

    public static ToolHookIngredient of(ModuleHook<?> hook) {
        return ToolHookIngredient.of(TinkerTags.Items.MODIFIABLE, hook);
    }

    public boolean test(@Nullable ItemStack stack) {
        IModifiable modifiable;
        Item item;
        return stack != null && stack.m_204117_(this.tag) && (item = stack.m_41720_()) instanceof IModifiable && (modifiable = (IModifiable)item).getToolDefinition().getData().getHooks().hasHook(this.hook);
    }

    public boolean isSimple() {
        return true;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.ID.toString());
        json.addProperty("tag", this.tag.f_203868_().toString());
        json.addProperty("hook", this.hook.getId().toString());
        return json;
    }

    public static class ToolHookValue
    implements Ingredient.Value {
        private final TagKey<Item> tag;
        private final ModuleHook<?> hook;

        public Collection<ItemStack> m_6223_() {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(this.tag)) {
                IModifiable modifiable;
                Object object = holder.m_203334_();
                if (!(object instanceof IModifiable) || !(modifiable = (IModifiable)object).getToolDefinition().getData().getHooks().hasHook(this.hook)) continue;
                list.add(new ItemStack((ItemLike)modifiable));
            }
            if (list.size() == 0) {
                list.add(new ItemStack((ItemLike)Blocks.f_50375_).m_41714_((Component)Component.m_237113_((String)("Empty Tag: " + this.tag.f_203868_()))));
            }
            return list;
        }

        public JsonObject m_6544_() {
            JsonObject json = new JsonObject();
            json.addProperty("id", Serializer.ID.toString());
            json.addProperty("tag", this.tag.f_203868_().toString());
            json.addProperty("hook", this.hook.getId().toString());
            return json;
        }

        public ToolHookValue(TagKey<Item> tag, ModuleHook<?> hook) {
            this.tag = tag;
            this.hook = hook;
        }
    }

    public static enum Serializer implements IIngredientSerializer<ToolHookIngredient>
    {
        INSTANCE;

        public static final ResourceLocation ID;

        public ToolHookIngredient parse(JsonObject json) {
            return new ToolHookIngredient((TagKey<Item>)((TagKey)Loadables.ITEM_TAG.getOrDefault(json, "tag", TinkerTags.Items.MODIFIABLE)), (ModuleHook)ToolHooks.LOADER.getIfPresent(json, "hook"));
        }

        public ToolHookIngredient parse(FriendlyByteBuf buffer) {
            return new ToolHookIngredient((TagKey<Item>)((TagKey)Loadables.ITEM_TAG.decode(buffer)), (ModuleHook)ToolHooks.LOADER.decode(buffer));
        }

        public void write(FriendlyByteBuf buffer, ToolHookIngredient ingredient) {
            Loadables.ITEM_TAG.encode(buffer, ingredient.tag);
            ToolHooks.LOADER.encode(buffer, ingredient.hook);
        }

        static {
            ID = TConstruct.getResource("tool_hook");
        }
    }
}

