/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.DynamicFluidContainerModel;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.tconstruct.TConstruct;

public record FluidContainerModel(FluidStack fluid, boolean flipGas) implements IUnbakedGeometry<FluidContainerModel>
{
    public static final IGeometryLoader<FluidContainerModel> LOADER = FluidContainerModel::deserialize;
    public static final Transformation FLUID_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.002f), new Quaternionf());

    public static FluidContainerModel deserialize(JsonObject json, JsonDeserializationContext context) {
        FluidStack fluidStack = FluidStack.EMPTY;
        if (json.has("fluid")) {
            Fluid fluid;
            JsonElement fluidElement = json.get("fluid");
            CompoundTag tag = null;
            if (fluidElement.isJsonObject()) {
                JsonObject fluidObject = fluidElement.getAsJsonObject();
                fluid = (Fluid)Loadables.FLUID.getIfPresent(fluidObject, "name");
                if (fluidObject.has("nbt")) {
                    tag = CraftingHelper.getNBT((JsonElement)fluidObject.get("nbt"));
                }
            } else {
                fluid = (Fluid)Loadables.FLUID.convert(fluidElement, "fluid");
            }
            fluidStack = new FluidStack(fluid, 1000, tag);
        }
        boolean flipGas = GsonHelper.m_13855_((JsonObject)json, (String)"flip_gas", (boolean)true);
        return new FluidContainerModel(fluidStack, flipGas);
    }

    @Nullable
    private static TextureAtlasSprite getSprite(IGeometryBakingContext context, Function<Material, TextureAtlasSprite> spriteGetter, String key) {
        if (context.hasMaterial(key)) {
            return spriteGetter.apply(context.getMaterial(key));
        }
        return null;
    }

    private static BakedModel bakeInternal(IGeometryBakingContext context, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation, FluidStack fluid, boolean flipGas) {
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite baseSprite = FluidContainerModel.getSprite(context, spriteGetter, "base");
        TextureAtlasSprite fluidSprite = !fluid.isEmpty() ? spriteGetter.apply(new Material(InventoryMenu.f_39692_, clientFluid.getStillTexture(fluid))) : null;
        TextureAtlasSprite particleSprite = FluidContainerModel.getSprite(context, spriteGetter, "particle");
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null) {
            TConstruct.LOG.error("No valid particle sprite for fluid container model, you should supply either 'base' or 'particle'");
            particleSprite = spriteGetter.apply(new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_()));
        }
        if (flipGas && !fluid.isEmpty() && fluid.getFluid().getFluidType().isLighterThanAir()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(new Transformation(null, new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)context, (TextureAtlasSprite)particleSprite, (ItemOverrides)overrides, (ItemTransforms)context.getTransforms());
        RenderTypeGroup renderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)false);
        if (baseSprite != null) {
            modelBuilder.addQuads(renderTypes, (Collection)UnbakedGeometryHelper.bakeElements((List)UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)baseSprite.m_245424_()), $ -> baseSprite, (ModelState)modelState, (ResourceLocation)modelLocation));
        }
        if (fluidSprite != null) {
            int color;
            List quads = UnbakedGeometryHelper.bakeElements((List)UnbakedGeometryHelper.createUnbakedItemMaskElements((int)1, (SpriteContents)spriteGetter.apply(context.getMaterial("fluid")).m_245424_()), $ -> fluidSprite, (ModelState)new SimpleModelState(modelState.m_6189_().m_121096_(FLUID_TRANSFORM), modelState.m_7538_()), (ResourceLocation)modelLocation);
            RenderTypeGroup fluidRenderTypes = renderTypes;
            int light = fluid.getFluid().getFluidType().getLightLevel(fluid);
            if (light > 0) {
                fluidRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)true);
                QuadTransformers.settingEmissivity((int)light).processInPlace(quads);
            }
            if ((color = clientFluid.getTintColor(fluid)) != -1) {
                ColoredBlockModel.applyColorQuadTransformer((int)color).processInPlace(quads);
            }
            modelBuilder.addQuads(fluidRenderTypes, (Collection)quads);
        }
        return modelBuilder.build();
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        context = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        if (this.fluid.isEmpty()) {
            overrides = new ContainedFluidOverrideHandler(context, overrides, modelState, this.flipGas);
        }
        return FluidContainerModel.bakeInternal(context, spriteGetter, modelState, overrides, modelLocation, this.fluid, this.flipGas);
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private static final ResourceLocation BAKE_LOCATION = TConstruct.getResource("copper_can_dynamic");
        private final Map<FluidStack, BakedModel> cache = Maps.newHashMap();
        private final IGeometryBakingContext context;
        private final ItemOverrides nested;
        private final ModelState modelState;
        private final boolean flipGas;

        private BakedModel getUncahcedModel(FluidStack fluid) {
            return FluidContainerModel.bakeInternal(this.context, Material::m_119204_, this.modelState, ItemOverrides.f_111734_, BAKE_LOCATION, fluid, this.flipGas);
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            BakedModel overriden = this.nested.m_173464_(originalModel, stack, world, entity, seed);
            if (overriden != originalModel) {
                return overriden;
            }
            Optional optional = FluidUtil.getFluidContained((ItemStack)stack);
            if (optional.isPresent()) {
                FluidStack fluid = (FluidStack)optional.get();
                fluid.setAmount(1000);
                return this.cache.computeIfAbsent(fluid, this::getUncahcedModel);
            }
            return originalModel;
        }

        public ContainedFluidOverrideHandler(IGeometryBakingContext context, ItemOverrides nested, ModelState modelState, boolean flipGas) {
            this.context = context;
            this.nested = nested;
            this.modelState = modelState;
            this.flipGas = flipGas;
        }
    }
}

