/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data.material;

import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import slimeknights.mantle.datagen.MantleTags;
import slimeknights.mantle.recipe.condition.TagCombinationCondition;
import slimeknights.mantle.recipe.condition.TagFilledCondition;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.BaseRecipeProvider;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipeBuilder;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.world.TinkerWorld;

public class MaterialRecipeProvider
extends BaseRecipeProvider
implements IMaterialRecipeHelper {
    public MaterialRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    @Override
    public String m_6055_() {
        return "Tinkers' Construct Material Recipe";
    }

    @Override
    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.addMaterialItems(consumer);
        this.addMaterialSmeltery(consumer);
    }

    private void addMaterialItems(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/materials/";
        this.materialRecipe(consumer, MaterialIds.wood, Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN), 1, 2, folder + "wood/sticks");
        this.materialRecipe(consumer, MaterialIds.crimson, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42797_}), 1, 1, folder + "wood/planks/crimson");
        this.materialRecipe(consumer, MaterialIds.warped, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42798_}), 1, 1, folder + "wood/planks/warped");
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{TagCombinationCondition.difference((TagKey)ItemTags.f_13168_, TinkerTags.Items.VARIANT_PLANKS)}), MaterialIds.wood, (Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.m_204132_((TagKey)ItemTags.f_13168_), (Ingredient)Ingredient.m_204132_(TinkerTags.Items.VARIANT_PLANKS)), 1, 1, folder + "wood/planks/default");
        this.materialRecipe(consumer, MaterialIds.wood, Ingredient.m_204132_((TagKey)ItemTags.f_13184_), 4, 1, ItemOutput.fromItem((ItemLike)Blocks.f_50705_), folder + "wood/logs/oak");
        this.materialRecipe(consumer, MaterialIds.wood, Ingredient.m_204132_((TagKey)ItemTags.f_13188_), 4, 1, ItemOutput.fromItem((ItemLike)Blocks.f_50741_), folder + "wood/logs/spruce");
        this.materialRecipe(consumer, MaterialIds.wood, Ingredient.m_204132_((TagKey)ItemTags.f_13185_), 4, 1, ItemOutput.fromItem((ItemLike)Blocks.f_50742_), folder + "wood/logs/birch");
        this.materialRecipe(consumer, MaterialIds.wood, Ingredient.m_204132_((TagKey)ItemTags.f_13187_), 4, 1, ItemOutput.fromItem((ItemLike)Blocks.f_50743_), folder + "wood/logs/jungle");
        this.materialRecipe(consumer, MaterialIds.wood, Ingredient.m_204132_((TagKey)ItemTags.f_13183_), 4, 1, ItemOutput.fromItem((ItemLike)Blocks.f_50745_), folder + "wood/logs/dark_oak");
        this.materialRecipe(consumer, MaterialIds.wood, Ingredient.m_204132_((TagKey)ItemTags.f_13186_), 4, 1, ItemOutput.fromItem((ItemLike)Blocks.f_50744_), folder + "wood/logs/acacia");
        this.materialRecipe(consumer, MaterialIds.wood, Ingredient.m_204132_((TagKey)ItemTags.f_215869_), 4, 1, ItemOutput.fromItem((ItemLike)Blocks.f_220865_), folder + "wood/logs/mangrove");
        this.materialRecipe(consumer, MaterialIds.wood, Ingredient.m_204132_((TagKey)ItemTags.f_271202_), 4, 1, ItemOutput.fromItem((ItemLike)Blocks.f_271304_), folder + "wood/logs/cherry");
        this.materialRecipe(consumer, MaterialIds.crimson, Ingredient.m_204132_((TagKey)ItemTags.f_13189_), 4, 1, ItemOutput.fromItem((ItemLike)Blocks.f_50655_), folder + "wood/logs/crimson");
        this.materialRecipe(consumer, MaterialIds.warped, Ingredient.m_204132_((TagKey)ItemTags.f_13190_), 4, 1, ItemOutput.fromItem((ItemLike)Blocks.f_50656_), folder + "wood/logs/warped");
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{TagCombinationCondition.difference((TagKey)ItemTags.f_13182_, TinkerTags.Items.VARIANT_LOGS)}), MaterialIds.wood, (Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.m_204132_((TagKey)ItemTags.f_13182_), (Ingredient)Ingredient.m_204132_(TinkerTags.Items.VARIANT_LOGS)), 4, 1, ItemOutput.fromItem((ItemLike)Items.f_42398_, (int)2), folder + "wood/logs/default");
        this.materialRecipe(consumer, MaterialIds.bamboo, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41911_}), 1, 9, folder + "wood/bamboo/stick");
        this.materialRecipe(consumer, MaterialIds.bamboo, Ingredient.m_204132_((TagKey)ItemTags.f_256904_), 1, 1, folder + "wood/bamboo/block");
        this.materialRecipe(consumer, MaterialIds.bamboo, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_244477_}), 1, 2, folder + "wood/bamboo/planks");
        this.materialRecipe(consumer, MaterialIds.stone, Ingredient.m_204132_(TinkerTags.Items.STONE), 1, 1, folder + "rock/stone");
        this.materialRecipe(consumer, MaterialIds.andesite, Ingredient.m_204132_(TinkerTags.Items.ANDESITE), 1, 1, folder + "rock/andesite");
        this.materialRecipe(consumer, MaterialIds.diorite, Ingredient.m_204132_(TinkerTags.Items.DIORITE), 1, 1, folder + "rock/diorite");
        this.materialRecipe(consumer, MaterialIds.granite, Ingredient.m_204132_(TinkerTags.Items.GRANITE), 1, 1, folder + "rock/granite");
        this.materialRecipe(consumer, MaterialIds.deepslate, Ingredient.m_204132_(TinkerTags.Items.DEEPSLATE), 1, 1, folder + "rock/deepslate");
        this.materialRecipe(consumer, MaterialIds.blackstone, Ingredient.m_204132_(TinkerTags.Items.BLACKSTONE), 1, 1, folder + "rock/blackstone");
        this.materialRecipe(consumer, MaterialIds.flint, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}), 1, 1, folder + "flint");
        this.materialRecipe(consumer, MaterialIds.basalt, Ingredient.m_204132_(TinkerTags.Items.BASALT), 1, 1, folder + "flint_basalt");
        ItemOutput copperIngot = ItemOutput.fromTag((TagKey)Tags.Items.INGOTS_COPPER);
        this.materialRecipe(consumer, MaterialIds.copper, Ingredient.m_204132_(TinkerTags.Items.NUGGETS_COPPER), 1, 9, folder + "copper/nugget");
        this.materialRecipe(consumer, MaterialIds.copper, Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER), 1, 1, folder + "copper/ingot");
        this.materialRecipe(consumer, MaterialIds.copper, CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)Tags.Items.STORAGE_BLOCKS_COPPER), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_152571_})}), 9, 1, copperIngot, folder + "copper/block");
        this.materialRecipe(consumer, MaterialIds.oxidizedCopper, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_152503_, Blocks.f_152502_, Blocks.f_152501_, Blocks.f_152573_, Blocks.f_152572_, Blocks.f_152574_}), 9, 1, copperIngot, folder + "copper/oxidized");
        this.materialRecipe(consumer, MaterialIds.bone, Ingredient.m_204132_(TinkerTags.Items.BONES), 1, 1, folder + "bone");
        this.materialRecipe(consumer, MaterialIds.chorus, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42731_}), 1, 1, folder + "chorus_popped");
        this.materialRecipe(consumer, MaterialIds.string, Ingredient.m_204132_((TagKey)Tags.Items.STRING), 1, 4, folder + "string");
        this.materialRecipe(consumer, MaterialIds.leather, Ingredient.m_204132_((TagKey)Tags.Items.LEATHER), 1, 1, folder + "leather");
        this.materialRecipe(consumer, MaterialIds.leather, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42649_}), 1, 2, folder + "rabbit_hide");
        this.materialRecipe(consumer, MaterialIds.vine, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42029_}), 1, 1, folder + "vine");
        this.materialRecipe(consumer, MaterialIds.cactus, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50128_}), 1, 1, folder + "cactus");
        this.materialRecipe(consumer, MaterialIds.ice, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50126_}), 1, 9, folder + "ice/unpacked");
        this.materialRecipe(consumer, MaterialIds.ice, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50354_}), 1, 1, folder + "ice/packed");
        this.materialRecipe(consumer, MaterialIds.ice, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50568_}), 9, 1, folder + "ice/blue");
        this.metalMaterialRecipe(consumer, MaterialIds.iron, folder, "iron", false);
        this.materialRecipe(consumer, MaterialIds.searedStone, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.searedBrick}), 1, 1, folder + "seared_stone/brick");
        this.materialRecipe(consumer, MaterialIds.searedStone, Ingredient.m_204132_(TinkerTags.Items.SEARED_BLOCKS), 4, 1, ItemOutput.fromItem(TinkerSmeltery.searedBrick), folder + "seared_stone/block");
        this.materialRecipe(consumer, MaterialIds.scorchedStone, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.scorchedBrick}), 1, 1, folder + "scorched_stone/brick");
        this.materialRecipe(consumer, MaterialIds.scorchedStone, Ingredient.m_204132_(TinkerTags.Items.SCORCHED_BLOCKS), 4, 1, ItemOutput.fromItem(TinkerSmeltery.scorchedBrick), folder + "scorched_stone/block");
        this.materialRecipe(consumer, MaterialIds.venombone, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerMaterials.venombone}), 1, 1, folder + "venombone");
        this.metalMaterialRecipe(consumer, MaterialIds.roseGold, folder, "rose_gold", false);
        this.materialRecipe(consumer, MaterialIds.necroticBone, Ingredient.m_204132_(TinkerTags.Items.WITHER_BONES), 1, 1, folder + "necrotic_bone");
        this.materialRecipe(consumer, MaterialIds.endstone, Ingredient.m_204132_((TagKey)Tags.Items.END_STONES), 1, 1, folder + "endstone");
        this.materialRecipe(consumer, MaterialIds.skyslimeVine, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.skySlimeVine}), 1, 1, folder + "skyslime_vine");
        this.materialRecipe(consumer, MaterialIds.weepingVine, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41907_}), 1, 1, folder + "weeping_vine");
        this.materialRecipe(consumer, MaterialIds.twistingVine, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41908_}), 1, 1, folder + "twisting_vine");
        this.materialRecipe(consumer, MaterialIds.greenheart, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.greenheart}), 1, 1, folder + "slimewood/greenheart_planks");
        this.materialRecipe(consumer, MaterialIds.skyroot, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.skyroot}), 1, 1, folder + "slimewood/skyroot_planks");
        this.materialRecipe(consumer, MaterialIds.bloodshroom, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.bloodshroom}), 1, 1, folder + "slimewood/bloodshroom_planks");
        this.materialRecipe(consumer, MaterialIds.enderbark, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.enderbark}), 1, 1, folder + "slimewood/enderbark_planks");
        this.materialRecipe(consumer, MaterialIds.greenheart, Ingredient.m_204132_((TagKey)TinkerWorld.greenheart.getLogItemTag()), 4, 1, ItemOutput.fromItem((ItemLike)TinkerWorld.greenheart), folder + "slimewood/greenheart_logs");
        this.materialRecipe(consumer, MaterialIds.skyroot, Ingredient.m_204132_((TagKey)TinkerWorld.skyroot.getLogItemTag()), 4, 1, ItemOutput.fromItem((ItemLike)TinkerWorld.skyroot), folder + "slimewood/skyroot_logs");
        this.materialRecipe(consumer, MaterialIds.bloodshroom, Ingredient.m_204132_((TagKey)TinkerWorld.bloodshroom.getLogItemTag()), 4, 1, ItemOutput.fromItem((ItemLike)TinkerWorld.bloodshroom), folder + "slimewood/bloodshroom_logs");
        this.materialRecipe(consumer, MaterialIds.enderbark, Ingredient.m_204132_((TagKey)TinkerWorld.enderbark.getLogItemTag()), 4, 1, ItemOutput.fromItem((ItemLike)TinkerWorld.enderbark), folder + "slimewood/enderbark_logs");
        this.metalMaterialRecipe(consumer, MaterialIds.slimesteel, folder, "slimesteel", false);
        this.materialRecipe(consumer, MaterialIds.nahuatl, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerMaterials.nahuatl}), 1, 1, folder + "nahuatl");
        this.metalMaterialRecipe(consumer, MaterialIds.amethystBronze, folder, "amethyst_bronze", false);
        this.metalMaterialRecipe(consumer, MaterialIds.pigIron, folder, "pig_iron", false);
        this.materialRecipe(consumer, MaterialIds.obsidian, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41999_}), 1, 1, folder + "obsidian");
        this.metalMaterialRecipe(consumer, MaterialIds.cobalt, folder, "cobalt", false);
        this.metalMaterialRecipe(consumer, MaterialIds.steel, folder, "steel", false);
        this.metalMaterialRecipe(consumer, MaterialIds.cinderslime, folder, "cinderslime", false);
        this.metalMaterialRecipe(consumer, MaterialIds.queensSlime, folder, "queens_slime", false);
        this.metalMaterialRecipe(consumer, MaterialIds.manyullyn, folder, "manyullyn", false);
        this.metalMaterialRecipe(consumer, MaterialIds.hepatizon, folder, "hepatizon", false);
        this.metalMaterialRecipe(consumer, MaterialIds.knightmetal, folder, "knightmetal", false);
        this.materialRecipe(consumer, MaterialIds.blazewood, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerMaterials.blazewood}), 1, 1, folder + "blazewood");
        this.materialRecipe(consumer, MaterialIds.blazingBone, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerMaterials.blazingBone}), 1, 1, folder + "blazing_bone");
        this.materialRecipe(consumer, MaterialIds.ancient, Ingredient.m_204132_(TinkerTags.Items.INGOTS_NETHERITE_SCRAP), 1, 1, folder + "ancient/ingot");
        this.materialRecipe(consumer, MaterialIds.ancient, Ingredient.m_204132_(TinkerTags.Items.NUGGETS_NETHERITE_SCRAP), 1, 9, folder + "ancient/nugget");
        this.materialRecipe(consumer, MaterialIds.enderslimeVine, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.enderSlimeVine}), 1, 1, folder + "enderslime_vine");
        this.metalMaterialRecipe(consumer, MaterialIds.osmium, folder, "osmium", true);
        this.metalMaterialRecipe(consumer, MaterialIds.ironwood, folder, "ironwood", true);
        this.metalMaterialRecipe(consumer, MaterialIds.silver, folder, "silver", true);
        this.metalMaterialRecipe(consumer, MaterialIds.lead, folder, "lead", true);
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{this.tagCondition("treated_wood")}), MaterialIds.treatedWood, Ingredient.m_204132_((TagKey)this.getItemTag("forge", "treated_wood")), 1, 1, folder + "treated_wood");
        this.metalMaterialRecipe(consumer, MaterialIds.bronze, folder, "bronze", true);
        this.metalMaterialRecipe(consumer, MaterialIds.constantan, folder, "constantan", true);
        this.metalMaterialRecipe(consumer, MaterialIds.invar, folder, "invar", true);
        this.metalMaterialRecipe(consumer, MaterialIds.pewter, folder, "pewter", true);
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/uranium")}), MaterialIds.necronium, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerMaterials.necroniumBone}), 1, 1, folder + "necronium");
        this.metalMaterialRecipe(consumer, MaterialIds.electrum, folder, "electrum", true);
        this.metalMaterialRecipe(consumer, MaterialIds.fiery, folder, "fiery", true);
        this.metalMaterialRecipe(consumer, MaterialIds.gold, folder, "gold", false);
        this.materialRecipe(consumer, MaterialIds.glass, Ingredient.m_204132_((TagKey)Tags.Items.GLASS), 1, 1, folder + "glass");
        this.materialRecipe(consumer, MaterialIds.glass, Ingredient.m_204132_((TagKey)Tags.Items.GLASS_PANES), 1, 4, folder + "glass_pane");
        this.materialRecipe(consumer, MaterialIds.enderPearl, Ingredient.m_204132_((TagKey)Tags.Items.ENDER_PEARLS), 1, 1, folder + "ender_pearl");
        this.materialRecipe(consumer, MaterialIds.rottenFlesh, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42583_}), 1, 1, folder + "rotten_flesh");
        this.materialRecipe(consumer, MaterialIds.enderslime, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.ENDER)}), 1, 1, folder + "enderslime/ball");
        this.materialRecipe(consumer, MaterialIds.enderslime, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ENDER)}), 4, 1, folder + "enderslime/congealed");
        this.materialRecipe(consumer, MaterialIds.enderslime, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerWorld.slime.get((Enum)SlimeType.ENDER)}), 9, 1, folder + "enderslime/block");
        this.materialRecipe(consumer, MaterialIds.phantom, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42714_}), 1, 1, folder + "phantom_membrane");
    }

    private void addMaterialSmeltery(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/materials/";
        MaterialMeltingRecipeBuilder.material((MaterialVariantId)MaterialIds.ice, 10, FluidOutput.fromFluid((Fluid)Fluids.f_76193_, (int)9000)).save(consumer, this.location(folder + "melting/ice"));
        this.materialMeltingCasting(consumer, MaterialIds.iron, (FluidObject)TinkerFluids.moltenIron, folder);
        this.materialMeltingCasting(consumer, MaterialIds.copper, (FluidObject)TinkerFluids.moltenCopper, folder);
        this.materialMeltingCasting(consumer, MaterialIds.searedStone, (FluidObject)TinkerFluids.searedStone, 250, folder);
        this.materialMeltingCasting(consumer, MaterialIds.scorchedStone, (FluidObject)TinkerFluids.scorchedStone, 250, folder);
        this.materialComposite(consumer, MaterialIds.rock, MaterialIds.searedStone, (FluidObject)TinkerFluids.moltenClay, 125, folder);
        this.materialComposite(consumer, MaterialIds.flint, MaterialIds.scorchedStone, (FluidObject)TinkerFluids.magma, 125, folder);
        this.materialComposite(consumer, MaterialIds.wood, MaterialIds.slimewoodComposite, (FluidObject)TinkerFluids.earthSlime, 250, folder);
        this.materialComposite(consumer, MaterialIds.bone, MaterialIds.venombone, (FluidObject)TinkerFluids.venom, 250, folder);
        MaterialFluidRecipeBuilder.material(MaterialIds.oxidizedIron).setInputId(MaterialIds.iron).setFluid((TagKey<Fluid>)MantleTags.Fluids.WATER, 250).setTemperature(1).save(consumer, this.location(folder + "composite/iron_oxidized"));
        MaterialFluidRecipeBuilder.material(MaterialIds.oxidizedCopper).setInputId(MaterialIds.copper).setFluid((TagKey<Fluid>)MantleTags.Fluids.WATER, 250).setTemperature(1).save(consumer, this.location(folder + "composite/copper_oxidized"));
        String slimeskinFolder = folder + "slimeskin/";
        this.materialComposite(consumer, MaterialIds.leather, MaterialIds.slimeskin, (FluidObject)TinkerFluids.earthSlime, 250, slimeskinFolder, "earth");
        this.materialComposite(consumer, MaterialIds.leather, MaterialIds.skySlimeskin, (FluidObject)TinkerFluids.skySlime, 250, slimeskinFolder, "sky");
        this.materialComposite(consumer, MaterialIds.leather, MaterialIds.ichorskin, TinkerFluids.ichor, 250, slimeskinFolder, "ichor");
        this.materialComposite(consumer, MaterialIds.leather, MaterialIds.enderSlimeskin, (FluidObject)TinkerFluids.enderSlime, 250, slimeskinFolder, "ender");
        this.materialComposite(consumer, MaterialIds.slimeskin, MaterialIds.leather, (FluidObject)TinkerFluids.venom, 50, slimeskinFolder, "earth_cleaning");
        this.materialComposite(consumer, MaterialIds.skySlimeskin, MaterialIds.leather, (FluidObject)TinkerFluids.venom, 50, slimeskinFolder, "sky_cleaning");
        this.materialComposite(consumer, MaterialIds.ichorskin, MaterialIds.leather, (FluidObject)TinkerFluids.venom, 50, slimeskinFolder, "ichor_cleaning");
        this.materialComposite(consumer, MaterialIds.enderSlimeskin, MaterialIds.leather, (FluidObject)TinkerFluids.venom, 50, slimeskinFolder, "ender_cleaning");
        this.materialMeltingCasting(consumer, MaterialIds.slimesteel, (FluidObject)TinkerFluids.moltenSlimesteel, folder);
        this.materialMeltingCasting(consumer, MaterialIds.amethystBronze, (FluidObject)TinkerFluids.moltenAmethystBronze, folder);
        this.materialMeltingCasting(consumer, MaterialIds.roseGold, (FluidObject)TinkerFluids.moltenRoseGold, folder);
        this.materialMeltingCasting(consumer, MaterialIds.pigIron, (FluidObject)TinkerFluids.moltenPigIron, folder);
        this.materialMeltingCasting(consumer, MaterialIds.cobalt, (FluidObject)TinkerFluids.moltenCobalt, folder);
        this.materialMeltingCasting(consumer, MaterialIds.steel, (FluidObject)TinkerFluids.moltenSteel, folder);
        this.materialMeltingCasting(consumer, MaterialIds.obsidian, (FluidObject)TinkerFluids.moltenObsidian, 1000, folder);
        this.materialComposite(consumer, MaterialIds.string, MaterialIds.roseGold, (FluidObject)TinkerFluids.moltenRoseGold, 90, folder);
        this.materialMeltingComposite(consumer, MaterialIds.wood, MaterialIds.nahuatl, (FluidObject)TinkerFluids.moltenObsidian, 1000, folder);
        this.materialMeltingComposite(consumer, MaterialIds.string, MaterialIds.darkthread, (FluidObject)TinkerFluids.moltenObsidian, 250, folder);
        this.materialMeltingCasting(consumer, MaterialIds.cinderslime, TinkerFluids.moltenCinderslime, folder);
        this.materialMeltingCasting(consumer, MaterialIds.queensSlime, (FluidObject)TinkerFluids.moltenQueensSlime, folder);
        this.materialMeltingCasting(consumer, MaterialIds.hepatizon, (FluidObject)TinkerFluids.moltenHepatizon, folder);
        this.materialMeltingCasting(consumer, MaterialIds.manyullyn, (FluidObject)TinkerFluids.moltenManyullyn, folder);
        this.materialMeltingCasting(consumer, MaterialIds.knightmetal, (FluidObject)TinkerFluids.moltenKnightmetal, folder);
        this.materialComposite(consumer, MaterialIds.bloodshroom, MaterialIds.blazewood, (FluidObject)TinkerFluids.blazingBlood, 200, folder);
        this.materialComposite(consumer, MaterialIds.necroticBone, MaterialIds.blazingBone, (FluidObject)TinkerFluids.blazingBlood, 200, folder);
        this.materialMeltingComposite(consumer, MaterialIds.leather, MaterialIds.ancientHide, (FluidObject)TinkerFluids.moltenDebris, 90, folder);
        this.materialComposite(consumer, MaterialIds.ancientHide, MaterialIds.leather, (FluidObject)TinkerFluids.venom, 50, folder, "ancient_hide_cleaning");
        this.materialMelting(consumer, MaterialIds.ancient, (FluidObject)TinkerFluids.moltenDebris, 90, folder);
        this.compatMeltingCasting(consumer, MaterialIds.osmium, (FluidObject)TinkerFluids.moltenOsmium, folder);
        this.compatMeltingCasting(consumer, MaterialIds.silver, (FluidObject)TinkerFluids.moltenSilver, folder);
        this.compatMeltingCasting(consumer, MaterialIds.lead, (FluidObject)TinkerFluids.moltenLead, folder);
        this.compatMeltingCasting(consumer, MaterialIds.aluminum, (FluidObject)TinkerFluids.moltenAluminum, folder);
        this.materialComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/aluminum")}), MaterialIds.rock, MaterialIds.whitestoneAluminum, (FluidObject)TinkerFluids.moltenAluminum, 90, folder, "whitestone_from_aluminum");
        this.materialComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/tin")}), MaterialIds.rock, MaterialIds.whitestoneTin, (FluidObject)TinkerFluids.moltenTin, 90, folder, "whitestone_from_tin");
        this.materialComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/zinc")}), MaterialIds.rock, MaterialIds.whitestoneZinc, (FluidObject)TinkerFluids.moltenZinc, 90, folder, "whitestone_from_zinc");
        TagKey creosote = this.getFluidTag("forge", "creosote");
        MaterialFluidRecipeBuilder.material(MaterialIds.treatedWood).setInputId(MaterialIds.wood).setFluid((FluidIngredient)FluidIngredient.of((TagKey)creosote, (int)125)).setTemperature(600).save(this.withCondition(consumer, new ICondition[]{new TagFilledCondition(creosote)}), this.location(folder + "composite/treated_wood"));
        MaterialMeltingRecipeBuilder.material((MaterialVariantId)MaterialIds.ironwood, TinkerFluids.moltenIron, 90).addByproduct(TinkerFluids.moltenGold.result(10)).save(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/ironwood")}), this.location(folder + "melting/ironwood"));
        this.compatMeltingCasting(consumer, MaterialIds.constantan, (FluidObject)TinkerFluids.moltenConstantan, "nickel", folder);
        this.compatMeltingCasting(consumer, MaterialIds.invar, (FluidObject)TinkerFluids.moltenInvar, "nickel", folder);
        this.compatMeltingCasting(consumer, MaterialIds.electrum, (FluidObject)TinkerFluids.moltenElectrum, "silver", folder);
        this.compatMeltingCasting(consumer, MaterialIds.bronze, (FluidObject)TinkerFluids.moltenBronze, "tin", folder);
        this.materialMeltingCasting(this.withCondition(consumer, new ICondition[]{new OrCondition(new ICondition[]{this.tagCondition("ingots/pewter"), this.tagCondition("ingots/tin"), this.tagCondition("ingots/lead")})}), MaterialIds.pewter, (FluidObject)TinkerFluids.moltenPewter, folder);
        this.materialMeltingComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/uranium")}), MaterialIds.necroticBone, MaterialIds.necronium, (FluidObject)TinkerFluids.moltenUranium, 90, folder);
        this.materialMeltingComposite(this.withCondition(consumer, new ICondition[]{new OrCondition(new ICondition[]{this.tagCondition("ingots/brass"), this.tagCondition("ingots/zinc")})}), MaterialIds.slimewood, MaterialIds.platedSlimewood, (FluidObject)TinkerFluids.moltenBrass, 90, folder);
        Consumer fieryConsumer = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/fiery")});
        this.materialComposite(fieryConsumer, MaterialIds.iron, MaterialIds.fiery, (FluidObject)TinkerFluids.fieryLiquid, 250, folder);
        MaterialMeltingRecipeBuilder.material((MaterialVariantId)MaterialIds.fiery, TinkerFluids.fieryLiquid, 250).addByproduct(TinkerFluids.moltenIron.result(90)).save(fieryConsumer, this.location(folder + "melting/fiery"));
        this.materialMeltingCasting(consumer, MaterialIds.gold, (FluidObject)TinkerFluids.moltenGold, folder);
        this.materialMeltingCasting(consumer, MaterialIds.enderPearl, (FluidObject)TinkerFluids.moltenEnder, 250, folder);
        this.materialMeltingCasting(consumer, MaterialIds.glass, (FluidObject)TinkerFluids.moltenGlass, 1000, folder);
        this.materialMeltingCasting(consumer, MaterialIds.enderslime, (FluidObject)TinkerFluids.enderSlime, 250, folder);
    }
}

