/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.gson.ConditionSerializer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.exception.TinkerJSONException;
import slimeknights.tconstruct.library.json.JsonRedirect;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.UpdateMaterialsPacket;
import slimeknights.tconstruct.library.materials.json.MaterialJson;
import slimeknights.tconstruct.library.utils.GenericTagUtil;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialManager
extends SimpleJsonResourceReloadListener {
    private static final Logger log = LogManager.getLogger(MaterialManager.class);
    public static final String FOLDER = "tinkering/materials/definition";
    public static final String TAG_FOLDER = "tinkering/tags/materials";
    public static final ResourceKey<? extends Registry<IMaterial>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)TConstruct.getResource("materials"));
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(ICondition.class, (Object)ConditionSerializer.INSTANCE).setPrettyPrinting().disableHtmlEscaping().create();
    private final Runnable onLoaded;
    private Map<MaterialId, IMaterial> materials = Collections.emptyMap();
    private Map<MaterialId, MaterialId> redirects = Collections.emptyMap();
    private List<IMaterial> sortedMaterials = Collections.emptyList();
    private Map<TagKey<IMaterial>, List<IMaterial>> tags = Collections.emptyMap();
    private Map<MaterialId, Set<TagKey<IMaterial>>> reverseTags = Collections.emptyMap();
    private ICondition.IContext conditionContext = ICondition.IContext.EMPTY;

    public MaterialManager(Runnable onLoaded) {
        super(GSON, FOLDER);
        this.onLoaded = onLoaded;
    }

    @VisibleForTesting
    MaterialManager() {
        this(() -> {});
    }

    public Collection<IMaterial> getVisibleMaterials() {
        return this.sortedMaterials;
    }

    public Collection<IMaterial> getAllMaterials() {
        return this.materials.values();
    }

    public Optional<IMaterial> getMaterial(MaterialId materialId) {
        return Optional.ofNullable(this.materials.get(materialId));
    }

    public MaterialId resolveRedirect(MaterialId materialId) {
        return this.redirects.getOrDefault(materialId, materialId);
    }

    public static TagKey<IMaterial> getTag(ResourceLocation id) {
        return TagKey.m_203882_(REGISTRY_KEY, (ResourceLocation)id);
    }

    public Stream<TagKey<IMaterial>> getTagKeys(MaterialId id) {
        return this.reverseTags.getOrDefault(id, Set.of()).stream();
    }

    public boolean isIn(MaterialId id, TagKey<IMaterial> tag) {
        return this.reverseTags.getOrDefault(id, Collections.emptySet()).contains(tag);
    }

    @Nullable
    public List<IMaterial> getTagOrNull(TagKey<IMaterial> tag) {
        return this.tags.get(tag);
    }

    public List<IMaterial> getValues(TagKey<IMaterial> tag) {
        return this.tags.getOrDefault(tag, List.of());
    }

    public Stream<Map.Entry<TagKey<IMaterial>, List<IMaterial>>> getAllTags() {
        return this.tags.entrySet().stream();
    }

    private void onMaterialUpdate() {
        this.sortedMaterials = this.materials.values().stream().filter(mat -> !mat.isHidden()).sorted().collect(Collectors.toList());
        this.onLoaded.run();
    }

    public void updateMaterialsFromServer(Map<MaterialId, IMaterial> materials, Map<MaterialId, MaterialId> redirects, Map<TagKey<IMaterial>, List<IMaterial>> tags) {
        this.materials = materials;
        this.redirects = redirects;
        this.tags = tags;
        this.reverseTags = GenericTagUtil.reverseTags(IMaterial::getIdentifier, tags);
        this.onMaterialUpdate();
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        long time = System.nanoTime();
        HashMap<MaterialId, MaterialId> redirects = new HashMap<MaterialId, MaterialId>();
        this.materials = splashList.entrySet().stream().filter(entry -> ((JsonElement)entry.getValue()).isJsonObject()).map(entry -> this.loadMaterial((ResourceLocation)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject(), redirects)).filter(Objects::nonNull).collect(Collectors.toMap(IMaterial::getIdentifier, material -> material));
        Iterator redirectIterator = redirects.entrySet().iterator();
        while (redirectIterator.hasNext()) {
            Map.Entry entry2 = redirectIterator.next();
            if (this.materials.containsKey(entry2.getValue())) continue;
            log.error("Invalid material redirect {} as material {} does not exist", entry2.getKey(), entry2.getValue());
            redirectIterator.remove();
        }
        this.redirects = redirects;
        this.onMaterialUpdate();
        log.debug("Loaded materials: {}", (Object)Util.toIndentedStringList(this.materials.keySet()));
        log.debug("Loaded redirects: {}", (Object)Util.toIndentedStringList(redirects.keySet()));
        long timeStep = System.nanoTime();
        log.info("Loaded {} materials in {} ms", (Object)this.materials.size(), (Object)Float.valueOf((float)(timeStep - time) / 1000000.0f));
        TagLoader tagLoader = new TagLoader(id -> this.getMaterial(new MaterialId((ResourceLocation)id)), TAG_FOLDER);
        this.tags = GenericTagUtil.mapLoaderResults(REGISTRY_KEY, tagLoader.m_203900_(resourceManagerIn));
        this.reverseTags = GenericTagUtil.reverseTags(IMaterial::getIdentifier, this.tags);
        log.info("Loaded {} material tags for {} materials in {} ms", (Object)this.tags.size(), (Object)this.reverseTags.size(), (Object)Float.valueOf((float)(System.nanoTime() - timeStep) / 1000000.0f));
    }

    public UpdateMaterialsPacket getUpdatePacket() {
        return new UpdateMaterialsPacket(this.materials, this.redirects, this.tags);
    }

    @Nullable
    private IMaterial loadMaterial(ResourceLocation materialId, JsonObject jsonObject, Map<MaterialId, MaterialId> redirects) {
        try {
            ICondition condition;
            MaterialJson materialJson = (MaterialJson)GSON.fromJson((JsonElement)jsonObject, MaterialJson.class);
            JsonRedirect[] redirectsJson = materialJson.getRedirect();
            if (redirectsJson != null) {
                for (JsonRedirect redirect : redirectsJson) {
                    ICondition redirectCondition = redirect.getCondition();
                    if (redirectCondition != null && !redirectCondition.test(this.conditionContext)) continue;
                    MaterialId redirectTarget = new MaterialId(redirect.getId());
                    log.debug("Redirecting material {} to {}", (Object)materialId, (Object)redirectTarget);
                    redirects.put(new MaterialId(materialId), redirectTarget);
                    return null;
                }
            }
            if ((condition = materialJson.getCondition()) != null && !condition.test(this.conditionContext)) {
                log.debug("Skipped loading material {} as it did not match the condition", (Object)materialId);
                return null;
            }
            if (materialJson.getCraftable() == null) {
                throw TinkerJSONException.materialJsonWithoutCraftingInformation(materialId);
            }
            boolean isCraftable = Boolean.TRUE.equals(materialJson.getCraftable());
            boolean hidden = Boolean.TRUE.equals(materialJson.getHidden());
            return new Material(materialId, Objects.requireNonNullElse(materialJson.getTier(), 0), Objects.requireNonNullElse(materialJson.getSortOrder(), 100), isCraftable, hidden);
        }
        catch (Exception e) {
            log.error("Could not deserialize material {}. JSON: {}", (Object)materialId, (Object)jsonObject, (Object)e);
            return null;
        }
    }

    public void setConditionContext(ICondition.IContext conditionContext) {
        this.conditionContext = conditionContext;
    }
}

