/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ItemExistsCondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.recipe.condition.TagCombinationCondition;
import slimeknights.mantle.recipe.condition.TagFilledCondition;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;
import slimeknights.mantle.recipe.data.ItemNameIngredient;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

@CanIgnoreReturnValue
public class SmelteryRecipeBuilder {
    private static final int[] UNDAMAGABLE = new int[]{0};
    private final Consumer<FinishedRecipe> consumer;
    private final ResourceLocation name;
    @Nullable
    private final FluidObject<?> fluidObject;
    @Nullable
    private final Fluid fluid;
    @Nullable
    private final TagKey<Fluid> fluidTag;
    private int temperature;
    private boolean optional = false;
    private boolean hasOre = false;
    private IByproduct[] oreByproducts = new IByproduct[0];
    private IByproduct[] unitByproducts = new IByproduct[0];
    private String meltingFolder = "melting/";
    private String castingFolder = "casting/";
    private IMeltingContainer.OreRateType oreRate = null;
    private int baseUnit = 0;
    private int damageUnit = 1;
    public static final ToolTagMelting SHOVEL = new ToolTagMelting(1, "shovel");
    public static final ToolCostMelting SHOVEL_PLUS = new ToolCostMelting(1, "shovel");
    public static final ToolCostMelting SWORD = new ToolCostMelting(2, "sword");
    public static final ToolCostMelting AXES = new ToolCostMelting(3, "axes");
    public static final CommonRecipe[] TOOLS = new CommonRecipe[]{SHOVEL, SWORD, AXES};
    public static final ArmorTagMelting HELMET = new ArmorTagMelting(5, "helmet", "helmets");
    public static final ArmorTagMelting CHESTPLATE = new ArmorTagMelting(8, "chestplate", "chestplates");
    public static final ArmorTagMelting LEGGINGS = new ArmorTagMelting(7, "leggings", "leggings");
    public static final ArmorTagMelting BOOTS = new ArmorTagMelting(4, "boots", "boots");
    public static final CommonRecipe[] ARMOR = new CommonRecipe[]{HELMET, CHESTPLATE, LEGGINGS, BOOTS};
    public static final ToolCostMelting HELMET_PLUS = new ToolCostMelting(5, "helmet");
    public static final ToolCostMelting CHESTPLATE_PLUS = new ToolCostMelting(8, "chestplate");
    public static final ToolCostMelting LEGGINGS_PLUS = new ToolCostMelting(7, "leggings");
    public static final ToolCostMelting BOOTS_PLUS = new ToolCostMelting(4, "boots");
    public static final CommonRecipe[] ARMOR_PLUS = new CommonRecipe[]{HELMET_PLUS, CHESTPLATE_PLUS, LEGGINGS_PLUS, BOOTS_PLUS};

    @CheckReturnValue
    public static SmelteryRecipeBuilder fluid(Consumer<FinishedRecipe> consumer, ResourceLocation name, FluidObject<?> fluid) {
        return new SmelteryRecipeBuilder(consumer, name, fluid, null, null).temperature(IMeltingRecipe.getTemperature(fluid));
    }

    @CheckReturnValue
    public static SmelteryRecipeBuilder fluid(Consumer<FinishedRecipe> consumer, ResourceLocation name, @Nullable Fluid fluid, @Nullable TagKey<Fluid> fluidTag) {
        assert (fluid != null || fluidTag != null);
        SmelteryRecipeBuilder builder = new SmelteryRecipeBuilder(consumer, name, null, fluid, fluidTag);
        if (fluid != null) {
            builder.temperature(IMeltingRecipe.getTemperature(fluid));
        }
        return builder;
    }

    @CheckReturnValue
    public static SmelteryRecipeBuilder fluid(Consumer<FinishedRecipe> consumer, ResourceLocation name, Fluid fluid) {
        return SmelteryRecipeBuilder.fluid(consumer, name, fluid, null);
    }

    @CheckReturnValue
    public static SmelteryRecipeBuilder fluid(Consumer<FinishedRecipe> consumer, ResourceLocation name, TagKey<Fluid> fluidTag) {
        return SmelteryRecipeBuilder.fluid(consumer, name, null, fluidTag);
    }

    public SmelteryRecipeBuilder optional() {
        return this.optional(true);
    }

    public SmelteryRecipeBuilder ore(IByproduct ... byproducts) {
        this.oreByproducts = byproducts;
        this.hasOre = true;
        return this;
    }

    public SmelteryRecipeBuilder unitByproducts(IByproduct ... byproducts) {
        this.unitByproducts = byproducts;
        return this;
    }

    public SmelteryRecipeBuilder meltingFolder(String meltingFolder) {
        this.meltingFolder = meltingFolder + "/";
        return this;
    }

    public SmelteryRecipeBuilder castingFolder(String castingFolder) {
        this.castingFolder = castingFolder + "/";
        return this;
    }

    @CheckReturnValue
    private FluidOutput result(int amount) {
        if (this.fluidObject != null) {
            return this.fluidObject.result(amount);
        }
        if (this.fluid != null) {
            return FluidOutput.fromFluid((Fluid)this.fluid, (int)amount);
        }
        assert (this.fluidTag != null);
        return FluidOutput.fromTag(this.fluidTag, (int)amount);
    }

    @CheckReturnValue
    private FluidIngredient ingredient(int amount) {
        if (this.fluidObject != null) {
            return this.fluidObject.ingredient(amount);
        }
        if (this.fluidTag != null) {
            return FluidIngredient.of(this.fluidTag, (int)amount);
        }
        assert (this.fluid != null);
        return FluidIngredient.of((Fluid)this.fluid, (int)amount);
    }

    @CheckReturnValue
    private Consumer<FinishedRecipe> withCondition(ICondition ... conditions) {
        ConsumerWrapperBuilder builder = ConsumerWrapperBuilder.wrap();
        for (ICondition condition : conditions) {
            builder.addCondition(condition);
        }
        return builder.build(this.consumer);
    }

    @CheckReturnValue
    public static ICondition tagCondition(ResourceLocation tag) {
        return new TagFilledCondition(ItemTags.create((ResourceLocation)tag));
    }

    @CheckReturnValue
    public static ICondition tagCondition(String name) {
        return SmelteryRecipeBuilder.tagCondition(Mantle.commonResource((String)name));
    }

    @CheckReturnValue
    public static TagKey<Item> itemTag(String name) {
        return ItemTags.create((ResourceLocation)Mantle.commonResource((String)name));
    }

    @CheckReturnValue
    private ResourceLocation location(String folder, String variant) {
        return this.name.m_247449_(folder + this.name.m_135815_() + "/" + variant);
    }

    private int[] damageUnits() {
        int[] units = new int[1 + this.unitByproducts.length];
        units[0] = this.damageUnit;
        for (int i = 0; i < this.unitByproducts.length; ++i) {
            units[i + 1] = this.unitByproducts[i].getDamageUnit();
        }
        return units;
    }

    private void minecraftArmorMelting(int cost, String prefix, String name) {
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(prefix + "_" + name));
        if (item == Items.f_41852_) {
            throw new IllegalArgumentException("Unknown item name minecraft:" + name);
        }
        MeltingRecipeBuilder.melting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), this.result(cost * this.baseUnit), this.temperature, (float)Math.sqrt(cost)).setDamagable(this.damageUnit).save(this.consumer, this.location(this.meltingFolder, name));
    }

    private void itemMelting(float scale, String output, float factor, ResourceLocation itemName, boolean damagable) {
        MeltingRecipeBuilder builder = MeltingRecipeBuilder.melting((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{itemName}), this.result((int)((float)this.baseUnit * scale)), this.temperature, factor);
        if (damagable) {
            builder.setDamagable(this.damageUnits());
        }
        for (IByproduct byproduct : this.unitByproducts) {
            builder.addByproduct(byproduct.getFluid(scale));
        }
        builder.save(this.withCondition(new ICondition[]{new ItemExistsCondition(itemName)}), this.location(this.meltingFolder, output));
    }

    private void tagMelting(float scale, String output, float factor, String tagName, boolean forceOptional) {
        this.tagMelting(scale, output, factor, Mantle.commonResource((String)tagName), false, forceOptional);
    }

    private void tagMelting(float scale, String output, float factor, ResourceLocation tagName, boolean damagable, boolean forceOptional) {
        Consumer<FinishedRecipe> wrapped = this.optional || forceOptional ? this.withCondition(SmelteryRecipeBuilder.tagCondition(tagName)) : this.consumer;
        MeltingRecipeBuilder builder = MeltingRecipeBuilder.melting(Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)tagName)), this.result((int)((float)this.baseUnit * scale)), this.temperature, factor);
        if (damagable) {
            builder.setDamagable(this.damageUnits());
        }
        for (IByproduct byproduct : this.unitByproducts) {
            builder.addByproduct(byproduct.getFluid(scale));
        }
        builder.save(wrapped, this.location(this.meltingFolder, output));
    }

    private void oreMelting(float scale, String tagPrefix, @Nullable TagKey<Item> size, float factor, String output, boolean forceOptional) {
        Consumer<FinishedRecipe> wrapped;
        Ingredient ingredient;
        assert (this.oreRate != null);
        assert (this.baseUnit != 0);
        String tagName = tagPrefix + this.name.m_135815_();
        Ingredient baseIngredient = Ingredient.m_204132_(SmelteryRecipeBuilder.itemTag(tagName));
        if (size == Tags.Items.ORE_RATES_SINGULAR) {
            ingredient = DifferenceIngredient.of((Ingredient)baseIngredient, (Ingredient)Ingredient.m_204132_(TinkerTags.Items.NON_SINGULAR_ORE_RATES));
            wrapped = this.withCondition(new ICondition[]{TagCombinationCondition.difference(SmelteryRecipeBuilder.itemTag(tagName), TinkerTags.Items.NON_SINGULAR_ORE_RATES)});
        } else if (size != null) {
            ingredient = IntersectionIngredient.of((Ingredient[])new Ingredient[]{baseIngredient, Ingredient.m_204132_(size)});
            wrapped = this.withCondition(new ICondition[]{TagCombinationCondition.intersection((TagKey[])new TagKey[]{SmelteryRecipeBuilder.itemTag(tagName), size})});
        } else {
            ingredient = baseIngredient;
            wrapped = this.optional || forceOptional ? this.withCondition(SmelteryRecipeBuilder.tagCondition(tagName)) : this.consumer;
        }
        Supplier<MeltingRecipeBuilder> supplier = () -> MeltingRecipeBuilder.melting(ingredient, this.result((int)((float)this.baseUnit * scale)), this.temperature, factor).setOre(this.oreRate, new IMeltingContainer.OreRateType[0]);
        ResourceLocation location = this.location(this.meltingFolder, output);
        if (this.oreByproducts.length == 0) {
            supplier.get().save(wrapped, location);
        } else if (this.oreByproducts[0].isAlwaysPresent()) {
            supplier.get().addByproduct(this.oreByproducts[0].getFluid(scale)).setOre(this.oreRate, this.oreByproducts[0].getOreRate()).save(wrapped, location);
        } else {
            ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
            boolean alwaysPresent = false;
            for (IByproduct byproduct : this.oreByproducts) {
                alwaysPresent = byproduct.isAlwaysPresent();
                if (alwaysPresent) {
                    builder.addCondition((ICondition)TrueCondition.INSTANCE);
                } else {
                    builder.addCondition(SmelteryRecipeBuilder.tagCondition("ingots/" + byproduct.getName()));
                }
                builder.addRecipe(supplier.get().addByproduct(byproduct.getFluid(scale)).setOre(this.oreRate, byproduct.getOreRate())::save);
                if (alwaysPresent) break;
            }
            if (!alwaysPresent) {
                builder.addCondition((ICondition)TrueCondition.INSTANCE);
                builder.addRecipe(supplier.get()::save);
            }
            builder.build(wrapped, location);
        }
    }

    private void tagCasting(float scale, String outputPrefix, CastItemObject cast, String tagName, boolean forceOptional) {
        if (this.unitByproducts.length > 0) {
            throw new IllegalArgumentException("Cannot cast using a cast for a fluid with byproducts");
        }
        Consumer<FinishedRecipe> wrapped = this.optional || forceOptional ? this.withCondition(SmelteryRecipeBuilder.tagCondition(tagName)) : this.consumer;
        ItemOutput output = ItemOutput.fromTag(SmelteryRecipeBuilder.itemTag(tagName));
        int amount = (int)((float)this.baseUnit * scale);
        FluidIngredient fluid = this.ingredient(amount);
        ItemCastingRecipeBuilder.tableRecipe(output).setFluid(fluid).setCoolingTime(this.temperature, amount).setCast(cast.getMultiUseTag(), false).save(wrapped, this.location(this.castingFolder, outputPrefix + "_gold_cast"));
        ItemCastingRecipeBuilder.tableRecipe(output).setFluid(fluid).setCoolingTime(this.temperature, amount).setCast(cast.getSingleUseTag(), true).save(wrapped, this.location(this.castingFolder, outputPrefix + "_sand_cast"));
    }

    private void tagCasting(float scale, String outputName, Ingredient cast, String tagName, boolean forceOptional) {
        Consumer<FinishedRecipe> wrapped = this.optional || forceOptional ? this.withCondition(SmelteryRecipeBuilder.tagCondition(tagName)) : this.consumer;
        ItemOutput output = ItemOutput.fromTag(SmelteryRecipeBuilder.itemTag(tagName));
        int amount = (int)((float)this.baseUnit * scale);
        FluidIngredient fluid = this.ingredient(amount);
        ItemCastingRecipeBuilder.tableRecipe(output).setFluid(fluid).setCoolingTime(this.temperature, amount).setCast(cast, true).save(wrapped, this.location(this.castingFolder, outputName));
    }

    public SmelteryRecipeBuilder blockCasting(int factor, Ingredient cast, boolean forceOptional) {
        String tagName = "storage_blocks/" + this.name.m_135815_();
        Consumer<FinishedRecipe> wrapped = this.optional || forceOptional ? this.withCondition(SmelteryRecipeBuilder.tagCondition(tagName)) : this.consumer;
        ItemCastingRecipeBuilder.basinRecipe(ItemOutput.fromTag(SmelteryRecipeBuilder.itemTag(tagName))).setFluid(this.ingredient(this.baseUnit * factor)).setCoolingTime(this.temperature, this.baseUnit * factor).setCast(cast, true).save(wrapped, this.location(this.castingFolder, "block"));
        return this;
    }

    public SmelteryRecipeBuilder meltingCasting(float scale, String tagPrefix, CastItemObject cast, float factor, boolean forceOptional) {
        assert (this.baseUnit != 0);
        String tagName = tagPrefix + "s/" + this.name.m_135815_();
        this.tagMelting(scale, tagPrefix, factor, tagName, forceOptional);
        this.tagCasting(scale, tagPrefix, cast, tagName, forceOptional);
        return this;
    }

    public SmelteryRecipeBuilder meltingCasting(float scale, CastItemObject cast, float factor, boolean forceOptional) {
        return this.meltingCasting(scale, cast.getName().m_135815_(), cast, factor, forceOptional);
    }

    public SmelteryRecipeBuilder meltingCasting(float scale, String tagPrefix, Ingredient cast, float factor, boolean forceOptional) {
        assert (this.baseUnit != 0);
        String tagName = tagPrefix + "s/" + this.name.m_135815_();
        this.tagMelting(scale, tagPrefix, factor, tagName, forceOptional);
        this.tagCasting(scale, tagPrefix, cast, tagName, forceOptional);
        return this;
    }

    public SmelteryRecipeBuilder meltingCasting(float scale, String tagPrefix, String castMaterial, float factor, boolean forceOptional) {
        return this.meltingCasting(scale, tagPrefix, Ingredient.m_204132_(SmelteryRecipeBuilder.itemTag(tagPrefix + "s/" + castMaterial)), factor, forceOptional);
    }

    public SmelteryRecipeBuilder itemMelting(float scale, String domain, String path, boolean damagable) {
        this.itemMelting(scale, domain + "_" + path, (float)Math.sqrt(scale), new ResourceLocation(domain, path), damagable);
        return this;
    }

    public SmelteryRecipeBuilder metalMelting(float scale, String domain, String path, boolean damagable) {
        this.itemMelting(scale, domain + "_" + path, (float)Math.sqrt(scale), new ResourceLocation(domain, this.name.m_135815_() + "_" + path), damagable);
        return this;
    }

    public SmelteryRecipeBuilder melting(float scale, String output, ResourceLocation tagName, float factor, boolean damagable, boolean forceOptional) {
        assert (this.baseUnit != 0);
        this.tagMelting(scale, output, factor, tagName, damagable, forceOptional);
        return this;
    }

    public SmelteryRecipeBuilder melting(float scale, String output, String tagPrefix, float factor, boolean damagable, boolean forceOptional) {
        return this.melting(scale, output, Mantle.commonResource((String)(tagPrefix + "/" + this.name.m_135815_())), factor, damagable, forceOptional);
    }

    public SmelteryRecipeBuilder melting(float scale, String output, String tagPrefix, boolean damagable, boolean forceOptional) {
        return this.melting(scale, output, tagPrefix, (float)Math.sqrt(scale), damagable, forceOptional);
    }

    public SmelteryRecipeBuilder melting(float scale, String tagPrefix, float factor, boolean forceOptional) {
        return this.melting(scale, tagPrefix, tagPrefix + "s", factor, false, forceOptional);
    }

    public SmelteryRecipeBuilder toolItemMelting(int cost, String domain, String path) {
        this.itemMelting(cost, domain + "_" + path, (float)Math.sqrt(cost), new ResourceLocation(domain, this.name.m_135815_() + "_" + path), true);
        return this;
    }

    public SmelteryRecipeBuilder toolTagMelting(int cost, String name) {
        return this.melting(cost, name, "tools/" + name + "s", true, true);
    }

    public SmelteryRecipeBuilder toolCostMelting(int cost, String name, boolean forceOptional) {
        return this.melting((float)cost, name, this.name.m_247449_("melting/" + this.name.m_135815_() + "/tools_costing_" + cost), (float)Math.sqrt(cost), true, forceOptional);
    }

    public SmelteryRecipeBuilder toolCostMelting(int cost, String name) {
        return this.toolCostMelting(cost, name, true);
    }

    public SmelteryRecipeBuilder rawOre() {
        assert (this.oreRate != null);
        assert (this.baseUnit != 0);
        this.oreMelting(1.0f, "raw_materials/", null, 1.5f, "raw", false);
        this.oreMelting(9.0f, "storage_blocks/raw_", null, 6.0f, "raw_block", false);
        return this;
    }

    public SmelteryRecipeBuilder sparseOre(float scale) {
        this.oreMelting(scale, "ores/", (TagKey<Item>)Tags.Items.ORE_RATES_SPARSE, 1.5f, "ore_sparse", false);
        return this;
    }

    public SmelteryRecipeBuilder singularOre(float scale) {
        this.oreMelting(scale, "ores/", (TagKey<Item>)Tags.Items.ORE_RATES_SINGULAR, 2.5f, "ore_singular", false);
        return this;
    }

    public SmelteryRecipeBuilder denseOre(float scale) {
        this.oreMelting(scale, "ores/", (TagKey<Item>)Tags.Items.ORE_RATES_DENSE, 4.5f, "ore_dense", false);
        return this;
    }

    public SmelteryRecipeBuilder metal() {
        this.oreRate = IMeltingContainer.OreRateType.METAL;
        this.baseUnit = 90;
        this.damageUnit = 10;
        this.melting(9.0f, "block", "storage_blocks", 3.0f, false, false);
        this.blockCasting(9, Ingredient.f_43901_, false);
        this.meltingCasting(1.0f, TinkerSmeltery.ingotCast, 1.0f, false);
        this.meltingCasting(0.11111111f, TinkerSmeltery.nuggetCast, 0.33333334f, false);
        if (this.hasOre) {
            this.rawOre();
            this.sparseOre(1.0f);
            this.singularOre(2.0f);
            this.denseOre(6.0f);
        }
        return this;
    }

    public SmelteryRecipeBuilder gem(int storageSize) {
        this.oreRate = IMeltingContainer.OreRateType.GEM;
        this.baseUnit = 100;
        this.damageUnit = 25;
        this.melting((float)storageSize, "block", "storage_blocks", (float)Math.sqrt(storageSize), false, false);
        this.blockCasting(storageSize, Ingredient.f_43901_, false);
        this.meltingCasting(1.0f, TinkerSmeltery.gemCast, 1.0f, false);
        if (this.hasOre) {
            this.sparseOre(0.5f);
            this.singularOre(1.0f);
            this.denseOre(3.0f);
        }
        return this;
    }

    public SmelteryRecipeBuilder smallGem() {
        return this.gem(4);
    }

    public SmelteryRecipeBuilder largeGem() {
        return this.gem(9);
    }

    public SmelteryRecipeBuilder geore() {
        assert (this.oreRate != null);
        assert (this.baseUnit != 0);
        this.melting(1.0f, "geore/shard", "geore_shards", 1.0f, false, true);
        this.melting(4.0f, "geore/block", "geore_blocks", 2.0f, false, true);
        this.oreMelting(4.0f, "geore_clusters/", null, 2.5f, "geore/cluster", true);
        this.oreMelting(1.0f, "geore_small_buds/", null, 1.0f, "geore/bud_small", true);
        this.oreMelting(2.0f, "geore_medium_buds/", null, 1.5f, "geore/bud_medium", true);
        this.oreMelting(3.0f, "geore_large_buds/", null, 2.0f, "geore/bud_large", true);
        return this;
    }

    public SmelteryRecipeBuilder oreberry() {
        assert (this.baseUnit == 90);
        this.itemMelting(0.11111111f, "oreberry", 0.33333334f, new ResourceLocation("oreberriesreplanted", this.name.m_135815_() + "_oreberry"), false);
        return this;
    }

    public SmelteryRecipeBuilder dust() {
        return this.melting(1.0f, "dust", 0.75f, true);
    }

    public SmelteryRecipeBuilder plate() {
        return this.meltingCasting(1.0f, TinkerSmeltery.plateCast, 1.0f, true);
    }

    public SmelteryRecipeBuilder gear() {
        return this.meltingCasting(4.0f, TinkerSmeltery.gearCast, 2.0f, true);
    }

    public SmelteryRecipeBuilder rod() {
        return this.meltingCasting(0.5f, TinkerSmeltery.rodCast, 0.2f, true);
    }

    public SmelteryRecipeBuilder sheetmetal() {
        return this.melting(1.0f, "sheetmetal", 1.0f, true);
    }

    public SmelteryRecipeBuilder coin() {
        return this.meltingCasting(0.33333334f, TinkerSmeltery.coinCast, 0.6666667f, true);
    }

    public SmelteryRecipeBuilder wire() {
        return this.meltingCasting(0.5f, TinkerSmeltery.wireCast, 0.2f, true);
    }

    @ApiStatus.Internal
    public SmelteryRecipeBuilder minecraftTools(String prefix) {
        this.toolCostMelting(1, "shovel", false);
        this.toolCostMelting(2, "sword", false);
        this.toolCostMelting(3, "axes", false);
        this.minecraftArmorMelting(5, prefix, "helmet");
        this.minecraftArmorMelting(8, prefix, "chestplate");
        this.minecraftArmorMelting(4, prefix, "boots");
        this.toolCostMelting(7, "leggings", false);
        return this;
    }

    @ApiStatus.Internal
    public SmelteryRecipeBuilder minecraftTools() {
        return this.minecraftTools(this.name.m_135815_());
    }

    public SmelteryRecipeBuilder common(CommonRecipe ... recipes) {
        for (CommonRecipe recipe : recipes) {
            recipe.accept(this);
        }
        return this;
    }

    private SmelteryRecipeBuilder(Consumer<FinishedRecipe> consumer, ResourceLocation name, @Nullable FluidObject<?> fluidObject, @Nullable Fluid fluid, @Nullable TagKey<Fluid> fluidTag) {
        this.consumer = consumer;
        this.name = name;
        this.fluidObject = fluidObject;
        this.fluid = fluid;
        this.fluidTag = fluidTag;
    }

    public SmelteryRecipeBuilder temperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public SmelteryRecipeBuilder optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public SmelteryRecipeBuilder oreRate(IMeltingContainer.OreRateType oreRate) {
        this.oreRate = oreRate;
        return this;
    }

    public SmelteryRecipeBuilder baseUnit(int baseUnit) {
        this.baseUnit = baseUnit;
        return this;
    }

    public SmelteryRecipeBuilder damageUnit(int damageUnit) {
        this.damageUnit = damageUnit;
        return this;
    }

    public static interface CommonRecipe
    extends Consumer<SmelteryRecipeBuilder> {
    }

    public record ToolTagMelting(int cost, String name) implements CommonRecipe
    {
        @Override
        public void accept(SmelteryRecipeBuilder builder) {
            builder.toolTagMelting(this.cost, this.name);
        }
    }

    public record ToolCostMelting(int cost, String name) implements CommonRecipe
    {
        @Override
        public void accept(SmelteryRecipeBuilder builder) {
            builder.toolCostMelting(this.cost, this.name, true);
        }
    }

    public record ArmorTagMelting(int cost, String name, String tag) implements CommonRecipe
    {
        @Override
        public void accept(SmelteryRecipeBuilder builder) {
            builder.melting(this.cost, this.name, "armors/" + this.tag, true, true);
        }
    }

    public record ToolItemMelting(int cost, String domain, String name) implements CommonRecipe
    {
        @Override
        public void accept(SmelteryRecipeBuilder builder) {
            builder.toolItemMelting(this.cost, this.domain, this.name);
        }
    }
}

