/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class MaterialModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        Material smallTexture = MaterialModifierModel.stitchMaterialTextures(smallGetter);
        Material largeTexture = MaterialModifierModel.stitchMaterialTextures(largeGetter);
        if (smallTexture != null || largeTexture != null) {
            return new MaterialModifierModel(smallTexture, largeTexture);
        }
        return null;
    };
    @Nullable
    private final Material small;
    @Nullable
    private final Material large;

    @Nullable
    private static Material stitchMaterialTextures(Function<String, Material> textureGetter) {
        Material baseTexture = textureGetter.apply("");
        if (baseTexture != null) {
            for (MaterialRenderInfo info : MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos()) {
                ResourceLocation texture = info.texture();
                if (texture != null) {
                    textureGetter.apply("_" + MaterialRenderInfo.getSuffix(texture));
                }
                for (String fallback : info.fallbacks()) {
                    textureGetter.apply("_" + fallback);
                }
            }
        }
        return baseTexture;
    }

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        ModifierId modifier = entry.getId();
        return new CacheKey(modifier, tool.getPersistentData().getString(modifier));
    }

    @Nullable
    private static MaterialVariantId getMaterial(IToolStackView tool, Modifier modifier) {
        String material = tool.getPersistentData().getString(modifier.getId());
        if (!material.isEmpty()) {
            return MaterialVariantId.tryParse(material);
        }
        return null;
    }

    @Override
    public void addQuads(IToolStackView tool, ModifierEntry modifier, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, Consumer<Collection<BakedQuad>> quadConsumer, @Nullable ItemLayerPixels pixels) {
        MaterialVariantId material;
        Material texture;
        Material material2 = texture = isLarge ? this.large : this.small;
        if (texture != null && (material = MaterialModifierModel.getMaterial(tool, modifier.getModifier())) != null) {
            quadConsumer.accept(MaterialModel.getQuadsForMaterial(spriteGetter, texture, material, -1, transforms, pixels));
        }
    }

    public MaterialModifierModel(@Nullable Material small, @Nullable Material large) {
        this.small = small;
        this.large = large;
    }

    private record CacheKey(ModifierId modifier, String material) {
    }
}

