/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.mantle.item.EdibleItem;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.data.model.ModelSpriteProvider;
import slimeknights.tconstruct.common.data.model.TinkerBlockStateProvider;
import slimeknights.tconstruct.common.data.model.TinkerItemModelProvider;
import slimeknights.tconstruct.common.data.model.TinkerSpriteSourceProvider;
import slimeknights.tconstruct.common.data.render.RenderFluidProvider;
import slimeknights.tconstruct.common.data.render.RenderItemProvider;
import slimeknights.tconstruct.common.json.BlockOrEntityCondition;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.json.condition.TagDifferencePresentCondition;
import slimeknights.tconstruct.library.json.condition.TagIntersectionPresentCondition;
import slimeknights.tconstruct.library.json.condition.TagNotEmptyCondition;
import slimeknights.tconstruct.library.json.loot.TagPreferenceLootEntry;
import slimeknights.tconstruct.library.json.predicate.BlockAtFeetEntityPredicate;
import slimeknights.tconstruct.library.json.predicate.HarvestTierPredicate;
import slimeknights.tconstruct.library.json.predicate.HasMobEffectPredicate;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.recipe.ingredient.BlockTagIngredient;
import slimeknights.tconstruct.library.recipe.ingredient.NoContainerIngredient;
import slimeknights.tconstruct.library.utils.SlimeBounceHandler;
import slimeknights.tconstruct.shared.TinkerFood;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.BetterPaneBlock;
import slimeknights.tconstruct.shared.block.ClearGlassPaneBlock;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.ClearStainedGlassPaneBlock;
import slimeknights.tconstruct.shared.block.GlowBlock;
import slimeknights.tconstruct.shared.block.PlatformBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.shared.block.SoulGlassBlock;
import slimeknights.tconstruct.shared.block.SoulGlassPaneBlock;
import slimeknights.tconstruct.shared.block.WaxedPlatformBlock;
import slimeknights.tconstruct.shared.block.WeatheringPlatformBlock;
import slimeknights.tconstruct.shared.command.TConstructCommand;
import slimeknights.tconstruct.shared.data.CommonRecipeProvider;
import slimeknights.tconstruct.shared.inventory.BlockContainerOpenedTrigger;
import slimeknights.tconstruct.shared.item.CheeseBlockItem;
import slimeknights.tconstruct.shared.item.CheeseItem;
import slimeknights.tconstruct.shared.item.TinkerBookItem;
import slimeknights.tconstruct.shared.particle.FluidParticleData;
import slimeknights.tconstruct.tools.TinkerModifiers;

public final class TinkerCommons
extends TinkerModule {
    public static final RegistryObject<CreativeModeTab> tabGeneral = CREATIVE_TABS.register("general", () -> CreativeModeTab.builder().m_257941_((Component)TConstruct.makeTranslation("itemGroup", "general")).m_257737_(() -> new ItemStack(materialsAndYou)).m_257501_(TinkerCommons::addTabItems).m_257652_());
    public static final RegistryObject<GlowBlock> glow = BLOCKS.registerNoItem("glow", () -> new GlowBlock(TinkerCommons.builder(MapColor.f_283808_, SoundType.f_56745_).m_60910_().m_278166_(PushReaction.DESTROY).m_280170_().m_60978_(0.0f).m_60953_(s -> 14).m_60955_()));
    public static final ItemObject<GlassBlock> clearGlass = BLOCKS.register("clear_glass", () -> new GlassBlock(TinkerCommons.glassBuilder(MapColor.f_283808_)), BLOCK_ITEM);
    public static final ItemObject<TintedGlassBlock> clearTintedGlass = BLOCKS.register("clear_tinted_glass", () -> new TintedGlassBlock(TinkerCommons.glassBuilder(MapColor.f_283818_).m_60955_().m_60922_(Blocks::m_50778_).m_60924_(Blocks::m_50805_).m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_)), BLOCK_ITEM);
    public static final ItemObject<ClearGlassPaneBlock> clearGlassPane = BLOCKS.register("clear_glass_pane", () -> new ClearGlassPaneBlock(TinkerCommons.glassBuilder(MapColor.f_283808_)), BLOCK_ITEM);
    public static final EnumObject<ClearStainedGlassBlock.GlassColor, ClearStainedGlassBlock> clearStainedGlass = BLOCKS.registerEnum(ClearStainedGlassBlock.GlassColor.values(), "clear_stained_glass", color -> new ClearStainedGlassBlock(TinkerCommons.glassBuilder(color.getDye().m_284406_()), (ClearStainedGlassBlock.GlassColor)((Object)color)), BLOCK_ITEM);
    public static final EnumObject<ClearStainedGlassBlock.GlassColor, ClearStainedGlassPaneBlock> clearStainedGlassPane = BLOCKS.registerEnum(ClearStainedGlassBlock.GlassColor.values(), "clear_stained_glass_pane", color -> new ClearStainedGlassPaneBlock(TinkerCommons.glassBuilder(color.getDye().m_284406_()), (ClearStainedGlassBlock.GlassColor)((Object)color)), BLOCK_ITEM);
    public static final ItemObject<GlassBlock> soulGlass = BLOCKS.register("soul_glass", () -> new SoulGlassBlock(TinkerCommons.glassBuilder(MapColor.f_283748_).m_60956_(0.2f).m_60910_().m_60971_((state, getter, pos) -> true)), TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<ClearGlassPaneBlock> soulGlassPane = BLOCKS.register("soul_glass_pane", () -> new SoulGlassPaneBlock(TinkerCommons.glassBuilder(MapColor.f_283748_).m_60956_(0.2f)), TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<IronBarsBlock> goldBars = BLOCKS.register("gold_bars", () -> new IronBarsBlock(TinkerCommons.builder(MapColor.f_283808_, SoundType.f_56743_).m_60999_().m_60913_(3.0f, 6.0f).m_60955_()), TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<BetterPaneBlock> obsidianPane = BLOCKS.register("obsidian_pane", () -> new BetterPaneBlock(TinkerCommons.builder(MapColor.f_283927_, SoundType.f_56742_).m_60999_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60955_().m_60913_(25.0f, 400.0f)), BLOCK_ITEM);
    public static final ItemObject<PlatformBlock> goldPlatform = BLOCKS.register("gold_platform", () -> new PlatformBlock(TinkerCommons.builder(MapColor.f_283757_, SoundType.f_154663_).m_60999_().m_60913_(3.0f, 6.0f).m_60955_()), TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<PlatformBlock> ironPlatform = BLOCKS.register("iron_platform", () -> new PlatformBlock(TinkerCommons.builder(MapColor.f_283906_, SoundType.f_154663_).m_60999_().m_60913_(5.0f, 6.0f).m_60955_()), BLOCK_ITEM);
    public static final ItemObject<PlatformBlock> cobaltPlatform = BLOCKS.register("cobalt_platform", () -> new PlatformBlock(TinkerCommons.builder(MapColor.f_283743_, SoundType.f_154663_).m_60999_().m_60978_(5.0f).m_60955_()), BLOCK_ITEM);
    public static final EnumObject<WeatheringCopper.WeatherState, PlatformBlock> copperPlatform = new EnumObject.Builder(WeatheringCopper.WeatherState.class).put((Enum)WeatheringCopper.WeatherState.UNAFFECTED, (Supplier)BLOCKS.register("copper_platform", () -> new WeatheringPlatformBlock(WeatheringCopper.WeatherState.UNAFFECTED, TinkerCommons.builder(MapColor.f_283750_, SoundType.f_154663_).m_60999_().m_60913_(3.0f, 6.0f).m_60955_()), BLOCK_ITEM)).put((Enum)WeatheringCopper.WeatherState.EXPOSED, (Supplier)BLOCKS.register("exposed_copper_platform", () -> new WeatheringPlatformBlock(WeatheringCopper.WeatherState.EXPOSED, TinkerCommons.builder(MapColor.f_283907_, SoundType.f_154663_).m_60999_().m_60913_(3.0f, 6.0f).m_60955_()), BLOCK_ITEM)).put((Enum)WeatheringCopper.WeatherState.WEATHERED, (Supplier)BLOCKS.register("weathered_copper_platform", () -> new WeatheringPlatformBlock(WeatheringCopper.WeatherState.WEATHERED, TinkerCommons.builder(MapColor.f_283749_, SoundType.f_154663_).m_60999_().m_60913_(3.0f, 6.0f).m_60955_()), BLOCK_ITEM)).put((Enum)WeatheringCopper.WeatherState.OXIDIZED, (Supplier)BLOCKS.register("oxidized_copper_platform", () -> new WeatheringPlatformBlock(WeatheringCopper.WeatherState.OXIDIZED, TinkerCommons.builder(MapColor.f_283745_, SoundType.f_154663_).m_60999_().m_60913_(3.0f, 6.0f).m_60955_()), BLOCK_ITEM)).build();
    public static final EnumObject<WeatheringCopper.WeatherState, PlatformBlock> waxedCopperPlatform = new EnumObject.Builder(WeatheringCopper.WeatherState.class).put((Enum)WeatheringCopper.WeatherState.UNAFFECTED, (Supplier)BLOCKS.register("waxed_copper_platform", () -> new WaxedPlatformBlock(WeatheringCopper.WeatherState.UNAFFECTED, TinkerCommons.builder(MapColor.f_283750_, SoundType.f_154663_).m_60999_().m_60913_(3.0f, 6.0f).m_60955_()), BLOCK_ITEM)).put((Enum)WeatheringCopper.WeatherState.EXPOSED, (Supplier)BLOCKS.register("waxed_exposed_copper_platform", () -> new WaxedPlatformBlock(WeatheringCopper.WeatherState.EXPOSED, TinkerCommons.builder(MapColor.f_283907_, SoundType.f_154663_).m_60999_().m_60913_(3.0f, 6.0f).m_60955_()), BLOCK_ITEM)).put((Enum)WeatheringCopper.WeatherState.WEATHERED, (Supplier)BLOCKS.register("waxed_weathered_copper_platform", () -> new WaxedPlatformBlock(WeatheringCopper.WeatherState.WEATHERED, TinkerCommons.builder(MapColor.f_283749_, SoundType.f_154663_).m_60999_().m_60913_(3.0f, 6.0f).m_60955_()), BLOCK_ITEM)).put((Enum)WeatheringCopper.WeatherState.OXIDIZED, (Supplier)BLOCKS.register("waxed_oxidized_copper_platform", () -> new WaxedPlatformBlock(WeatheringCopper.WeatherState.OXIDIZED, TinkerCommons.builder(MapColor.f_283745_, SoundType.f_154663_).m_60999_().m_60913_(3.0f, 6.0f).m_60955_()), BLOCK_ITEM)).build();
    public static final ItemObject<EdibleItem> bacon = ITEMS.register("bacon", () -> new EdibleItem(TinkerFood.BACON));
    public static final ItemObject<EdibleItem> jeweledApple = ITEMS.register("jeweled_apple", () -> new EdibleItem(TinkerFood.JEWELED_APPLE));
    public static final ItemObject<Item> cheeseIngot = ITEMS.register("cheese_ingot", () -> new CheeseItem(new Item.Properties().m_41489_(TinkerFood.CHEESE)));
    public static final ItemObject<Block> cheeseBlock = BLOCKS.register("cheese_block", () -> new HalfTransparentBlock(TinkerCommons.builder(MapColor.f_283832_, SoundType.f_56751_).m_60913_(1.5f, 3.0f).m_60956_(0.4f).m_60967_(0.5f).m_60955_()), block -> new CheeseBlockItem((Block)block, new Item.Properties().m_41489_(TinkerFood.CHEESE)));
    public static final ItemObject<TinkerBookItem> materialsAndYou = ITEMS.register("materials_and_you", () -> new TinkerBookItem(UNSTACKABLE_PROPS, TinkerBookItem.BookType.MATERIALS_AND_YOU));
    public static final ItemObject<TinkerBookItem> punySmelting = ITEMS.register("puny_smelting", () -> new TinkerBookItem(UNSTACKABLE_PROPS, TinkerBookItem.BookType.PUNY_SMELTING));
    public static final ItemObject<TinkerBookItem> mightySmelting = ITEMS.register("mighty_smelting", () -> new TinkerBookItem(UNSTACKABLE_PROPS, TinkerBookItem.BookType.MIGHTY_SMELTING));
    public static final ItemObject<TinkerBookItem> tinkersGadgetry = ITEMS.register("tinkers_gadgetry", () -> new TinkerBookItem(UNSTACKABLE_PROPS, TinkerBookItem.BookType.TINKERS_GADGETRY));
    public static final ItemObject<TinkerBookItem> fantasticFoundry = ITEMS.register("fantastic_foundry", () -> new TinkerBookItem(UNSTACKABLE_PROPS, TinkerBookItem.BookType.FANTASTIC_FOUNDRY));
    public static final ItemObject<TinkerBookItem> encyclopedia = ITEMS.register("encyclopedia", () -> new TinkerBookItem(UNSTACKABLE_PROPS, TinkerBookItem.BookType.ENCYCLOPEDIA));
    public static final RegistryObject<ParticleType<FluidParticleData>> fluidParticle = PARTICLE_TYPES.register("fluid", FluidParticleData.Type::new);
    public static final RegistryObject<LootItemConditionType> lootConfig = LOOT_CONDITIONS.register(ConfigEnabledCondition.ID.m_135815_(), () -> new LootItemConditionType((Serializer)ConfigEnabledCondition.SERIALIZER));
    public static final RegistryObject<LootItemConditionType> lootBlockOrEntity = LOOT_CONDITIONS.register("block_or_entity", () -> new LootItemConditionType((Serializer)new BlockOrEntityCondition.ConditionSerializer()));
    @Deprecated(forRemoval=true)
    public static final RegistryObject<LootItemConditionType> lootTagNotEmptyCondition = LOOT_CONDITIONS.register("tag_not_empty", () -> new LootItemConditionType((Serializer)new TagNotEmptyCondition.ConditionSerializer()));
    @Deprecated(forRemoval=true)
    public static final RegistryObject<LootPoolEntryType> lootTagPreference = LOOT_ENTRIES.register("tag_preference", () -> new LootPoolEntryType((Serializer)new TagPreferenceLootEntry.Serializer()));
    public static final EnumObject<SlimeType, Item> slimeball = new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.EARTH, () -> Items.f_42518_).putAll(ITEMS.registerEnum(SlimeType.TINKER, "slime_ball", type -> new Item(ITEM_PROPS))).build();
    public static final BlockContainerOpenedTrigger CONTAINER_OPENED_TRIGGER = new BlockContainerOpenedTrigger();

    public TinkerCommons() {
        TConstructCommand.init();
        MinecraftForge.EVENT_BUS.addListener(RecipeCacheInvalidator::onReloadListenerReload);
    }

    @SubscribeEvent
    void commonSetupEvent(FMLCommonSetupEvent event) {
        SlimeBounceHandler.init();
    }

    @SubscribeEvent
    void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.f_256764_) {
            CraftingHelper.register((ResourceLocation)NoContainerIngredient.ID, (IIngredientSerializer)NoContainerIngredient.Serializer.INSTANCE);
            CraftingHelper.register((ResourceLocation)BlockTagIngredient.Serializer.ID, (IIngredientSerializer)BlockTagIngredient.Serializer.INSTANCE);
            CraftingHelper.register((IConditionSerializer)ConfigEnabledCondition.SERIALIZER);
            CriteriaTriggers.m_10595_((CriterionTrigger)CONTAINER_OPENED_TRIGGER);
            CraftingHelper.register((IConditionSerializer)TagIntersectionPresentCondition.SERIALIZER);
            CraftingHelper.register((IConditionSerializer)TagDifferencePresentCondition.SERIALIZER);
            CraftingHelper.register((IConditionSerializer)new TagNotEmptyCondition.ConditionSerializer());
            DamageSourcePredicate.LOADER.register(TConstruct.getResource("direct"), TinkerPredicate.DIRECT_DAMAGE.getLoader());
            LivingEntityPredicate.LOADER.register(TConstruct.getResource("airborne"), TinkerPredicate.AIRBORNE.getLoader());
            LivingEntityPredicate.LOADER.register(TConstruct.getResource("has_effect"), HasMobEffectPredicate.LOADER);
            LivingEntityPredicate.LOADER.register(TConstruct.getResource("block_at_feet"), BlockAtFeetEntityPredicate.LOADER);
            ItemPredicate.LOADER.register(TConstruct.getResource("arrow"), TinkerPredicate.ARROW.getLoader());
            ItemPredicate.LOADER.register(TConstruct.getResource("bucket"), TinkerPredicate.BUCKET.getLoader());
            ItemPredicate.LOADER.register(TConstruct.getResource("has_container"), TinkerPredicate.HAS_CONTAINER.getLoader());
            ItemPredicate.LOADER.register(TConstruct.getResource("can_melt"), TinkerPredicate.CAN_MELT_ITEM.getLoader());
            ItemPredicate.LOADER.register(TConstruct.getResource("castable"), TinkerPredicate.CASTABLE.getLoader());
            BlockPredicate.LOADER.register(TConstruct.getResource("blocks_motion"), TinkerPredicate.BLOCKS_MOTION.getLoader());
            BlockPredicate.LOADER.register(TConstruct.getResource("can_be_replaced"), TinkerPredicate.CAN_BE_REPLACED.getLoader());
            BlockPredicate.LOADER.register(TConstruct.getResource("bush"), TinkerPredicate.BUSH.getLoader());
            BlockPredicate.LOADER.register(TConstruct.getResource("can_melt"), TinkerPredicate.CAN_MELT_BLOCK.getLoader());
            BlockPredicate.LOADER.register(TConstruct.getResource("harvest_tier"), HarvestTierPredicate.LOADER);
        }
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new ModelSpriteProvider(output, existingFileHelper));
        generator.addProvider(client, (DataProvider)new TinkerSpriteSourceProvider(output, existingFileHelper));
        generator.addProvider(client, (DataProvider)new TinkerItemModelProvider(output, existingFileHelper));
        generator.addProvider(client, (DataProvider)new TinkerBlockStateProvider(output, existingFileHelper));
        generator.addProvider(client, (DataProvider)new RenderFluidProvider(output));
        generator.addProvider(client, (DataProvider)new RenderItemProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new CommonRecipeProvider(output));
    }

    private static void addTabItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        output.m_246326_(materialsAndYou);
        output.m_246326_(punySmelting);
        output.m_246326_(mightySmelting);
        output.m_246326_(tinkersGadgetry);
        output.m_246326_(fantasticFoundry);
        output.m_246326_(encyclopedia);
        output.m_246326_(bacon);
        output.m_246326_(jeweledApple);
        output.m_246326_(cheeseIngot);
        output.m_246326_(cheeseBlock);
        output.m_246326_(clearGlass);
        TinkerCommons.accept(output, clearStainedGlass);
        output.m_246326_(clearTintedGlass);
        output.m_246326_(soulGlass);
        output.m_246326_(clearGlassPane);
        TinkerCommons.accept(output, clearStainedGlassPane);
        output.m_246326_(soulGlassPane);
        output.m_246326_(goldBars);
        output.m_246326_(obsidianPane);
        TinkerCommons.accept(output, copperPlatform);
        TinkerCommons.accept(output, waxedCopperPlatform);
        output.m_246326_(ironPlatform);
        output.m_246326_(goldPlatform);
        output.m_246326_(cobaltPlatform);
        TinkerGadgets.addTabItems(itemDisplayParameters, output);
        TinkerMaterials.addTabItems(itemDisplayParameters, output);
        TinkerModifiers.addTabItems(itemDisplayParameters, output);
    }
}

