/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand.generate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.FalseCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.predicate.ContextItemPredicate;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipe;
import slimeknights.tconstruct.shared.command.subcommand.generate.GeneratePackUtil;

public class RemoveRecipesCommand {
    private static final String KEY_SUCCESS = TConstruct.makeTranslationKey("command", "generate.remove_recipes");
    private static final DynamicCommandExceptionType ITEM_NOT_FOUND = new DynamicCommandExceptionType(id -> TConstruct.makeTranslation("command", "item.not_found", id));
    private static final DynamicCommandExceptionType PRESET_NOT_FOUND = new DynamicCommandExceptionType(id -> TConstruct.makeTranslation("command", "generate.remove_recipes.preset_not_found", id));
    private static final DynamicCommandExceptionType FAILED_SAVE = new DynamicCommandExceptionType(id -> TConstruct.makeTranslation("command", "generate.remove_recipes.failed_id", id));
    public static final Loadable<List<RecipeType<?>>> RECIPE_TYPES = TinkerLoadables.RECIPE_TYPE.list(-1);
    public static final String KEY_CASTABLE_ITEM = "castable_item";
    private static final SuggestionProvider<CommandSourceStack> SUGGESTS_RECIPES = (context, builder) -> SharedSuggestionProvider.m_82957_((Stream)((CommandSourceStack)context.getSource()).getRecipeManager().m_44073_(), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand, CommandBuildContext context) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(2))).then(Commands.m_82127_((String)"preset").then(Commands.m_82129_((String)"preset", (ArgumentType)StringArgumentType.word()).executes(RemoveRecipesCommand::runPreset)))).then(Commands.m_82127_((String)"result").then(Commands.m_82129_((String)"recipe_type", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256954_)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"result", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256913_)).executes(RemoveRecipesCommand::runByResult)).then(Commands.m_82129_((String)"input", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256913_)).executes(RemoveRecipesCommand::runResultInput)))))).then(Commands.m_82127_((String)"input").then(Commands.m_82129_((String)"recipe_type", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256954_)).then(Commands.m_82129_((String)"input", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256913_)).executes(RemoveRecipesCommand::runByInput))))).then(Commands.m_82127_((String)"id").then(Commands.m_82129_((String)"recipe", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGESTS_RECIPES).executes(RemoveRecipesCommand::byId)));
    }

    private static Predicate<Item> getPredicate(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        Either items = ResourceOrTagKeyArgument.m_246379_(context, (String)name, (ResourceKey)Registries.f_256913_, (DynamicCommandExceptionType)ITEM_NOT_FOUND).m_245276_();
        return (Predicate)items.map(key -> item -> item.m_204114_().m_203565_(key), tag -> item -> item.m_204114_().m_203656_(tag));
    }

    private static int runByResult(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        long startTime = System.nanoTime();
        Holder.Reference recipeType = ResourceArgument.m_246781_(context, (String)"recipe_type", (ResourceKey)Registries.f_256954_);
        return RemoveRecipesCommand.run(context, List.of((RecipeType)recipeType.get()), RemoveRecipesCommand.getPredicate(context, "result"), null, startTime);
    }

    private static int runByInput(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        long startTime = System.nanoTime();
        Holder.Reference recipeType = ResourceArgument.m_246781_(context, (String)"recipe_type", (ResourceKey)Registries.f_256954_);
        return RemoveRecipesCommand.run(context, List.of((RecipeType)recipeType.get()), null, RemoveRecipesCommand.getPredicate(context, "input"), startTime);
    }

    private static int runResultInput(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        long startTime = System.nanoTime();
        Holder.Reference recipeType = ResourceArgument.m_246781_(context, (String)"recipe_type", (ResourceKey)Registries.f_256954_);
        return RemoveRecipesCommand.run(context, List.of((RecipeType)recipeType.get()), RemoveRecipesCommand.getPredicate(context, "result"), RemoveRecipesCommand.getPredicate(context, "input"), startTime);
    }

    public static ResourceLocation presetLocation(String preset) {
        return TConstruct.getResource("command/remove_recipes/" + preset + ".json");
    }

    private static int runPreset(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        long startTime = System.nanoTime();
        String preset = StringArgumentType.getString(context, (String)"preset");
        ResourceLocation presetLocation = RemoveRecipesCommand.presetLocation(preset);
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        Optional resource = level.m_7654_().m_177941_().m_213713_(TConstruct.getResource("command/remove_recipes/" + preset + ".json"));
        if (resource.isPresent()) {
            JsonObject json = JsonHelper.getJson((Resource)((Resource)resource.get()), (ResourceLocation)presetLocation);
            if (json != null) {
                try {
                    ContextItemPredicate.provideContext(KEY_CASTABLE_ITEM, new CastingPredicate((Level)level));
                    IJsonPredicate remove = (IJsonPredicate)ItemPredicate.LOADER.getOrDefault(json, "result");
                    IJsonPredicate input = (IJsonPredicate)ItemPredicate.LOADER.getOrDefault(json, "input");
                    List recipeTypes = (List)RECIPE_TYPES.getIfPresent(json, "recipe_type");
                    int result = RemoveRecipesCommand.run(context, recipeTypes, remove == ItemPredicate.ANY ? null : arg_0 -> ((IJsonPredicate)remove).matches(arg_0), input == ItemPredicate.ANY ? null : arg_0 -> ((IJsonPredicate)input).matches(arg_0), startTime);
                    ContextItemPredicate.removeContext(KEY_CASTABLE_ITEM);
                    return result;
                }
                catch (RuntimeException e) {
                    TConstruct.LOG.error("Failed to parse preset {} from pack '{}'", (Object)presetLocation, (Object)((Resource)resource.get()).m_215506_(), (Object)e);
                }
            }
        } else {
            TConstruct.LOG.error("Failed to locate preset {}", (Object)presetLocation);
        }
        throw PRESET_NOT_FOUND.create((Object)preset);
    }

    private static <C extends Container, T extends Recipe<C>> int run(CommandContext<CommandSourceStack> context, List<RecipeType<?>> recipeTypes, @Nullable Predicate<Item> removeResult, @Nullable Predicate<Item> removeInput, long startTime) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        RegistryAccess access = level.m_9598_();
        ArrayList<ResourceLocation> recipes = new ArrayList<ResourceLocation>();
        for (RecipeType<?> recipeType : recipeTypes) {
            block8: for (Recipe recipe : ((CommandSourceStack)context.getSource()).m_81372_().m_7465_().m_44013_(recipeType)) {
                if (removeResult != null && !removeResult.test(recipe.m_8043_(access).m_41720_())) continue;
                if (removeInput == null) {
                    recipes.add(recipe.m_6423_());
                    continue;
                }
                for (Ingredient ingredient : recipe.m_7527_()) {
                    for (ItemStack stack : ingredient.m_43908_()) {
                        if (!removeInput.test(stack.m_41720_())) continue;
                        recipes.add(recipe.m_6423_());
                        continue block8;
                    }
                }
            }
        }
        Path pack = GeneratePackUtil.getDatapackPath(level.m_7654_());
        GeneratePackUtil.saveMcmeta(pack);
        JsonObject json = new JsonObject();
        json.add("conditions", (JsonElement)CraftingHelper.serialize((ICondition[])new ICondition[]{FalseCondition.INSTANCE}));
        String jsonString = JsonHelper.DEFAULT_GSON.toJson((JsonElement)json);
        int successes = 0;
        Path data = pack.resolve(PackType.SERVER_DATA.m_10305_());
        for (ResourceLocation id : recipes) {
            Path path = data.resolve(id.m_135827_() + "/recipes/" + id.m_135815_() + ".json");
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
                try {
                    writer.write(jsonString);
                    ++successes;
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException e) {
                TConstruct.LOG.error("Couldn't save recipe {}", (Object)id, (Object)e);
            }
        }
        int successFinal = successes;
        float time = (float)(System.nanoTime() - startTime) / 1000000.0f;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)KEY_SUCCESS, (Object[])new Object[]{successFinal, Float.valueOf(time), GeneratePackUtil.getOutputComponent(pack)}), true);
        return successes;
    }

    private static int byId(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        long startTime = System.nanoTime();
        ResourceLocation id = ResourceLocationArgument.m_107011_(context, (String)"recipe");
        Path pack = GeneratePackUtil.getDatapackPath(((CommandSourceStack)context.getSource()).m_81377_());
        GeneratePackUtil.saveMcmeta(pack);
        JsonObject json = new JsonObject();
        json.add("conditions", (JsonElement)CraftingHelper.serialize((ICondition[])new ICondition[]{FalseCondition.INSTANCE}));
        String jsonString = JsonHelper.DEFAULT_GSON.toJson((JsonElement)json);
        Path data = pack.resolve(PackType.SERVER_DATA.m_10305_());
        Path path = data.resolve(id.m_135827_() + "/recipes/" + id.m_135815_() + ".json");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(jsonString);
            }
        }
        catch (IOException e) {
            TConstruct.LOG.error("Couldn't save recipe {}", (Object)id, (Object)e);
            throw FAILED_SAVE.create((Object)id);
        }
        float time = (float)(System.nanoTime() - startTime) / 1000000.0f;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)KEY_SUCCESS, (Object[])new Object[]{1, Float.valueOf(time), GeneratePackUtil.getOutputComponent(pack)}), true);
        return 1;
    }

    private static class CastingPredicate
    implements Predicate<Item> {
        private final Level level;
        private Set<Item> items = null;

        private Set<Item> getItems() {
            if (this.items == null) {
                ArrayList<Item> builder = new ArrayList<Item>();
                RegistryAccess access = this.level.m_9598_();
                for (ICastingRecipe recipe : this.level.m_7465_().m_44013_((RecipeType)TinkerRecipeTypes.CASTING_TABLE.get())) {
                    JsonObject json;
                    ItemCastingRecipe itemCasting;
                    JsonElement element;
                    ItemStack result = recipe.m_8043_(access);
                    if (recipe instanceof ItemCastingRecipe && (element = (itemCasting = (ItemCastingRecipe)recipe).getResult().serialize(false)).isJsonObject() && (json = element.getAsJsonObject()).has("tag")) {
                        for (Holder holder : BuiltInRegistries.f_257033_.m_206058_((TagKey)Loadables.ITEM_TAG.getIfPresent(json, "tag"))) {
                            builder.add((Item)holder.get());
                        }
                        continue;
                    }
                    builder.add(result.m_41720_());
                }
                this.items = Set.copyOf(builder);
            }
            return this.items;
        }

        @Override
        public boolean test(Item item) {
            return this.getItems().contains(item);
        }

        public CastingPredicate(Level level) {
            this.level = level;
        }
    }
}

