/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand.generate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableInt;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeLookup;
import slimeknights.tconstruct.shared.command.subcommand.generate.GeneratePackUtil;

public class GenerateMeltingRecipesCommand {
    public static final ResourceLocation MELTING_CONFIGURATION = TConstruct.getResource("command/generate_melting_recipes.json");
    private static final String KEY_SUCCESS = TConstruct.makeTranslationKey("command", "generate.melting_recipes");

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand, CommandBuildContext context) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(2))).then(Commands.m_82129_((String)"recipe_type", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256954_)).executes(GenerateMeltingRecipesCommand::run));
    }

    private static <C extends Container, T extends Recipe<C>> int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ArrayList<MeltingResult> fluids;
        Item result;
        JsonObject configuration;
        long startTime = System.nanoTime();
        Holder.Reference recipeType = ResourceArgument.m_246781_(context, (String)"recipe_type", (ResourceKey)Registries.f_256954_);
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        Path pack = GeneratePackUtil.getDatapackPath(level.m_7654_());
        GeneratePackUtil.saveMcmeta(pack);
        ItemPredicate melt = ItemPredicate.ANY;
        ItemPredicate inputs = ItemPredicate.ANY;
        ItemPredicate ignore = ItemPredicate.ANY;
        Optional resource = level.m_7654_().m_177941_().m_213713_(MELTING_CONFIGURATION);
        if (resource.isPresent() && (configuration = JsonHelper.getJson((Resource)((Resource)resource.get()), (ResourceLocation)MELTING_CONFIGURATION)) != null) {
            try {
                melt = (IJsonPredicate)ItemPredicate.LOADER.getOrDefault(configuration, "melt");
                inputs = (IJsonPredicate)ItemPredicate.LOADER.getOrDefault(configuration, "inputs");
                ignore = (IJsonPredicate)ItemPredicate.LOADER.getOrDefault(configuration, "ignore");
            }
            catch (JsonParseException e) {
                TConstruct.LOG.error("Failed to parse configuration {} from pack '{}'", (Object)MELTING_CONFIGURATION, (Object)((Resource)resource.get()).m_215506_(), (Object)e);
            }
        }
        RegistryAccess access = level.m_9598_();
        Comparator<MeltingResult> nameComparator = Comparator.comparing(r -> Loadables.FLUID.getKey((Object)r.fluid.getFluid())).reversed();
        MutableInt successes = new MutableInt(0);
        Path data = pack.resolve(PackType.SERVER_DATA.m_10305_());
        Consumer<FinishedRecipe> consumer = recipe -> {
            ResourceLocation id = recipe.m_6445_();
            Path path = data.resolve(id.m_135827_() + "/recipes/" + id.m_135815_() + ".json");
            if (GeneratePackUtil.saveJson((JsonElement)recipe.m_125966_(), path)) {
                successes.increment();
            }
        };
        HashMap newRecipes = new HashMap();
        BiFunction<List, List, List> merger = (first, second) -> MeltingResult.intersection(nameComparator, first, second);
        MeltingCache cache = new MeltingCache();
        for (Object recipe2 : level.m_7465_().m_44013_((RecipeType)recipeType.get())) {
            block17: {
                ItemStack itemStack = recipe2.m_8043_(access);
                result = itemStack.m_41720_();
                if (itemStack.m_41782_() && !result.m_41465_() || !melt.matches((Object)result) || MeltingRecipeLookup.canMelt((ItemLike)result)) continue;
                fluids = new ArrayList<MeltingResult>();
                block3: for (Ingredient ingredient : recipe2.m_7527_()) {
                    if (ingredient == Ingredient.f_43901_) continue;
                    MeltingResult ingredientFluid = null;
                    boolean didIgnore = false;
                    for (ItemStack stack : ingredient.m_43908_()) {
                        if (stack.m_41782_() || !inputs.matches((Object)stack.m_41720_())) break block17;
                        MeltingResult newFluid = cache.get(stack.m_41720_());
                        if (newFluid == MeltingResult.EMPTY) {
                            if (ingredientFluid == null && ignore.matches((Object)stack.m_41720_())) {
                                didIgnore = true;
                                continue;
                            }
                            break block17;
                        }
                        if (didIgnore) break block17;
                        if (ingredientFluid == null) {
                            ingredientFluid = newFluid;
                            continue;
                        }
                        if (MeltingResult.matches(ingredientFluid, newFluid)) {
                            ingredientFluid = MeltingResult.min(ingredientFluid, newFluid);
                            continue;
                        }
                        break block17;
                    }
                    if (ingredientFluid == null) continue;
                    ListIterator<MeltingResult> iterator = fluids.listIterator();
                    while (iterator.hasNext()) {
                        MeltingResult current = (MeltingResult)iterator.next();
                        if (!MeltingResult.matches(current, ingredientFluid)) continue;
                        iterator.set(MeltingResult.merge(current, ingredientFluid));
                        continue block3;
                    }
                    fluids.add(ingredientFluid);
                }
                if (!fluids.isEmpty()) {
                    fluids.sort(nameComparator);
                    int count = itemStack.m_41613_();
                    if (count > 1) {
                        ListIterator<MeltingResult> iterator = fluids.listIterator();
                        while (iterator.hasNext()) {
                            MeltingResult current = (MeltingResult)iterator.next();
                            iterator.set(current.withAmount(current.fluid.getAmount() / count));
                        }
                    }
                    newRecipes.merge(result, fluids, merger);
                    continue;
                }
            }
            newRecipes.put(result, List.of());
        }
        MeltingRecipeLookup.freeze();
        Comparator<MeltingResult> sizeComparator = Comparator.comparing(r -> r.fluid.getAmount()).reversed();
        for (Map.Entry entry : newRecipes.entrySet()) {
            result = (Item)entry.getKey();
            fluids = (ArrayList<MeltingResult>)entry.getValue();
            if (fluids.isEmpty()) continue;
            fluids.sort(sizeComparator);
            MeltingResult first2 = (MeltingResult)fluids.get(0);
            MeltingRecipeBuilder builder = MeltingRecipeBuilder.melting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{result}), first2.toOutput(), first2.temperature, 1.0f);
            for (int i = 1; i < fluids.size(); ++i) {
                builder.addByproduct(((MeltingResult)fluids.get(i)).toOutput());
            }
            if (result.m_41465_()) {
                builder.setDamagable(10);
            }
            ResourceLocation id = Loadables.ITEM.getKey((Object)result);
            builder.save(consumer, new ResourceLocation("tinkers_generated", "melting/" + id.m_135827_() + "/" + id.m_135815_()));
        }
        MeltingRecipeLookup.unfreeze();
        float time = (float)(System.nanoTime() - startTime) / 1000000.0f;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)KEY_SUCCESS, (Object[])new Object[]{successes.intValue(), Float.valueOf(time), GeneratePackUtil.getOutputComponent(pack)}), true);
        return successes.intValue();
    }

    private static class MeltingCache {
        private final Map<Item, MeltingResult> cache = new HashMap<Item, MeltingResult>();
        private final Function<Item, MeltingResult> getter = item -> MeltingResult.from(MeltingRecipeLookup.findFluid((ItemLike)item));

        public MeltingResult get(Item item) {
            return this.cache.computeIfAbsent(item, this.getter);
        }
    }

    private record MeltingResult(FluidStack fluid, @Nullable TagKey<Fluid> tag, int temperature) {
        public static final MeltingResult EMPTY = new MeltingResult(FluidStack.EMPTY, null, 0);

        public static MeltingResult from(MeltingRecipeLookup.MeltingFluid meltingFluid) {
            FluidOutput output = meltingFluid.result();
            FluidStack fluid = output.get();
            if (fluid.isEmpty()) {
                return EMPTY;
            }
            TagKey tag = null;
            JsonObject json = new JsonObject();
            output.serialize(json);
            if (json.has("tag")) {
                tag = (TagKey)Loadables.FLUID_TAG.getIfPresent(json, "tag");
            }
            return new MeltingResult(fluid, (TagKey<Fluid>)tag, meltingFluid.temperature());
        }

        private MeltingResult withAmount(int amount) {
            if (amount <= 0) {
                return EMPTY;
            }
            FluidStack copy = this.fluid.copy();
            copy.setAmount(amount);
            return new MeltingResult(copy, this.tag, this.temperature);
        }

        public FluidOutput toOutput() {
            if (this.tag != null) {
                return FluidOutput.fromTag(this.tag, (int)this.fluid.getAmount());
            }
            return FluidOutput.fromStack((FluidStack)this.fluid);
        }

        private static MeltingResult simpler(MeltingResult first, MeltingResult second) {
            if (first.tag == null) {
                return first;
            }
            return second;
        }

        public static boolean matches(MeltingResult first, MeltingResult second) {
            if (first.tag != null && second.tag != null) {
                return first.tag.equals(second.tag);
            }
            return first.fluid.isFluidEqual(second.fluid);
        }

        public static MeltingResult merge(MeltingResult first, MeltingResult second) {
            return MeltingResult.simpler(first, second).withAmount(first.fluid.getAmount() + second.fluid.getAmount());
        }

        public static MeltingResult min(MeltingResult first, MeltingResult second) {
            int secondAmount;
            int firstAmount = first.fluid.getAmount();
            if (firstAmount == (secondAmount = second.fluid.getAmount())) {
                return MeltingResult.simpler(first, second);
            }
            if (firstAmount < secondAmount) {
                if (first.tag == null || second.tag != null) {
                    return first;
                }
                return second.withAmount(firstAmount);
            }
            if (second.tag == null || first.tag != null) {
                return second;
            }
            return first.withAmount(secondAmount);
        }

        public static List<MeltingResult> intersection(Comparator<MeltingResult> comparator, List<MeltingResult> list1, List<MeltingResult> list2) {
            if (list1.isEmpty()) {
                return list1;
            }
            if (list2.isEmpty()) {
                return list2;
            }
            Iterator<MeltingResult> iterator1 = list1.iterator();
            Iterator<MeltingResult> iterator2 = list2.iterator();
            MeltingResult value1 = iterator1.next();
            MeltingResult value2 = iterator2.next();
            ArrayList<MeltingResult> intersection = new ArrayList<MeltingResult>(Math.min(list1.size(), list2.size()));
            while (true) {
                Iterator<MeltingResult> toAdvance;
                if (MeltingResult.matches(value1, value2)) {
                    intersection.add(MeltingResult.min(value1, value2));
                    if (!iterator1.hasNext() || !iterator2.hasNext()) break;
                    iterator1.next();
                    iterator2.next();
                    continue;
                }
                int comparison = comparator.compare(value1, value2);
                assert (comparison != 0);
                Iterator<MeltingResult> iterator = toAdvance = comparison < 0 ? iterator1 : iterator2;
                if (!toAdvance.hasNext()) break;
                toAdvance.next();
            }
            return intersection;
        }
    }
}

