/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.recipe.casting.AbstractCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;

public class ItemCastingRecipe
extends AbstractCastingRecipe
implements IDisplayableCastingRecipe {
    protected static final LoadableField<FluidIngredient, ItemCastingRecipe> FLUID_FIELD = FluidIngredient.LOADABLE.requiredField("fluid", ItemCastingRecipe::getFluid);
    protected static final LoadableField<ItemOutput, ItemCastingRecipe> RESULT_FIELD = ItemOutput.Loadable.REQUIRED_ITEM.requiredField("result", r -> r.result);
    protected static final LoadableField<Integer, ItemCastingRecipe> COOLING_TIME_FIELD = IntLoadable.FROM_ONE.requiredField("cooling_time", ItemCastingRecipe::getCoolingTime);
    public static final RecordLoadable<ItemCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)CAST_FIELD, FLUID_FIELD, RESULT_FIELD, COOLING_TIME_FIELD, (RecordField)CAST_CONSUMED_FIELD, (RecordField)SWITCH_SLOTS_FIELD, ItemCastingRecipe::new);
    private final TypeAwareRecipeSerializer<?> serializer;
    protected final FluidIngredient fluid;
    protected final ItemOutput result;
    protected final int coolingTime;

    public ItemCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient cast, FluidIngredient fluid, ItemOutput result, int coolingTime, boolean consumed, boolean switchSlots) {
        super(serializer.getType(), id, group, cast, consumed, switchSlots);
        this.serializer = serializer;
        this.fluid = fluid;
        this.result = result;
        this.coolingTime = coolingTime;
    }

    @Override
    public int getFluidAmount(ICastingContainer inv) {
        return this.fluid.getAmount(inv.getFluid());
    }

    public boolean matches(ICastingContainer inv, Level worldIn) {
        return this.getCast().test(inv.getStack()) && this.fluid.test(inv.getFluid());
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result.get();
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        return this.coolingTime;
    }

    @Override
    public ResourceLocation getRecipeId() {
        return this.m_6423_();
    }

    @Override
    public boolean hasCast() {
        return this.getCast() != Ingredient.f_43901_;
    }

    @Override
    public List<ItemStack> getCastItems() {
        return Arrays.asList(this.getCast().m_43908_());
    }

    @Override
    public ItemStack getOutput() {
        return this.result.get();
    }

    @Override
    public List<FluidStack> getFluids() {
        return this.fluid.getFluids();
    }

    public TypeAwareRecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    public FluidIngredient getFluid() {
        return this.fluid;
    }

    public ItemOutput getResult() {
        return this.result;
    }

    @Override
    public int getCoolingTime() {
        return this.coolingTime;
    }
}

